/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.templates;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import nl.mpi.arbil.DownloadAbortFlag;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.data.ImdiSchema;
import nl.mpi.arbil.templates.ArbilTemplate;
import nl.mpi.arbil.templates.CmdiTemplate;

public class ArbilTemplateManager {
    private String defaultArbilTemplateName;
    private static ArbilTemplateManager singleInstance = null;
    private Hashtable<String, ArbilTemplate> templatesHashTable;
    private String[] builtInTemplates = new String[]{"Default", "Sign Language"};

    public static synchronized ArbilTemplateManager getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new ArbilTemplateManager();
        }
        return singleInstance;
    }

    public File createTemplate(String selectedTemplate) {
        if (selectedTemplate.length() == 0) {
            return null;
        }
        if (Arrays.binarySearch(this.builtInTemplates, selectedTemplate) > -1) {
            return null;
        }
        File selectedTemplateFile = this.getTemplateFile(selectedTemplate);
        selectedTemplateFile.getParentFile().mkdir();
        LinorgSessionStorage.getSingleInstance().saveRemoteResource(ImdiSchema.class.getResource("/nl/mpi/arbil/resources/templates/template.xml"), selectedTemplateFile, null, true, new DownloadAbortFlag());
        new File(selectedTemplateFile.getParentFile(), "components").mkdir();
        File examplesDirectory = new File(selectedTemplateFile.getParentFile(), "example-components");
        examplesDirectory.mkdir();
        for (String[] pathString : ArbilTemplateManager.getSingleInstance().getTemplate((String)this.builtInTemplates[0]).templatesArray) {
            LinorgSessionStorage.getSingleInstance().saveRemoteResource(ImdiSchema.class.getResource("/nl/mpi/arbil/resources/templates/" + pathString[0]), new File(examplesDirectory, pathString[0]), null, true, new DownloadAbortFlag());
        }
        LinorgSessionStorage.getSingleInstance().saveRemoteResource(ImdiSchema.class.getResource("/nl/mpi/arbil/resources/xsl/imdi-viewer.xsl"), new File(selectedTemplateFile.getParentFile(), "example-format.xsl"), null, true, new DownloadAbortFlag());
        return selectedTemplateFile;
    }

    public File getTemplateFile(String currentTemplate) {
        File currentTemplateFile = new File(this.getTemplateDirectory().getAbsolutePath() + File.separatorChar + currentTemplate + File.separatorChar + "template.xml");
        return currentTemplateFile;
    }

    public boolean defaultTemplateIsCurrentTemplate() {
        return this.defaultArbilTemplateName.equals(this.builtInTemplates[0]);
    }

    public String getCurrentTemplateName() {
        return this.defaultArbilTemplateName;
    }

    public void setCurrentTemplate(String currentTemplateLocal) {
        this.defaultArbilTemplateName = currentTemplateLocal;
        try {
            LinorgSessionStorage.getSingleInstance().saveString("CurrentTemplate", currentTemplateLocal);
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
    }

    public File getTemplateDirectory() {
        return new File(LinorgSessionStorage.getSingleInstance().storageDirectory, "templates");
    }

    public String[] getAvailableTemplates() {
        Object[] templatesList;
        File templatesDir = this.getTemplateDirectory();
        if (!templatesDir.exists()) {
            templatesDir.mkdir();
        }
        ArrayList<String> templateList = new ArrayList<String>();
        for (String string : templatesList = templatesDir.list()) {
            if (!this.getTemplateFile(string).exists()) continue;
            templateList.add(string);
        }
        for (String string : this.builtInTemplates) {
            templateList.add(string);
        }
        templatesList = templateList.toArray(new String[0]);
        Arrays.sort(templatesList);
        return templatesList;
    }

    private ArbilTemplateManager() {
        this.templatesHashTable = new Hashtable();
        this.defaultArbilTemplateName = LinorgSessionStorage.getSingleInstance().loadString("CurrentTemplate");
        if (this.defaultArbilTemplateName == null) {
            this.defaultArbilTemplateName = this.builtInTemplates[0];
            LinorgSessionStorage.getSingleInstance().saveString("CurrentTemplate", this.defaultArbilTemplateName);
        }
    }

    public ArbilTemplate getCurrentTemplate() {
        return this.getTemplate(this.defaultArbilTemplateName);
    }

    public ArbilTemplate getCmdiTemplate(String nameSpaceString) {
        if (nameSpaceString != null) {
            CmdiTemplate cmdiTemplate = (CmdiTemplate)this.templatesHashTable.get(nameSpaceString);
            if (cmdiTemplate == null) {
                cmdiTemplate = new CmdiTemplate();
                cmdiTemplate.loadTemplate(nameSpaceString);
                this.templatesHashTable.put(nameSpaceString, cmdiTemplate);
            }
            return cmdiTemplate;
        }
        GuiHelper.linorgBugCatcher.logError(new Exception("Name space URL not provided, cannot load the CMDI template, please check the XML file and ensure that the name space is specified."));
        return null;
    }

    public ArbilTemplate getTemplate(String templateName) {
        ArbilTemplate returnTemplate = new ArbilTemplate();
        if (templateName == null) {
            templateName = this.builtInTemplates[0];
        }
        if (!this.templatesHashTable.containsKey(templateName)) {
            returnTemplate.readTemplate(this.getTemplateFile(templateName), templateName);
            this.templatesHashTable.put(templateName, returnTemplate);
        } else {
            returnTemplate = this.templatesHashTable.get(templateName);
        }
        return returnTemplate;
    }
}

