/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.templates;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.clarin.CmdiProfileReader;
import nl.mpi.arbil.data.ImdiTreeObject;
import nl.mpi.arbil.templates.ArbilTemplate;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdiTemplate
extends ArbilTemplate {
    public void loadTemplate(String nameSpaceString) {
        try {
            this.loadedTemplateName = new CmdiProfileReader().getProfileName(nameSpaceString);
            File debugTempFile = File.createTempFile("templatetext", ".tmp");
            debugTempFile.deleteOnExit();
            BufferedWriter debugTemplateFileWriter = new BufferedWriter(new FileWriter(debugTempFile));
            ArrayList<String[]> childNodePathsList = new ArrayList<String[]>();
            ArrayList<String[]> resourceNodePathsList = new ArrayList<String[]>();
            ArrayList<String[]> fieldConstraintList = new ArrayList<String[]>();
            URI xsdUri = new URI(nameSpaceString);
            this.readSchema(xsdUri, childNodePathsList, resourceNodePathsList, fieldConstraintList);
            this.childNodePaths = (String[][])childNodePathsList.toArray((T[])new String[0][]);
            this.resourceNodePaths = (String[][])resourceNodePathsList.toArray((T[])new String[0][]);
            this.fieldConstraints = (String[][])fieldConstraintList.toArray((T[])new String[0][]);
            for (String[] currentArray : this.childNodePaths) {
                System.out.println("loadTemplate: " + currentArray[1] + ":" + currentArray[0]);
                debugTemplateFileWriter.write("<ChildNodePath ChildPath=\"" + currentArray[0] + "\" SubNodeName=\"" + currentArray[1] + "\" />\r\n");
            }
            for (String[] currentArray : this.resourceNodePaths) {
                System.out.println("loadTemplate: " + currentArray[1] + ":" + currentArray[0]);
                debugTemplateFileWriter.write("<ResourceNodePath RefPath=\"" + currentArray[0] + "\" RefNodeName=\"" + currentArray[1] + "\" />\r\n");
            }
            for (String[] currentArray : this.fieldConstraints) {
                System.out.println("loadTemplate: " + currentArray[1] + ":" + currentArray[0]);
                debugTemplateFileWriter.write("<FieldConstraint FieldPath=\"" + currentArray[0] + "\" Constraint=\"" + currentArray[1] + "\" />\r\n");
            }
            debugTemplateFileWriter.close();
        }
        catch (URISyntaxException urise) {
            GuiHelper.linorgBugCatcher.logError(urise);
        }
        catch (IOException urise) {
            GuiHelper.linorgBugCatcher.logError(urise);
        }
        this.requiredFields = new String[0];
        this.preferredNameFields = new String[0];
        this.fieldUsageArray = new String[0][];
        this.fieldTriggersArray = new String[0][];
        this.autoFieldsArray = new String[0][];
        this.genreSubgenreArray = new String[0][];
        this.templatesArray = new String[0][];
    }

    @Override
    public Enumeration listTypesFor(Object targetNodeUserObject) {
        String targetNodeXpath = ((ImdiTreeObject)targetNodeUserObject).getURI().getFragment();
        System.out.println("targetNodeXpath: " + targetNodeXpath);
        if (targetNodeXpath != null) {
            targetNodeXpath = targetNodeXpath.replaceAll("\\.[^\\.]+[^\\)]$", "");
            targetNodeXpath = targetNodeXpath.replaceAll("\\(\\d+\\)", "");
        }
        System.out.println("targetNodeXpath: " + targetNodeXpath);
        Vector<String[]> childTypes = new Vector<String[]>();
        if (targetNodeUserObject instanceof ImdiTreeObject) {
            for (String[] childPathString : this.childNodePaths) {
                boolean allowEntry = false;
                if (targetNodeXpath == null) {
                    allowEntry = true;
                } else if (childPathString[0].startsWith(targetNodeXpath)) {
                    allowEntry = true;
                }
                if (childPathString[0].equals(targetNodeXpath)) {
                    allowEntry = false;
                }
                if (!allowEntry) continue;
                childTypes.add(new String[]{childPathString[1], childPathString[0]});
            }
            String[][] childTypesArray = (String[][])childTypes.toArray((T[])new String[0][]);
            childTypes.removeAllElements();
            for (String[] currentChildType : childTypesArray) {
                boolean keepChildType = true;
                for (String[] subChildType : childTypesArray) {
                    if (!currentChildType[1].startsWith(subChildType[1]) || currentChildType[1].length() == subChildType[1].length()) continue;
                    keepChildType = false;
                }
                if (!keepChildType) continue;
                childTypes.add(currentChildType);
            }
            Collections.sort(childTypes, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String value1 = ((String[])o1)[0];
                    String value2 = ((String[])o2)[0];
                    return value1.compareTo(value2);
                }
            });
        }
        return childTypes.elements();
    }

    private void readSchema(URI xsdFile, ArrayList<String[]> childNodePathsList, ArrayList<String[]> resourceNodePathsList, ArrayList<String[]> fieldConstraintList) {
        File schemaFile;
        this.templateFile = schemaFile = LinorgSessionStorage.getSingleInstance().updateCache(xsdFile.toString(), 5);
        try {
            FileInputStream inputStream = new FileInputStream(schemaFile);
            XmlOptions options = new XmlOptions();
            options.setCharacterEncoding("UTF-8");
            SchemaTypeSystem sts = XmlBeans.compileXsd((XmlObject[])new XmlObject[]{XmlObject.Factory.parse((InputStream)inputStream, (XmlOptions)options)}, (SchemaTypeLoader)XmlBeans.getBuiltinTypeSystem(), null);
            SchemaType[] arr$ = sts.documentTypes();
            int len$ = arr$.length;
            int i$ = 0;
            if (i$ < len$) {
                SchemaType schemaType = arr$[i$];
                System.out.println("T-documentTypes:");
                this.constructXml(schemaType, childNodePathsList, resourceNodePathsList, fieldConstraintList, "");
            }
        }
        catch (IOException e) {
            GuiHelper.linorgBugCatcher.logError(this.templateFile.getName(), e);
            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Could not open the required template file: " + this.templateFile.getName(), "Load Clarin Template");
        }
        catch (XmlException e) {
            GuiHelper.linorgBugCatcher.logError(this.templateFile.getName(), (Exception)((Object)e));
            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Could not read the required template file: " + this.templateFile.getName(), "Load Clarin Template");
        }
    }

    private void constructXml(SchemaType schemaType, ArrayList<String[]> childNodePathsList, ArrayList<String[]> resourceNodePathsList, ArrayList<String[]> fieldConstraintList, String pathString) {
        block7: for (SchemaProperty schemaProperty : schemaType.getElementProperties()) {
            String localName = schemaProperty.getName().getLocalPart();
            String currentPathString = pathString + "." + localName;
            boolean canHaveMultiple = true;
            canHaveMultiple = schemaProperty.getMaxOccurs() == null ? true : (schemaProperty.getMaxOccurs().toString().equals("unbounded") ? true : schemaProperty.getMaxOccurs().intValue() > 1);
            boolean hasSubNodes = false;
            System.out.println("Found template element: " + currentPathString);
            SchemaType currentSchemaType = schemaProperty.getType();
            this.constructXml(currentSchemaType, childNodePathsList, resourceNodePathsList, fieldConstraintList, currentPathString);
            hasSubNodes = true;
            if (canHaveMultiple && hasSubNodes) {
                childNodePathsList.add(new String[]{currentPathString, localName});
            }
            boolean hasResourceAttribute = false;
            for (SchemaProperty attributesProperty : currentSchemaType.getAttributeProperties()) {
                if (!attributesProperty.getName().getLocalPart().equals("ref")) continue;
                hasResourceAttribute = true;
                break;
            }
            if (hasResourceAttribute) {
                resourceNodePathsList.add(new String[]{currentPathString, localName});
            }
            switch (schemaProperty.getType().getBuiltinTypeCode()) {
                case 12: {
                    System.out.println("BTC_STRING");
                    continue block7;
                }
                case 16: {
                    System.out.println("BTC_DATE");
                    fieldConstraintList.add(new String[]{currentPathString, "([0-9][0-9][0-9][0-9])((-[0-1][0-9])(-[0-3][0-9])?)?"});
                    continue block7;
                }
                case 3: {
                    System.out.println("BTC_BOOLEAN");
                    fieldConstraintList.add(new String[]{currentPathString, "true|false"});
                    continue block7;
                }
                case 6: {
                    System.out.println("BTC_ANY_URI");
                    fieldConstraintList.add(new String[]{currentPathString, "[^\\d]+://.*"});
                    continue block7;
                }
                case 0: {
                    continue block7;
                }
                default: {
                    System.out.println("uknown");
                }
            }
        }
    }
}

