/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.data.ImdiTreeObject;

class ImageBoxRenderer
extends JLabel
implements ListCellRenderer {
    int outputWidth = 200;
    int outputHeight = 130;
    int textStartX = 0;
    int textStartY = 0;
    boolean ffmpegFound = true;
    boolean imageMagickFound = true;
    String ffmpegPath = null;
    String imageMagickPath = null;
    String[] searchPathArray = new String[]{"ImageMagick\\", "/opt/local/bin/", ""};

    public ImageBoxRenderer() {
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
        this.setPreferredSize(new Dimension(this.outputWidth + 10, this.outputHeight + 50));
    }

    public boolean canDisplay(ImdiTreeObject testableObject) {
        if (testableObject.thumbnailFile != null) {
            return true;
        }
        if (!testableObject.hasLocalResource()) {
            return false;
        }
        if (testableObject.mpiMimeType == null) {
            return false;
        }
        if (testableObject.mpiMimeType.toLowerCase().contains("text")) {
            this.createThumbnail(testableObject);
        }
        if (testableObject.mpiMimeType.toLowerCase().contains("image")) {
            this.createImageThumbnail(testableObject);
            if (testableObject.thumbnailFile == null && (testableObject.mpiMimeType.toLowerCase().contains("jp") || testableObject.mpiMimeType.toLowerCase().contains("gif"))) {
                this.createThumbnail(testableObject);
            }
        }
        if (testableObject.mpiMimeType.toLowerCase().contains("video")) {
            this.createVideoThumbnail(testableObject);
        }
        return testableObject.thumbnailFile != null;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (value instanceof ImdiTreeObject) {
            ImdiTreeObject imdiObject = (ImdiTreeObject)value;
            this.setFont(list.getFont());
            this.setText(imdiObject.toString());
            if (imdiObject.thumbnailFile != null) {
                try {
                    this.setIcon(new ImageIcon(imdiObject.thumbnailFile.toURL()));
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        } else {
            this.setText(value.toString() + " (no image available)");
        }
        return this;
    }

    private void drawFileText(Graphics2D targegGraphics, URL targetURL) {
        int linePosY = this.textStartY;
        targegGraphics.setBackground(Color.white);
        targegGraphics.clearRect(0, 0, this.outputWidth, this.outputHeight);
        targegGraphics.setColor(Color.BLACK);
        targegGraphics.drawRect(0, 0, this.outputWidth - 1, this.outputHeight - 1);
        targegGraphics.setColor(Color.DARK_GRAY);
        Font currentFont = targegGraphics.getFont();
        Font renderFont = new Font(currentFont.getFontName(), currentFont.getStyle(), 11);
        targegGraphics.setFont(renderFont);
        try {
            String textToDraw;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(targetURL.openStream()));
            while ((textToDraw = bufferedReader.readLine()) != null && this.outputHeight > linePosY) {
                textToDraw = textToDraw.replaceAll("\\<.*?>", "");
                textToDraw = textToDraw.replaceAll("^\\\\[^ ]*", "");
                textToDraw = textToDraw.replaceAll("\\s+", " ");
                if ((textToDraw = textToDraw.trim()).length() <= 0) continue;
                double lineHeight = targegGraphics.getFont().getStringBounds(textToDraw, targegGraphics.getFontRenderContext()).getHeight();
                targegGraphics.drawString(textToDraw, this.textStartX + 2, linePosY += (int)lineHeight);
            }
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
    }

    private File getTargetFile(ImdiTreeObject targetImdiObject) {
        if (targetImdiObject.hasResource()) {
            return new File(targetImdiObject.getFullResourceURI());
        }
        if (targetImdiObject.isArchivableFile()) {
            return targetImdiObject.getFile();
        }
        return null;
    }

    private void createVideoThumbnail(ImdiTreeObject targetImdiObject) {
        if (this.ffmpegPath == null) {
            for (String currentPath : this.searchPathArray) {
                for (String currentSuffix : new String[]{".exe", ""}) {
                    this.ffmpegPath = currentPath + "ffmpeg" + currentSuffix;
                    if (new File(this.ffmpegPath).exists()) break;
                }
                if (new File(this.ffmpegPath).exists()) break;
            }
        }
        if (this.ffmpegFound) {
            try {
                String line;
                File iconFile = File.createTempFile("arbil", ".jpg");
                iconFile.deleteOnExit();
                File targetFile = this.getTargetFile(targetImdiObject);
                String[] execString = new String[]{this.ffmpegPath, "-itsoffset", "-4", "-i", targetFile.getCanonicalPath(), "-vframes", "1", "-s", this.outputWidth + "x" + this.outputHeight, iconFile.getAbsolutePath()};
                Process launchedProcess = Runtime.getRuntime().exec(execString);
                BufferedReader errorStreamReader = new BufferedReader(new InputStreamReader(launchedProcess.getErrorStream()));
                while ((line = errorStreamReader.readLine()) != null) {
                    System.out.println("Launched process error stream: \"" + line + "\"");
                }
                iconFile.deleteOnExit();
                if (iconFile.exists()) {
                    targetImdiObject.thumbnailFile = iconFile;
                }
            }
            catch (IOException ex) {
                this.ffmpegFound = false;
                GuiHelper.linorgBugCatcher.logError(ex);
            }
        }
    }

    private void createImageThumbnail(ImdiTreeObject targetImdiObject) {
        if (this.imageMagickPath == null) {
            for (String currentPath : this.searchPathArray) {
                for (String currentSuffix : new String[]{".exe", ""}) {
                    this.imageMagickPath = currentPath + "convert" + currentSuffix;
                    if (new File(this.imageMagickPath).exists()) break;
                }
                if (new File(this.imageMagickPath).exists()) break;
            }
        }
        if (this.imageMagickFound) {
            try {
                String line;
                File iconFile = File.createTempFile("arbil", ".jpg");
                iconFile.deleteOnExit();
                File targetFile = this.getTargetFile(targetImdiObject);
                String[] execString = new String[]{this.imageMagickPath, "-define", "jpeg:size=" + this.outputWidth * 2 + "x" + this.outputHeight * 2, targetFile.getCanonicalPath(), "-auto-orient", "-thumbnail", this.outputWidth + "x" + this.outputHeight, "-unsharp", "0x.5", iconFile.getAbsolutePath()};
                System.out.println(execString);
                Process launchedProcess = Runtime.getRuntime().exec(execString);
                BufferedReader errorStreamReader = new BufferedReader(new InputStreamReader(launchedProcess.getErrorStream()));
                while ((line = errorStreamReader.readLine()) != null) {
                    System.out.println("Launched process error stream: \"" + line + "\"");
                }
                iconFile.deleteOnExit();
                if (iconFile.exists()) {
                    targetImdiObject.thumbnailFile = iconFile;
                }
            }
            catch (Exception ex) {
                this.imageMagickFound = false;
                GuiHelper.linorgBugCatcher.logError(ex);
            }
        }
    }

    private void createThumbnail(ImdiTreeObject targetImdiObject) {
        try {
            BufferedImage resizedImg = new BufferedImage(this.outputWidth, this.outputHeight, 1);
            Graphics2D g2 = resizedImg.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            if (targetImdiObject.mpiMimeType.contains("image")) {
                ImageIcon nodeImage = new ImageIcon(this.getTargetFile(targetImdiObject).toURL());
                if (nodeImage != null) {
                    g2.drawImage(nodeImage.getImage(), 0, 0, this.outputWidth, this.outputHeight, null);
                }
            } else if (targetImdiObject.mpiMimeType.contains("text")) {
                this.drawFileText(g2, this.getTargetFile(targetImdiObject).toURL());
            }
            g2.dispose();
            File iconFile = File.createTempFile("arbil", ".jpg");
            iconFile.deleteOnExit();
            ImageIO.write((RenderedImage)resizedImg, "JPEG", iconFile);
            if (iconFile.exists()) {
                targetImdiObject.thumbnailFile = iconFile;
            }
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
    }
}

