/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import nl.mpi.arbil.FieldChangeTriggers;
import nl.mpi.arbil.ImdiVocabularies;
import nl.mpi.arbil.LinorgJournal;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.data.ImdiSchema;
import nl.mpi.arbil.data.ImdiTreeObject;

public class ImdiField {
    public ImdiTreeObject parentImdi;
    public String xmlPath;
    private String translatedPath = null;
    public String fieldValue;
    public String originalFieldValue = this.fieldValue = "";
    private int fieldOrder = -1;
    private ImdiVocabularies.Vocabulary fieldVocabulary = null;
    private boolean hasVocabularyType = false;
    public boolean vocabularyIsOpen;
    public boolean vocabularyIsList;
    private String keyName = null;
    private String originalKeyName = null;
    private String languageId = null;
    private String originalLanguageId = null;
    private int isRequiredField = -1;
    private int canValidateField = -1;
    private int siblingCount;

    public ImdiField(int fieldOrderLocal, ImdiTreeObject localParentImdi, String tempPath, String tempValue, int tempSiblingCount) {
        this.fieldOrder = fieldOrderLocal;
        this.parentImdi = localParentImdi;
        this.originalFieldValue = this.fieldValue = tempValue;
        this.xmlPath = tempPath;
        this.siblingCount = tempSiblingCount;
    }

    public boolean isRequiredField() {
        if (this.isRequiredField < 0) {
            this.isRequiredField = 0;
            String fullXmlPath = this.getGenericFullXmlPath();
            for (String currentRequiredField : this.parentImdi.getNodeTemplate().requiredFields) {
                if (!fullXmlPath.matches(currentRequiredField)) continue;
                this.isRequiredField = 1;
                break;
            }
        }
        return this.isRequiredField == 1;
    }

    public boolean fieldValueValidates() {
        return this.fieldValueValidatesToTemplate() && this.fieldValueValidatesToVocabulary();
    }

    private boolean fieldValueValidatesToVocabulary() {
        if (this.hasVocabulary() && !this.vocabularyIsOpen) {
            return null != this.getVocabulary().findVocabularyItem(this.fieldValue);
        }
        return true;
    }

    private boolean fieldValueValidatesToTemplate() {
        boolean isValidValue = true;
        if (this.canValidateField != 0) {
            this.canValidateField = 0;
            String fullXmlPath = this.getGenericFullXmlPath();
            for (String[] currentRequiredField : this.parentImdi.getNodeTemplate().fieldConstraints) {
                if (!fullXmlPath.matches(currentRequiredField[0])) continue;
                this.canValidateField = 1;
                isValidValue = this.fieldValue.matches(currentRequiredField[1]);
                break;
            }
        }
        return isValidValue;
    }

    private boolean valuesDiffer(String leftString, String rightString) {
        if (leftString == null) {
            return rightString != null;
        }
        return !leftString.equals(rightString);
    }

    public boolean fieldNeedsSaveToDisk() {
        if (this.valuesDiffer(this.originalFieldValue, this.fieldValue)) {
            return true;
        }
        if (this.valuesDiffer(this.originalLanguageId, this.languageId)) {
            return true;
        }
        return this.valuesDiffer(this.originalKeyName, this.keyName);
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public String getGenericFullXmlPath() {
        return this.getFullXmlPath().replaceAll("\\(\\d*?\\)", "(x)").replaceFirst("\\(x\\)$", "");
    }

    public String getFullXmlPath() {
        String[] pathStringArray = this.parentImdi.getUrlString().split("#");
        String returnValue = pathStringArray.length > 1 ? pathStringArray[1] + this.xmlPath : this.xmlPath;
        if (this.siblingCount > 0) {
            returnValue = returnValue + "(" + (this.siblingCount + 1) + ")";
        }
        return returnValue;
    }

    public void setFieldValue(String fieldValueToBe, boolean updateUI, boolean excludeFromUndoHistory) {
        if (!this.fieldValue.equals(fieldValueToBe = fieldValueToBe.trim())) {
            if (!excludeFromUndoHistory) {
                LinorgJournal.getSingleInstance().recordFieldChange(this, this.fieldValue, fieldValueToBe, LinorgJournal.UndoType.Value);
            }
            LinorgJournal.getSingleInstance().saveJournalEntry(this.parentImdi.getUrlString(), this.getFullXmlPath(), this.fieldValue, fieldValueToBe, "edit");
            this.fieldValue = fieldValueToBe;
            new FieldChangeTriggers().actOnChange(this);
            this.parentImdi.setImdiNeedsSaveToDisk(this, updateUI);
        }
    }

    public boolean hasVocabulary() {
        return this.fieldVocabulary != null;
    }

    public String getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(String languageIdLocal, boolean updateUI, boolean excludeFromUndoHistory) {
        String oldLanguageId = this.getLanguageId();
        boolean valueChanged = false;
        if (oldLanguageId == null && languageIdLocal == null) {
            valueChanged = false;
        } else if (languageIdLocal == null && oldLanguageId != null) {
            valueChanged = true;
        } else if (!languageIdLocal.equals(oldLanguageId)) {
            valueChanged = true;
        }
        if (valueChanged) {
            if (!excludeFromUndoHistory) {
                LinorgJournal.getSingleInstance().recordFieldChange(this, this.getLanguageId(), languageIdLocal, LinorgJournal.UndoType.LanguageId);
            }
            LinorgJournal.getSingleInstance().saveJournalEntry(this.parentImdi.getUrlString(), this.getFullXmlPath() + ":LanguageId", oldLanguageId, languageIdLocal, "edit");
            this.languageId = languageIdLocal;
            this.parentImdi.setImdiNeedsSaveToDisk(this, updateUI);
        }
    }

    public ImdiVocabularies.VocabularyItem[] getLanguageList() {
        return ImdiVocabularies.getSingleInstance().getVocabulary(this, "http://www.mpi.nl/IMDI/Schema/ISO639-2Languages.xml").getVocabularyItems();
    }

    public ImdiVocabularies.Vocabulary getVocabulary() {
        return this.fieldVocabulary;
    }

    public ImdiField[] getSiblingField(String pathString) {
        for (ImdiField[] tempField : (ImdiField[][])this.parentImdi.getFields().values().toArray((T[])new ImdiField[0][])) {
            if (!tempField[0].getFullXmlPath().equals(pathString)) continue;
            return tempField;
        }
        return null;
    }

    public boolean isDisplayable() {
        return this.fieldValue != null && !this.xmlPath.contains("CorpusLink") && !this.xmlPath.endsWith(".Keys") && !this.xmlPath.endsWith(".History");
    }

    public void finishLoading() {
    }

    public void revertChanges() {
        this.setFieldValue(this.originalFieldValue, false, false);
        this.setLanguageId(this.originalLanguageId, false, false);
        this.setKeyName(this.originalKeyName, false, false);
        boolean updateUI = true;
        this.parentImdi.setImdiNeedsSaveToDisk(this, updateUI);
    }

    public void setFieldAttribute(String cvType, String cvUrlString, String languageIdLocal, String keyNameLocal) {
        this.originalLanguageId = this.languageId = languageIdLocal;
        this.originalKeyName = this.keyName = keyNameLocal;
        this.hasVocabularyType = false;
        if (cvType != null) {
            if (cvType.equals("OpenVocabularyList")) {
                this.vocabularyIsList = true;
                this.vocabularyIsOpen = true;
                this.hasVocabularyType = true;
            } else if (cvType.equals("OpenVocabulary")) {
                this.vocabularyIsList = false;
                this.vocabularyIsOpen = true;
                this.hasVocabularyType = true;
            } else if (cvType.equals("ClosedVocabularyList")) {
                this.vocabularyIsList = true;
                this.vocabularyIsOpen = false;
                this.hasVocabularyType = true;
            } else if (cvType.equals("ClosedVocabulary")) {
                this.vocabularyIsList = false;
                this.vocabularyIsOpen = false;
                this.hasVocabularyType = true;
            }
        }
        if (this.hasVocabularyType && cvUrlString != null && cvUrlString.length() > 0) {
            this.fieldVocabulary = ImdiVocabularies.getSingleInstance().getVocabulary(this, cvUrlString);
        }
    }

    public String toString() {
        return this.fieldValue;
    }

    public int getFieldOrder() {
        return this.fieldOrder;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyNameLocal, boolean updateUI, boolean excludeFromUndoHistory) {
        System.out.println("setKeyName: " + keyNameLocal);
        String lastValue = this.getKeyName();
        System.out.println("lastValue: " + lastValue);
        if (lastValue != null && !lastValue.equals(keyNameLocal)) {
            if (!excludeFromUndoHistory) {
                LinorgJournal.getSingleInstance().recordFieldChange(this, this.getKeyName(), keyNameLocal, LinorgJournal.UndoType.KeyName);
            }
            LinorgJournal.getSingleInstance().saveJournalEntry(this.parentImdi.getUrlString(), this.getFullXmlPath(), lastValue, keyNameLocal, "editkeyname");
            this.keyName = keyNameLocal;
            this.translatedPath = null;
            this.getTranslateFieldName();
            this.parentImdi.setImdiNeedsSaveToDisk(this, updateUI);
        }
    }

    public String getTranslateFieldName() {
        if (this.translatedPath == null) {
            String fieldName = this.xmlPath;
            fieldName = fieldName.replace(ImdiSchema.imdiPathSeparator + "METATRANSCRIPT" + ImdiSchema.imdiPathSeparator + "Session" + ImdiSchema.imdiPathSeparator + "MDGroup", "");
            fieldName = fieldName.replace(ImdiSchema.imdiPathSeparator + "METATRANSCRIPT" + ImdiSchema.imdiPathSeparator + "Session", "");
            fieldName = fieldName.replace(ImdiSchema.imdiPathSeparator + "METATRANSCRIPT" + ImdiSchema.imdiPathSeparator + "Corpus", "");
            fieldName = fieldName.replace(ImdiSchema.imdiPathSeparator + "METATRANSCRIPT" + ImdiSchema.imdiPathSeparator + "Catalogue", "");
            if ((fieldName = fieldName.replaceFirst("^\\.CMD\\.Components\\.[^\\.]+\\.", "")).endsWith("Keys.Key") && this.keyName != null) {
                fieldName = fieldName + ImdiSchema.imdiPathSeparator + this.keyName;
            }
            if (fieldName.startsWith(".")) {
                fieldName = fieldName.substring(1);
            }
            if (LinorgSessionStorage.getSingleInstance().useLanguageIdInColumnName && this.getLanguageId() != null && this.getLanguageId().length() > 0) {
                fieldName = fieldName + " [" + this.getLanguageId() + "]";
            }
            this.translatedPath = fieldName;
        }
        return this.translatedPath;
    }
}

