/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import nl.mpi.arbil.DownloadAbortFlag;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiField;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.LinorgWindowManager;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ImdiVocabularies {
    Hashtable<String, Vocabulary> vocabulariesTable = new Hashtable();
    private static ImdiVocabularies singleInstance = null;

    public static synchronized ImdiVocabularies getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new ImdiVocabularies();
        }
        return singleInstance;
    }

    private ImdiVocabularies() {
    }

    public boolean vocabularyContains(String vocabularyLocation, String valueString) {
        Vocabulary tempVocab;
        if (!this.vocabulariesTable.containsKey(vocabularyLocation)) {
            this.parseRemoteFile(vocabularyLocation);
        }
        if ((tempVocab = this.vocabulariesTable.get(vocabularyLocation)) != null) {
            return null != tempVocab.findVocabularyItem(valueString);
        }
        return false;
    }

    public void redownloadCurrentlyLoadedVocabularies() {
        int succeededCount = 0;
        for (String currentUrl : this.vocabulariesTable.keySet()) {
            if (!LinorgSessionStorage.getSingleInstance().replaceCacheCopy(currentUrl)) continue;
            ++succeededCount;
        }
        LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Downloaded " + succeededCount + " out of the " + this.vocabulariesTable.size() + " vocabularies currently in use.\nYou will need to restart the application for the new vocabularies to take effect.", "Re-download Current Vocabularies");
    }

    public Vocabulary getVocabulary(ImdiField originatingImdiField, String vocabularyLocation) {
        ImdiField[] tempField;
        if (vocabularyLocation == null) {
            return null;
        }
        String fieldPath = originatingImdiField.getGenericFullXmlPath();
        if (vocabularyLocation.endsWith("MPI-Languages.xml")) {
            boolean foundTrigger = false;
            for (String[] currentTrigger : originatingImdiField.parentImdi.getNodeTemplate().fieldTriggersArray) {
                if (!fieldPath.equals(currentTrigger[0])) continue;
                foundTrigger = true;
            }
            if (!foundTrigger && !fieldPath.equals(".METATRANSCRIPT.Session.Resources.LexiconResource(x).MetaLanguages.Language")) {
                GuiHelper.linorgBugCatcher.logError(new Exception("Missing Field Trigger for: " + fieldPath + " in " + originatingImdiField.parentImdi.getUrlString()));
            }
        }
        String vocabularyRedirectField = null;
        for (String[] currentRedirect : originatingImdiField.parentImdi.getNodeTemplate().genreSubgenreArray) {
            if (!fieldPath.equals(currentRedirect[0])) continue;
            vocabularyRedirectField = currentRedirect[1];
        }
        if (vocabularyRedirectField != null && (tempField = originatingImdiField.getSiblingField(vocabularyRedirectField)) != null) {
            String redirectFieldString = tempField[0].toString();
            Vocabulary tempVocabulary = tempField[0].getVocabulary();
            VocabularyItem redirectFieldVocabItem = tempVocabulary.findVocabularyItem(redirectFieldString);
            if (redirectFieldVocabItem != null && redirectFieldVocabItem.followUpVocabulary != null) {
                String correctedUrl;
                System.out.println("redirectFieldVocabItem.followUpVocabulary: " + redirectFieldVocabItem.followUpVocabulary);
                vocabularyLocation = correctedUrl = tempVocabulary.resolveFollowUpUrl(redirectFieldVocabItem.followUpVocabulary);
                System.out.println("redirected vocabularyLocation: " + vocabularyLocation);
            }
        }
        if (vocabularyLocation == null || vocabularyLocation.length() == 0) {
            return null;
        }
        if (!this.vocabulariesTable.containsKey(vocabularyLocation)) {
            this.parseRemoteFile(vocabularyLocation);
        }
        return this.vocabulariesTable.get(vocabularyLocation);
    }

    public synchronized void parseRemoteFile(String vocabRemoteUrl) {
        if (vocabRemoteUrl != null && !this.vocabulariesTable.containsKey(vocabRemoteUrl)) {
            File cachedFile = LinorgSessionStorage.getSingleInstance().updateCache(vocabRemoteUrl, null, false, new DownloadAbortFlag());
            if (!cachedFile.exists()) {
                String backupPath = "/nl/mpi/arbil/resources/IMDI/FallBack/" + cachedFile.getName();
                System.out.println("backupPath: " + backupPath);
                URL backUp = this.getClass().getResource(backupPath);
                if (backUp != null) {
                    LinorgSessionStorage.getSingleInstance().saveRemoteResource(backUp, cachedFile, null, true, new DownloadAbortFlag());
                }
            }
            System.out.println("parseRemoteFile: " + cachedFile);
            Vocabulary vocabulary = new Vocabulary(vocabRemoteUrl);
            this.vocabulariesTable.put(vocabRemoteUrl, vocabulary);
            try {
                SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                SAXParser saxParser = saxParserFactory.newSAXParser();
                XMLReader xmlReader = saxParser.getXMLReader();
                xmlReader.setFeature("http://xml.org/sax/features/validation", false);
                xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
                xmlReader.setContentHandler(new SaxVocabularyHandler(vocabulary));
                xmlReader.parse(cachedFile.getCanonicalPath());
            }
            catch (Exception ex) {
                LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("A controlled vocabulary could not be read.\n" + vocabRemoteUrl + "\nSome fields may not show all options.", "Load Controlled Vocabulary");
            }
        }
    }

    public class VocabularyItem
    implements Comparable {
        public String languageName;
        public String languageCode;
        public String followUpVocabulary;
        public String descriptionString;

        public VocabularyItem(String languageNameLocal, String languageCodeLocal, String followUpVocabularyLocal) {
            this.languageName = languageNameLocal;
            this.languageCode = languageCodeLocal;
            this.followUpVocabulary = followUpVocabularyLocal;
        }

        public String toString() {
            return this.languageName;
        }

        public int compareTo(Object otherObject) {
            return this.toString().compareTo(otherObject.toString());
        }
    }

    public class Vocabulary {
        private Vector<VocabularyItem> vocabularyItems = new Vector();
        public String vocabularyUrlRedirected = null;
        private String vocabularyUrl = null;

        public Vocabulary(String locationUrl) {
            this.vocabularyUrl = locationUrl;
        }

        public void addEntry(String entryString) {
            boolean itemExistsInVocab = false;
            for (VocabularyItem currentVocabularyItem : this.vocabularyItems.toArray(new VocabularyItem[0])) {
                if (!currentVocabularyItem.languageName.equals(entryString)) continue;
                itemExistsInVocab = true;
            }
            if (!itemExistsInVocab) {
                this.vocabularyItems.add(new VocabularyItem(entryString, null, null));
            }
        }

        public VocabularyItem findVocabularyItem(String searchString) {
            for (VocabularyItem currentVocabularyItem : this.vocabularyItems.toArray(new VocabularyItem[0])) {
                if (!currentVocabularyItem.languageName.equals(searchString)) continue;
                return currentVocabularyItem;
            }
            return null;
        }

        public String resolveFollowUpUrl(String folowUpString) {
            this.vocabularyUrlRedirected = folowUpString;
            String vocabUrlDirectory = this.vocabularyUrl.substring(0, this.vocabularyUrl.lastIndexOf("/") + 1);
            System.out.println("vocabUrlDirectory: " + vocabUrlDirectory);
            return vocabUrlDirectory + folowUpString;
        }

        public VocabularyItem[] getVocabularyItems() {
            return this.vocabularyItems.toArray(new VocabularyItem[0]);
        }
    }

    private class SaxVocabularyHandler
    extends DefaultHandler {
        Vocabulary collectedVocab;
        VocabularyItem currentVocabItem = null;

        public SaxVocabularyHandler(Vocabulary vocabList) {
            this.collectedVocab = vocabList;
        }

        public void characters(char[] charArray, int start, int length) {
            if (this.currentVocabItem != null) {
                String nodeContents = "";
                for (int charCounter = start; charCounter < start + length; ++charCounter) {
                    nodeContents = nodeContents + charArray[charCounter];
                }
                this.currentVocabItem.descriptionString = nodeContents;
            }
        }

        public void endElement(String uri, String localName, String qName) {
            this.currentVocabItem = null;
        }

        public void startElement(String uri, String name, String qName, Attributes atts) {
            if (name.equals("Entry")) {
                String vocabName = atts.getValue("Value");
                String vocabCode = atts.getValue("Code");
                String followUpVocab = atts.getValue("FollowUp");
                this.currentVocabItem = new VocabularyItem(vocabName, vocabCode, followUpVocab);
                this.collectedVocab.vocabularyItems.add(this.currentVocabItem);
            }
        }
    }
}

