/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.util.Enumeration;
import java.util.Hashtable;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.LinorgFieldView;
import nl.mpi.arbil.LinorgSessionStorage;

public class ImdiFieldViews {
    private Hashtable<String, LinorgFieldView> savedFieldViews;
    private String currentGlobalViewName = "";
    private static ImdiFieldViews singleInstance = null;

    public static synchronized ImdiFieldViews getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new ImdiFieldViews();
        }
        return singleInstance;
    }

    private ImdiFieldViews() {
        this.loadImdiFieldViews();
    }

    public LinorgFieldView getView(String viewName) {
        return this.savedFieldViews.get(viewName);
    }

    public LinorgFieldView getCurrentGlobalView() {
        return this.savedFieldViews.get(this.currentGlobalViewName);
    }

    public String getCurrentGlobalViewName() {
        return this.currentGlobalViewName;
    }

    public void setCurrentGlobalViewName(String nextViewName) {
        this.currentGlobalViewName = nextViewName;
        LinorgSessionStorage.getSingleInstance().saveString("currentGlobalViewName", this.currentGlobalViewName);
    }

    public Enumeration getSavedFieldViewLables() {
        return this.savedFieldViews.keys();
    }

    private void loadImdiFieldViews() {
        try {
            this.savedFieldViews = (Hashtable)LinorgSessionStorage.getSingleInstance().loadObject("savedFieldViewsV2");
            this.currentGlobalViewName = LinorgSessionStorage.getSingleInstance().loadString("currentGlobalViewName");
            if (this.currentGlobalViewName == null) {
                this.currentGlobalViewName = (String)LinorgSessionStorage.getSingleInstance().loadObject("currentGlobalViewName");
            }
        }
        catch (Exception ex) {
            System.out.println("load savedFieldViews failed: " + ex.getMessage());
            this.savedFieldViews = new Hashtable();
            LinorgFieldView currentGlobalView = new LinorgFieldView();
            this.addImdiFieldView("All", currentGlobalView);
            this.currentGlobalViewName = "All";
            LinorgFieldView fewFieldView = new LinorgFieldView();
            fewFieldView.setShowOnlyColumns(new String[]{"Name", "Description", "Title"});
            this.addImdiFieldView("Minimal", fewFieldView);
        }
    }

    public void saveViewsToFile() {
        try {
            LinorgSessionStorage.getSingleInstance().saveObject(this.savedFieldViews, "savedFieldViewsV2");
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
    }

    public boolean addImdiFieldView(String viewLabel, LinorgFieldView fieldView) {
        if (!this.savedFieldViews.containsKey(viewLabel)) {
            this.savedFieldViews.put(viewLabel, fieldView);
            this.saveViewsToFile();
            return true;
        }
        return false;
    }
}

