/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.URI;
import javax.swing.JApplet;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiTable;
import nl.mpi.arbil.ImdiTableModel;
import nl.mpi.arbil.LinorgBugCatcher;
import nl.mpi.arbil.LinorgSplitPanel;
import nl.mpi.arbil.data.ImdiLoader;

public class ArbilTableApplet
extends JApplet {
    private String tableTitle = "Arbil Table Demo";
    private ImdiTableModel imdiTableModel;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    ArbilTableApplet.this.initComponents();
                    ArbilTableApplet.this.addNodesToTable(ArbilTableApplet.this.getParameter("ImdiFileList"));
                    ArbilTableApplet.this.addShowOnlyColumnsToTable(ArbilTableApplet.this.getParameter("ShowOnlyColumns"));
                    ArbilTableApplet.this.addChildNodesToTable(ArbilTableApplet.this.getParameter("ChildNodeColumns"));
                    ArbilTableApplet.this.addHighlightToTable(ArbilTableApplet.this.getParameter("HighlightText"));
                }
            });
        }
        catch (Exception ex) {
            new LinorgBugCatcher().logError(ex);
        }
    }

    private void addNodesToTable(String nodeURLsString) {
        if (nodeURLsString != null) {
            for (String currentUrlString : nodeURLsString.split(",")) {
                try {
                    this.imdiTableModel.addSingleImdiObject(ImdiLoader.getSingleInstance().getImdiObject(this.rootPane, new URI(currentUrlString)));
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        }
    }

    private void addShowOnlyColumnsToTable(String showColumnsString) {
        if (showColumnsString != null) {
            for (String currentshowColumns : showColumnsString.split(",")) {
                this.imdiTableModel.getFieldView().addShowOnlyColumn(currentshowColumns);
            }
        }
    }

    private void addChildNodesToTable(String childNodesString) {
        if (childNodesString != null) {
            for (String currentChildNode : childNodesString.split(",")) {
                this.imdiTableModel.addChildTypeToDisplay(currentChildNode);
            }
        }
    }

    private void addHighlightToTable(String highlightableTextString) {
        if (highlightableTextString != null) {
            for (String highlightText : highlightableTextString.split(",")) {
                this.imdiTableModel.highlightMatchingText(highlightText);
            }
        }
    }

    private void initComponents() {
        this.imdiTableModel = new ImdiTableModel();
        ImdiTable imdiTable = new ImdiTable(this.imdiTableModel, this.tableTitle);
        LinorgSplitPanel imdiSplitPanel = new LinorgSplitPanel(imdiTable);
        this.imdiTableModel.hideContextMenuAndStatusBar = true;
        imdiSplitPanel.setSplitDisplay();
        this.getContentPane().add((Component)imdiSplitPanel, "Center");
    }
}

