/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.util.Comparator;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.mpi.arbil.data.ImdiTreeObject;

public class ImdiTreeNodeSorter
implements Comparator {
    public int compare(Object object1, Object object2) {
        Object userObject2;
        Object userObject1;
        if (object1 instanceof DefaultMutableTreeNode && object2 instanceof DefaultMutableTreeNode) {
            userObject1 = ((DefaultMutableTreeNode)object1).getUserObject();
            userObject2 = ((DefaultMutableTreeNode)object2).getUserObject();
        } else if (object1 instanceof ImdiTreeObject && object2 instanceof ImdiTreeObject) {
            userObject1 = (ImdiTreeObject)object1;
            userObject2 = (ImdiTreeObject)object2;
        } else {
            throw new IllegalArgumentException("not a DefaultMutableTreeNode object");
        }
        if (userObject1 instanceof ImdiTreeObject && userObject2 instanceof ImdiTreeObject) {
            int typeIdex2;
            int typeIdex1 = this.getTypeIndex((ImdiTreeObject)userObject1);
            if (typeIdex1 == (typeIdex2 = this.getTypeIndex((ImdiTreeObject)userObject2))) {
                int resultInt = userObject1.toString().compareToIgnoreCase(((ImdiTreeObject)userObject2).toString());
                if (resultInt == 0) {
                    resultInt = ((ImdiTreeObject)userObject1).getUrlString().compareToIgnoreCase(((ImdiTreeObject)userObject2).getUrlString());
                }
                return resultInt;
            }
            return typeIdex1 - typeIdex2;
        }
        throw new IllegalArgumentException("not a ImdiTreeObject object: " + object1.toString() + " : " + object2.toString());
    }

    private int getTypeIndex(ImdiTreeObject targetImdiObject) {
        if (targetImdiObject.imdiDataLoaded) {
            if (targetImdiObject.isCorpus()) {
                return 1;
            }
            if (targetImdiObject.isCatalogue()) {
                return 2;
            }
            if (targetImdiObject.isSession()) {
                return 3;
            }
            if (targetImdiObject.isImdiChild()) {
                return 4;
            }
            if (targetImdiObject.isDirectory()) {
                return 5;
            }
            return 6;
        }
        return 10;
    }
}

