/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.table.TableCellEditor;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiTable;
import nl.mpi.arbil.ImdiVocabularies;
import nl.mpi.arbil.LinorgBugCatcher;
import nl.mpi.arbil.LinorgHelp;
import nl.mpi.arbil.LinorgJournal;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.LinorgVersion;
import nl.mpi.arbil.LinorgVersionChecker;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.MimeHashQueue;
import nl.mpi.arbil.PreviewSplitPanel;
import nl.mpi.arbil.TreeHelper;
import nl.mpi.arbil.data.ImdiLoader;
import nl.mpi.arbil.data.ImdiSchema;
import nl.mpi.arbil.data.ImdiTreeObject;
import nl.mpi.arbil.importexport.ImportExportDialog;
import nl.mpi.arbil.templates.TemplateDialogue;

public class ArbilMenuBar
extends JMenuBar {
    private JMenuItem saveFileMenuItem;
    private JMenuItem showChangedNodesMenuItem;
    private JCheckBoxMenuItem saveWindowsCheckBoxMenuItem;
    private JMenuItem shortCutKeysjMenuItem;
    private JMenuItem arbilForumMenuItem;
    private JMenuItem checkForUpdatesMenuItem;
    private JMenuItem viewErrorLogMenuItem;
    private JCheckBoxMenuItem showSelectionPreviewCheckBoxMenuItem;
    private JMenuItem templatesMenu;
    private JCheckBoxMenuItem trackTableSelectionCheckBoxMenuItem;
    private JCheckBoxMenuItem useLanguageIdInColumnNameCheckBoxMenuItem;
    private JMenuItem undoMenuItem;
    private JMenu setStorageDirectoryMenu;
    private JMenu setCacheDirectoryMenu;
    private JMenu viewMenu;
    public static JMenu windowMenu;
    private JMenu optionsMenu;
    private JMenuItem pasteMenuItem;
    private JMenuItem printHelpMenuItem;
    private JMenuItem redoMenuItem;
    private JMenuItem aboutMenuItem;
    public JCheckBoxMenuItem checkNewVersionAtStartCheckBoxMenuItem;
    private JMenuItem copyMenuItem;
    private JCheckBoxMenuItem copyNewResourcesCheckBoxMenuItem;
    private JCheckBoxMenuItem checkResourcePermissionsCheckBoxMenuItem;
    private JMenuItem editFieldViewsMenuItem;
    private JMenuItem updateAllLoadedVocabulariesMenuItem;
    private JMenu editMenu;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuItem helpMenuItem;
    private JMenuItem importMenuItem;
    private PreviewSplitPanel previewSplitPanel;

    public ArbilMenuBar(PreviewSplitPanel previewSplitPanelLocal) {
        this.previewSplitPanel = previewSplitPanelLocal;
        this.fileMenu = new JMenu();
        this.saveFileMenuItem = new JMenuItem();
        this.showChangedNodesMenuItem = new JMenuItem();
        this.importMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.undoMenuItem = new JMenuItem();
        this.redoMenuItem = new JMenuItem();
        this.optionsMenu = new JMenu();
        this.templatesMenu = new JMenuItem();
        this.setStorageDirectoryMenu = new JMenu();
        this.setCacheDirectoryMenu = new JMenu();
        this.editFieldViewsMenuItem = new JMenuItem();
        this.updateAllLoadedVocabulariesMenuItem = new JMenuItem();
        this.saveWindowsCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.showSelectionPreviewCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.checkNewVersionAtStartCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.copyNewResourcesCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.checkResourcePermissionsCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.trackTableSelectionCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.useLanguageIdInColumnNameCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.viewMenu = new JMenu();
        windowMenu = new JMenu();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.helpMenuItem = new JMenuItem();
        this.shortCutKeysjMenuItem = new JMenuItem();
        this.arbilForumMenuItem = new JMenuItem();
        this.checkForUpdatesMenuItem = new JMenuItem();
        this.viewErrorLogMenuItem = new JMenuItem();
        this.printHelpMenuItem = new JMenuItem();
        this.fileMenu.setText("File");
        this.fileMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ArbilMenuBar.this.saveFileMenuItem.setEnabled(ImdiLoader.getSingleInstance().nodesNeedSave());
                ArbilMenuBar.this.showChangedNodesMenuItem.setEnabled(ImdiLoader.getSingleInstance().nodesNeedSave());
            }
        });
        this.saveFileMenuItem.setText("Save Changes");
        this.saveFileMenuItem.setEnabled(false);
        this.saveFileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ImdiLoader.getSingleInstance().saveNodesNeedingSave(true);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.fileMenu.add(this.saveFileMenuItem);
        this.showChangedNodesMenuItem.setText("Show Modified Nodes");
        this.showChangedNodesMenuItem.setEnabled(false);
        this.showChangedNodesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArrayList<ImdiTreeObject> individualChangedNodes = new ArrayList<ImdiTreeObject>();
                    for (ImdiTreeObject currentTestable : ImdiLoader.getSingleInstance().getNodesNeedSave()) {
                        if (currentTestable.hasChangedFields()) {
                            individualChangedNodes.add(currentTestable);
                        }
                        for (ImdiTreeObject currentChildSaveable : currentTestable.getAllChildren()) {
                            if (!currentChildSaveable.hasChangedFields()) continue;
                            individualChangedNodes.add(currentChildSaveable);
                        }
                    }
                    LinorgWindowManager.getSingleInstance().openFloatingTable(individualChangedNodes.toArray(new ImdiTreeObject[0]), "Modified Nodes");
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.fileMenu.add(this.showChangedNodesMenuItem);
        this.importMenuItem.setText("Import");
        this.importMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.importMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.fileMenu.add(this.importMenuItem);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.exitMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.editMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ArbilMenuBar.this.undoMenuItem.setEnabled(LinorgJournal.getSingleInstance().canUndo());
                ArbilMenuBar.this.redoMenuItem.setEnabled(LinorgJournal.getSingleInstance().canRedo());
            }
        });
        this.copyMenuItem.setText("Copy");
        this.copyMenuItem.setEnabled(false);
        this.pasteMenuItem.setText("Paste");
        this.pasteMenuItem.setEnabled(false);
        this.undoMenuItem.setText("Undo");
        this.undoMenuItem.setEnabled(false);
        this.undoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    LinorgJournal.getSingleInstance().undoFromFieldChangeHistory();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.editMenu.add(this.undoMenuItem);
        this.redoMenuItem.setText("Redo");
        this.redoMenuItem.setEnabled(false);
        this.redoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    LinorgJournal.getSingleInstance().redoFromFieldChangeHistory();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.editMenu.add(this.redoMenuItem);
        this.add(this.editMenu);
        this.optionsMenu.setText("Options");
        this.templatesMenu.setText("Templates & Profiles");
        this.templatesMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TemplateDialogue.showTemplatesDialogue();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.optionsMenu.add(this.templatesMenu);
        this.setCacheDirectoryMenu.setText("Local Corpus Storage Directory");
        this.setCacheDirectoryMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ArbilMenuBar.this.setCacheDirectoryMenu.removeAll();
                JMenuItem cacheDirectoryMenuItem = new JMenuItem();
                cacheDirectoryMenuItem.setText(LinorgSessionStorage.getSingleInstance().getCacheDirectory().getAbsolutePath());
                JMenuItem changeCacheDirectoryMenuItem = new JMenuItem();
                changeCacheDirectoryMenuItem.setText("<Move Local Corpus Storage Directory>");
                changeCacheDirectoryMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        try {
                            LinorgWindowManager.getSingleInstance().offerUserToSaveChanges();
                            File[] selectedFiles = LinorgWindowManager.getSingleInstance().showFileSelectBox("Move Local Corpus Storage Directory", true, false, false);
                            if (selectedFiles != null && selectedFiles.length > 0) {
                                LinorgSessionStorage.getSingleInstance().changeCacheDirectory(selectedFiles[0], true);
                            }
                        }
                        catch (Exception ex) {
                            GuiHelper.linorgBugCatcher.logError(ex);
                        }
                    }
                });
                ArbilMenuBar.this.setCacheDirectoryMenu.add(cacheDirectoryMenuItem);
                ArbilMenuBar.this.setCacheDirectoryMenu.add(changeCacheDirectoryMenuItem);
            }
        });
        this.setStorageDirectoryMenu.setText("Configuration Files Directory");
        this.setStorageDirectoryMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ArbilMenuBar.this.populateStorageLocationMenu(ArbilMenuBar.this.setStorageDirectoryMenu);
            }
        });
        JMenu localStorageDirectoriesMenu = new JMenu("Local Storage Directories");
        localStorageDirectoriesMenu.add(this.setStorageDirectoryMenu);
        localStorageDirectoriesMenu.add(this.setCacheDirectoryMenu);
        this.optionsMenu.add(localStorageDirectoriesMenu);
        this.editFieldViewsMenuItem.setText("Field Views");
        this.editFieldViewsMenuItem.setEnabled(false);
        this.optionsMenu.add(this.editFieldViewsMenuItem);
        this.updateAllLoadedVocabulariesMenuItem.setText("Re-download Current Vocabularies");
        this.updateAllLoadedVocabulariesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImdiVocabularies.getSingleInstance().redownloadCurrentlyLoadedVocabularies();
            }
        });
        this.optionsMenu.add(this.updateAllLoadedVocabulariesMenuItem);
        this.saveWindowsCheckBoxMenuItem.setSelected(true);
        this.saveWindowsCheckBoxMenuItem.setText("Save Windows on Exit");
        this.optionsMenu.add(this.saveWindowsCheckBoxMenuItem);
        this.showSelectionPreviewCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.showSelectionPreviewCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 4));
        this.showSelectionPreviewCheckBoxMenuItem.setSelected(true);
        this.showSelectionPreviewCheckBoxMenuItem.setText("Show Selection Preview");
        this.showSelectionPreviewCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.showSelectionPreviewCheckBoxMenuItemActionPerformed(evt);
                    LinorgSessionStorage.getSingleInstance().saveBoolean("showSelectionPreview", ArbilMenuBar.this.showSelectionPreviewCheckBoxMenuItem.isSelected());
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.optionsMenu.add(this.showSelectionPreviewCheckBoxMenuItem);
        this.checkNewVersionAtStartCheckBoxMenuItem.setSelected(true);
        this.checkNewVersionAtStartCheckBoxMenuItem.setText("Check for new version on start");
        this.optionsMenu.add(this.checkNewVersionAtStartCheckBoxMenuItem);
        this.copyNewResourcesCheckBoxMenuItem.setSelected(true);
        this.copyNewResourcesCheckBoxMenuItem.setText("Copy new resources into cache");
        this.copyNewResourcesCheckBoxMenuItem.setToolTipText("When adding a new resource to a session copy the file into the local cache.");
        this.copyNewResourcesCheckBoxMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ImdiSchema.getSingleInstance().copyNewResourcesToCache = ArbilMenuBar.this.copyNewResourcesCheckBoxMenuItem.isSelected();
                LinorgSessionStorage.getSingleInstance().saveBoolean("copyNewResources", ArbilMenuBar.this.copyNewResourcesCheckBoxMenuItem.isSelected());
            }
        });
        this.optionsMenu.add(this.copyNewResourcesCheckBoxMenuItem);
        this.checkResourcePermissionsCheckBoxMenuItem.setSelected(true);
        this.checkResourcePermissionsCheckBoxMenuItem.setText("Check permissions for remote resources");
        this.checkResourcePermissionsCheckBoxMenuItem.setToolTipText("This option checks the server permissions for remote resources and shows icons accordingly.");
        this.checkResourcePermissionsCheckBoxMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                MimeHashQueue.getSingleInstance().checkResourcePermissions = ArbilMenuBar.this.checkResourcePermissionsCheckBoxMenuItem.isSelected();
                LinorgSessionStorage.getSingleInstance().saveBoolean("checkResourcePermissions", ArbilMenuBar.this.checkResourcePermissionsCheckBoxMenuItem.isSelected());
            }
        });
        this.optionsMenu.add(this.checkResourcePermissionsCheckBoxMenuItem);
        this.trackTableSelectionCheckBoxMenuItem.setText("Track Table Selection in Tree");
        this.trackTableSelectionCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    LinorgSessionStorage.getSingleInstance().trackTableSelection = ArbilMenuBar.this.trackTableSelectionCheckBoxMenuItem.getState();
                    LinorgSessionStorage.getSingleInstance().saveBoolean("trackTableSelection", ArbilMenuBar.this.trackTableSelectionCheckBoxMenuItem.isSelected());
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.optionsMenu.add(this.trackTableSelectionCheckBoxMenuItem);
        this.useLanguageIdInColumnNameCheckBoxMenuItem.setText("Show Language in Column Name");
        this.useLanguageIdInColumnNameCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    LinorgWindowManager.getSingleInstance().offerUserToSaveChanges();
                    LinorgSessionStorage.getSingleInstance().useLanguageIdInColumnName = ArbilMenuBar.this.useLanguageIdInColumnNameCheckBoxMenuItem.getState();
                    LinorgSessionStorage.getSingleInstance().saveBoolean("useLanguageIdInColumnName", ArbilMenuBar.this.useLanguageIdInColumnNameCheckBoxMenuItem.isSelected());
                    ImdiLoader.getSingleInstance().requestReloadAllNodes();
                }
                catch (Exception ex) {
                    ArbilMenuBar.this.useLanguageIdInColumnNameCheckBoxMenuItem.setSelected(LinorgSessionStorage.getSingleInstance().useLanguageIdInColumnName);
                }
            }
        });
        this.optionsMenu.add(this.useLanguageIdInColumnNameCheckBoxMenuItem);
        this.add(this.optionsMenu);
        this.viewMenu.setText("Column Views");
        this.viewMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ArbilMenuBar.this.viewMenuMenuSelected(evt);
            }
        });
        this.add(this.viewMenu);
        windowMenu.setText("Window");
        this.add(windowMenu);
        this.helpMenu.setText("Help");
        this.helpMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ArbilMenuBar.this.viewErrorLogMenuItem.setEnabled(new LinorgBugCatcher().getLogFile().exists());
            }
        });
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.aboutMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.helpMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpMenuItem.setText("Help");
        this.helpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.helpMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.helpMenu.add(this.helpMenuItem);
        this.arbilForumMenuItem.setText("Arbil Clarin Forum (Website)");
        this.arbilForumMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    GuiHelper.getSingleInstance().openFileInExternalApplication(new URI("http://www.lat-mpi.eu/tools/arbil/Arbil-forum/post201004261386765572"));
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.helpMenu.add(this.arbilForumMenuItem);
        this.viewErrorLogMenuItem.setText("View Error Log");
        this.viewErrorLogMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    GuiHelper.getSingleInstance().openFileInExternalApplication(new LinorgBugCatcher().getLogFile().toURI());
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.helpMenu.add(this.viewErrorLogMenuItem);
        this.checkForUpdatesMenuItem.setText("Check for Updates");
        this.checkForUpdatesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (!new LinorgVersionChecker().forceUpdateCheck()) {
                        LinorgVersion linorgVersion = new LinorgVersion();
                        String versionString = linorgVersion.currentMajor + "." + linorgVersion.currentMinor + "." + linorgVersion.currentRevision;
                        LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("No updates found, current version is " + versionString, "Check for Updates");
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.helpMenu.add(this.checkForUpdatesMenuItem);
        this.shortCutKeysjMenuItem.setText("Short Cut Keys");
        this.shortCutKeysjMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.shortCutKeysjMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.helpMenu.add(this.shortCutKeysjMenuItem);
        this.printHelpMenuItem.setText("Print Help File");
        this.printHelpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilMenuBar.this.printHelpMenuItemActionPerformed(evt);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.helpMenu.add(this.printHelpMenuItem);
        this.add(this.helpMenu);
        this.showSelectionPreviewCheckBoxMenuItem.setSelected(LinorgSessionStorage.getSingleInstance().loadBoolean("showSelectionPreview", true));
        this.showSelectionPreviewCheckBoxMenuItemActionPerformed(null);
        this.trackTableSelectionCheckBoxMenuItem.setSelected(LinorgSessionStorage.getSingleInstance().trackTableSelection);
        this.useLanguageIdInColumnNameCheckBoxMenuItem.setSelected(LinorgSessionStorage.getSingleInstance().useLanguageIdInColumnName);
        this.checkNewVersionAtStartCheckBoxMenuItem.setSelected(LinorgSessionStorage.getSingleInstance().loadBoolean("checkNewVersionAtStart", true));
        this.copyNewResourcesCheckBoxMenuItem.setSelected(LinorgSessionStorage.getSingleInstance().loadBoolean("copyNewResources", true));
        ImdiSchema.getSingleInstance().copyNewResourcesToCache = this.copyNewResourcesCheckBoxMenuItem.isSelected();
        this.checkResourcePermissionsCheckBoxMenuItem.setSelected(LinorgSessionStorage.getSingleInstance().loadBoolean("checkResourcePermissions", true));
        MimeHashQueue.getSingleInstance().checkResourcePermissions = this.checkResourcePermissionsCheckBoxMenuItem.isSelected();
        this.saveWindowsCheckBoxMenuItem.setSelected(LinorgSessionStorage.getSingleInstance().loadBoolean("saveWindows", true));
        this.showSelectionPreviewCheckBoxMenuItemActionPerformed(null);
        this.printHelpMenuItem.setVisible(false);
        this.setUpHotKeys();
    }

    private void setUpHotKeys() {
        this.saveFileMenuItem.setMnemonic(83);
        this.saveFileMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 3));
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            public void eventDispatched(AWTEvent event) {
                if ((((KeyEvent)event).isMetaDown() || ((KeyEvent)event).isControlDown()) && event.getID() == 402) {
                    for (Component compFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); compFocusOwner != null; compFocusOwner = compFocusOwner.getParent()) {
                        TableCellEditor currentEditor;
                        if (!(compFocusOwner instanceof ImdiTable) || (currentEditor = ((ImdiTable)compFocusOwner).getCellEditor()) == null) continue;
                        currentEditor.stopCellEditing();
                        break;
                    }
                    if (((KeyEvent)event).getKeyCode() == 83) {
                        ImdiLoader.getSingleInstance().saveNodesNeedingSave(true);
                    }
                    if (((KeyEvent)event).getKeyCode() == 90) {
                        if (((KeyEvent)event).isShiftDown()) {
                            LinorgJournal.getSingleInstance().redoFromFieldChangeHistory();
                        } else {
                            LinorgJournal.getSingleInstance().undoFromFieldChangeHistory();
                        }
                    }
                    if (((KeyEvent)event).getKeyCode() == 89) {
                        LinorgJournal.getSingleInstance().redoFromFieldChangeHistory();
                    }
                }
            }
        }, 8L);
    }

    private void viewMenuMenuSelected(MenuEvent evt) {
        GuiHelper.getSingleInstance().initViewMenu(this.viewMenu);
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.performCleanExit();
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        LinorgWindowManager.getSingleInstance().openAboutPage();
    }

    private void shortCutKeysjMenuItemActionPerformed(ActionEvent evt) {
        LinorgHelp helpComponent = LinorgHelp.getSingleInstance();
        if (null == LinorgWindowManager.getSingleInstance().focusWindow(LinorgHelp.helpWindowTitle)) {
            LinorgWindowManager.getSingleInstance().createWindow(LinorgHelp.helpWindowTitle, helpComponent);
        }
        helpComponent.setCurrentPage(LinorgHelp.ShorCutKeysPage);
    }

    private void helpMenuItemActionPerformed(ActionEvent evt) {
        if (null == LinorgWindowManager.getSingleInstance().focusWindow(LinorgHelp.helpWindowTitle)) {
            LinorgWindowManager.getSingleInstance().createWindow(LinorgHelp.helpWindowTitle, LinorgHelp.getSingleInstance());
        }
    }

    private void importMenuItemActionPerformed(ActionEvent evt) {
        try {
            ImportExportDialog importExportDialog = new ImportExportDialog(TreeHelper.getSingleInstance().arbilTreePanel.remoteCorpusTree);
            importExportDialog.importImdiBranch();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private void printHelpMenuItemActionPerformed(ActionEvent evt) {
        if (null == LinorgWindowManager.getSingleInstance().focusWindow(LinorgHelp.helpWindowTitle)) {
            LinorgWindowManager.getSingleInstance().createWindow(LinorgHelp.helpWindowTitle, LinorgHelp.getSingleInstance());
        }
        LinorgHelp.getSingleInstance().printAsOneFile();
    }

    private void showSelectionPreviewCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.previewSplitPanel.setPreviewPanel(this.showSelectionPreviewCheckBoxMenuItem.getState());
    }

    private void populateStorageLocationMenu(JMenu storageMenu) {
        storageMenu.removeAll();
        ButtonGroup storageMenuButtonGroup = new ButtonGroup();
        Object[] storageLocaations = LinorgSessionStorage.getSingleInstance().getLocationOptions();
        Arrays.sort(storageLocaations);
        ArrayList<Object> addedPaths = new ArrayList<Object>();
        for (Object currentTemplateName : storageLocaations) {
            if (((String)currentTemplateName).startsWith("null") || addedPaths.contains(currentTemplateName)) continue;
            addedPaths.add(currentTemplateName);
            JRadioButtonMenuItem templateMenuItem = new JRadioButtonMenuItem();
            templateMenuItem.setText((String)currentTemplateName);
            templateMenuItem.setName((String)currentTemplateName);
            templateMenuItem.setActionCommand((String)currentTemplateName);
            templateMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        ArbilMenuBar.this.saveApplicationState();
                        LinorgSessionStorage.getSingleInstance().changeStorageDirectory(evt.getActionCommand());
                    }
                    catch (Exception e) {
                        GuiHelper.linorgBugCatcher.logError(e);
                    }
                }
            });
            templateMenuItem.setSelected(LinorgSessionStorage.getSingleInstance().storageDirectory.equals(new File((String)currentTemplateName)));
            storageMenuButtonGroup.add(templateMenuItem);
            storageMenu.add(templateMenuItem);
        }
    }

    public boolean saveApplicationState() {
        if (ImdiLoader.getSingleInstance().nodesNeedSave()) {
            switch (JOptionPane.showConfirmDialog(this, "Save changes before exiting?", "Arbil", 1, -1)) {
                case 1: {
                    break;
                }
                case 0: {
                    ImdiLoader.getSingleInstance().saveNodesNeedingSave(false);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        GuiHelper.getSingleInstance().saveState(this.saveWindowsCheckBoxMenuItem.isSelected());
        LinorgSessionStorage.getSingleInstance().saveBoolean("saveWindows", this.saveWindowsCheckBoxMenuItem.isSelected());
        LinorgSessionStorage.getSingleInstance().saveBoolean("checkNewVersionAtStart", this.checkNewVersionAtStartCheckBoxMenuItem.isSelected());
        return true;
    }

    public void performCleanExit() {
        if (this.saveApplicationState()) {
            System.exit(0);
        }
    }
}

