/*
 * Decompiled with CFR 0.152.
 */
package mpi.imdi.api;

import java.util.Hashtable;
import mpi.imdi.api.IMDIEdit;
import mpi.imdi.api.IMDIElement;
import mpi.imdi.api.IMDIXMLFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

abstract class KeyValuePairs {
    KeyValuePairs() {
    }

    public static void getKeyValuePair(Document doc, String keyName, IMDIEdit ie, Hashtable pairs) {
        if ((keyName = KeyValuePairs.specify(doc, keyName)) == null) {
            return;
        }
        IMDIElement iElement = ie.getIMDIElement(doc, keyName);
        if (iElement == null) {
            return;
        }
        IMDIElement iElement2 = ie.getIMDIElement(doc, keyName + ".Name");
        if (iElement2 == null || iElement2.getValue() == null || iElement2.getValue().length() == 0) {
            if (iElement.getValue() != null && iElement.getValue().trim().length() != 0) {
                ie.SEPw("getKeyValuePair: Value without key at: " + keyName);
            }
        } else if (pairs.put(iElement2.getValue(), iElement.getValue()) != null) {
            ie.SEPw("getKeyValuePair: Duplicate key '" + iElement2.getValue() + "' at: " + keyName);
        }
    }

    public static Hashtable getKeyValuePairs(Document doc, String elementName, IMDIEdit ie) {
        String where;
        IMDIElement iElement;
        Hashtable retval = new Hashtable();
        if ((elementName = KeyValuePairs.specify(doc, elementName)) == null) {
            return retval;
        }
        if (elementName.indexOf(".Key") != -1) {
            KeyValuePairs.getKeyValuePair(doc, elementName, ie, retval);
            return retval;
        }
        int elementNumber = 1;
        while ((iElement = ie.getIMDIElement(doc, where = elementName + ".Key(" + elementNumber + ")")) != null) {
            KeyValuePairs.getKeyValuePair(doc, where, ie, retval);
            ++elementNumber;
        }
        return retval;
    }

    public static boolean setKeyValuePair(Document doc, String elementName, String key, String value, IMDIEdit ie) {
        boolean okay = false;
        int elementNumber = 1;
        elementName = KeyValuePairs.specify(doc, elementName);
        if (key == null || elementName == null) {
            return false;
        }
        String where = elementName;
        if (elementName.indexOf(".Key") != -1) {
            elementNumber = -1;
        }
        do {
            IMDIElement iElement;
            if (elementNumber != -1) {
                where = elementName + ".Key(" + elementNumber + ")";
            }
            if ((iElement = ie.getIMDIElement(doc, where)) != null) {
                iElement = ie.getIMDIElement(doc, where + ".Name");
                if (iElement == null || iElement.getValue() == null || iElement.getValue().length() == 0) {
                    if (value != null) {
                        okay = ie.setIMDIValue(doc, where, value);
                        okay &= ie.addIMDIElement(doc, where + ".Name") != null;
                        okay &= ie.setIMDIValue(doc, where + ".Name", key);
                        break;
                    }
                    okay = false;
                    ie.SEPw("setKeyValuePair: Tried to delete already empty pair by spec at: " + where);
                    break;
                }
                if (key.equals(iElement.getValue())) {
                    if (value == null) {
                        okay = ie.removeIMDIElement(doc, new IMDIElement(where));
                        break;
                    }
                    okay = ie.setIMDIValue(doc, where, value);
                    break;
                }
                if (elementNumber == -1) {
                    if (value == null) {
                        okay = false;
                        ie.SEPe("setKeyValuePair: Cannot delete key by spec, key name does not match at: " + where);
                        break;
                    }
                    okay = ie.setIMDIValue(doc, where, value);
                    ie.SEPw("setKeyValuePair: Changing key name for existing value selected by spec: " + where);
                    okay &= ie.setIMDIValue(doc, where + ".Name", key);
                    break;
                }
                ++elementNumber;
                continue;
            }
            if (elementNumber == -1) {
                ie.SEPe("setKeyValuePair: Tried to access non-existing pair by spec: " + where);
                break;
            }
            if (value == null) {
                ie.SEPi("setKeyValuePair: Tried to remove non-existing pair for " + where + "/" + key);
                okay = false;
                break;
            }
            iElement = ie.addIMDIElement(doc, where);
            if (iElement == null) break;
            iElement.setValue(value);
            if (ie.setIMDIElement(doc, iElement) == null) break;
            okay = ie.addIMDIElement(doc, iElement.getSpec() + ".Name") != null;
            okay &= ie.setIMDIValue(doc, iElement.getSpec() + ".Name", key);
            break;
        } while (!okay);
        if (!okay) {
            ie.SEPe("setKeyValuePair: Failed for " + where + "/" + key + ", " + value);
        }
        return okay;
    }

    private static String specify(Document doc, String domId) {
        if (domId == null || !domId.startsWith("i")) {
            return domId;
        }
        Element el = IMDIXMLFormat.getElementById(domId, doc.getDocumentElement());
        if (el == null) {
            return null;
        }
        return IMDIXMLFormat.generateSpecFromNode(el);
    }
}

