/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import nl.mpi.arbil.ImdiField;
import nl.mpi.arbil.ImdiVocabularies;
import nl.mpi.arbil.LinorgWindowManager;

public class FieldChangeTriggers {
    public void actOnChange(ImdiField changedImdiField) {
        String fieldPath = changedImdiField.getGenericFullXmlPath();
        System.out.println("fieldPath: " + fieldPath);
        for (String[] currentTrigger : changedImdiField.parentImdi.getNodeTemplate().fieldTriggersArray) {
            if (!fieldPath.equals(currentTrigger[0])) continue;
            String originalFieldPath = changedImdiField.getFullXmlPath();
            int lastBracketPos = originalFieldPath.lastIndexOf(")");
            int lastTriggerBracket = currentTrigger[1].lastIndexOf(")");
            if (lastTriggerBracket < 0) {
                LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Error in trigger from template (missing bracket): " + currentTrigger[1], "Field Trigger");
                break;
            }
            String targetFieldPath = originalFieldPath.substring(0, lastBracketPos) + currentTrigger[1].substring(lastTriggerBracket);
            System.out.println("originalFieldPath: " + originalFieldPath);
            System.out.println("targetFieldPath: " + targetFieldPath);
            ImdiField[] targetField = changedImdiField.getSiblingField(targetFieldPath);
            ImdiVocabularies.VocabularyItem vocabItem = changedImdiField.getVocabulary().findVocabularyItem(changedImdiField.fieldValue);
            if (vocabItem == null) continue;
            String valueForTargetField = null;
            if (currentTrigger[2].equals("Content")) {
                valueForTargetField = vocabItem.descriptionString;
            } else if (currentTrigger[2].equals("Value")) {
                valueForTargetField = vocabItem.languageName;
            } else if (currentTrigger[2].equals("Code")) {
                valueForTargetField = vocabItem.languageCode;
            } else if (currentTrigger[2].equals("FollowUp")) {
                valueForTargetField = vocabItem.followUpVocabulary;
            }
            if (valueForTargetField == null) continue;
            targetField[0].setFieldValue(valueForTargetField, true, false);
        }
    }
}

