/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.table.AbstractTableModel;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImageBoxRenderer;
import nl.mpi.arbil.ImdiField;
import nl.mpi.arbil.ImdiFieldViews;
import nl.mpi.arbil.ImdiListDataListener;
import nl.mpi.arbil.ImdiTableCellRenderer;
import nl.mpi.arbil.LinorgFieldView;
import nl.mpi.arbil.LinorgSplitPanel;
import nl.mpi.arbil.LinorgVersion;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.data.ImdiTreeObject;

public class ImdiTableModel
extends AbstractTableModel {
    boolean reloadRequested = false;
    boolean treeNodeSortQueueRunning = false;
    private boolean showIcons = false;
    private Hashtable<String, ImdiTreeObject> imdiObjectHash = new Hashtable();
    private HashMap<String, ImdiField> filteredColumnNames = new HashMap();
    Vector childColumnNames = new Vector();
    LinorgFieldView tableFieldView;
    boolean horizontalView = false;
    private int sortColumn = -1;
    private JLabel hiddenColumnsLabel;
    public boolean hideContextMenuAndStatusBar;
    boolean sortReverse = false;
    DefaultListModel listModel = new DefaultListModel();
    Vector highlightCells = new Vector();
    String[] singleNodeViewHeadings = new String[]{"IMDI Field", "Value"};
    private String[] columnNames = new String[0];
    private Object[][] data = new Object[0][0];
    Color[][] cellColour = new Color[0][0];

    public ImdiTableModel() {
        this.tableFieldView = ImdiFieldViews.getSingleInstance().getCurrentGlobalView().clone();
    }

    public void setHiddenColumnsLabel(JLabel hiddenColumnsLabelLocal) {
        this.hiddenColumnsLabel = hiddenColumnsLabelLocal;
    }

    public DefaultListModel getListModel(LinorgSplitPanel imdiSplitPanel) {
        ImdiListDataListener listDataListener = new ImdiListDataListener(imdiSplitPanel);
        this.listModel.addListDataListener(listDataListener);
        return this.listModel;
    }

    public void setCurrentView(LinorgFieldView localFieldView) {
        LinorgFieldView tempFieldView = localFieldView.clone();
        Enumeration oldKnowenColoumns = this.tableFieldView.getKnownColumns();
        while (oldKnowenColoumns.hasMoreElements()) {
            tempFieldView.addKnownColumn(oldKnowenColoumns.nextElement().toString());
        }
        this.tableFieldView = tempFieldView;
        this.requestReloadTableData();
    }

    public ImdiTreeObject[] getSelectedImdiNodes(int[] selectedRows) {
        ImdiTreeObject[] selectedNodesArray = new ImdiTreeObject[selectedRows.length];
        for (int selectedRowCounter = 0; selectedRowCounter < selectedRows.length; ++selectedRowCounter) {
            selectedNodesArray[selectedRowCounter] = this.getImdiNodeFromRow(selectedRows[selectedRowCounter]);
        }
        return selectedNodesArray;
    }

    public boolean containsImdiNode(ImdiTreeObject findable) {
        if (findable == null) {
            return false;
        }
        return this.imdiObjectHash.contains(findable);
    }

    public int getImdiNodeCount() {
        return this.imdiObjectHash.size();
    }

    public Enumeration getImdiNodes() {
        return this.imdiObjectHash.elements();
    }

    public String[] getImdiNodesURLs() {
        return this.imdiObjectHash.keySet().toArray(new String[0]);
    }

    public void setShowIcons(boolean localShowIcons) {
        this.showIcons = localShowIcons;
    }

    public void addImdiObjects(ImdiTreeObject[] nodesToAdd) {
        for (int draggedCounter = 0; draggedCounter < nodesToAdd.length; ++draggedCounter) {
            this.addImdiObject(nodesToAdd[draggedCounter]);
        }
        this.requestReloadTableData();
    }

    public void addImdiObjects(Enumeration nodesToAdd) {
        while (nodesToAdd.hasMoreElements()) {
            Object currentObject = nodesToAdd.nextElement();
            this.addImdiObject((ImdiTreeObject)currentObject);
        }
        this.requestReloadTableData();
    }

    public void addSingleImdiObject(ImdiTreeObject imdiTreeObject) {
        this.addImdiObject(imdiTreeObject);
        this.requestReloadTableData();
    }

    private void addImdiObject(ImdiTreeObject imdiTreeObject) {
        if (imdiTreeObject != null) {
            if (imdiTreeObject.isDirectory() || !imdiTreeObject.getParentDomNode().isLoading() && imdiTreeObject.isEmptyMetaNode()) {
                for (ImdiTreeObject currentChild : imdiTreeObject.getChildArray()) {
                    this.imdiObjectHash.put(currentChild.getUrlString(), currentChild);
                    currentChild.registerContainer(this);
                }
            } else {
                this.imdiObjectHash.put(imdiTreeObject.getUrlString(), imdiTreeObject);
                imdiTreeObject.registerContainer(this);
            }
        }
    }

    private ImdiTreeObject[] updateAllImdiObjects() {
        ImdiTreeObject[] returnImdiArray = this.imdiObjectHash.values().toArray(new ImdiTreeObject[0]);
        this.filteredColumnNames.clear();
        int hiddenColumnCount = 0;
        for (ImdiTreeObject currentRowImdi : returnImdiArray) {
            ImdiField[][] arr$ = (ImdiField[][])currentRowImdi.getFields().values().toArray((T[])new ImdiField[0][]);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                ImdiField[] currentFieldArray;
                for (ImdiField currentField : currentFieldArray = arr$[i$]) {
                    String currentColumnName = currentField.getTranslateFieldName();
                    if (this.tableFieldView.viewShowsColumn(currentColumnName)) {
                        if (!this.filteredColumnNames.containsKey(currentColumnName)) {
                            this.filteredColumnNames.put(currentColumnName, currentField);
                        } else {
                            ImdiField lastStoredField = this.filteredColumnNames.get(currentColumnName);
                            if (currentField.getFieldID() != -1 && lastStoredField.getFieldID() > currentField.getFieldID()) {
                                this.filteredColumnNames.put(currentColumnName, currentField);
                            }
                        }
                    } else {
                        ++hiddenColumnCount;
                    }
                    this.tableFieldView.addKnownColumn(currentColumnName);
                }
            }
        }
        if (this.hiddenColumnsLabel != null) {
            this.hiddenColumnsLabel.setVisible(!this.hideContextMenuAndStatusBar && hiddenColumnCount > 0);
            this.hiddenColumnsLabel.setText(hiddenColumnCount + " columns hidden (edit \"Column View\" in the table header to show)");
        }
        return returnImdiArray;
    }

    private void updateImageDisplayPanel() {
        this.listModel.removeAllElements();
        ImageBoxRenderer tempImageBoxRenderer = new ImageBoxRenderer();
        for (int rowCounter = 0; rowCounter < this.data.length; ++rowCounter) {
            ImdiTreeObject currentRowImdiObject = this.getImdiNodeFromRow(rowCounter);
            if (currentRowImdiObject == null || !tempImageBoxRenderer.canDisplay(currentRowImdiObject) || this.listModel.contains(currentRowImdiObject)) continue;
            this.listModel.addElement(currentRowImdiObject);
        }
    }

    public void removeAllImdiRows() {
        this.listModel.removeAllElements();
        Enumeration<ImdiTreeObject> removableNodes = this.imdiObjectHash.elements();
        while (removableNodes.hasMoreElements()) {
            removableNodes.nextElement().removeContainer(this);
        }
        this.imdiObjectHash.clear();
        this.filteredColumnNames.clear();
        this.columnNames = new String[0];
        this.data = new Object[0][0];
        this.cellColour = new Color[0][0];
        this.setShowIcons(this.showIcons);
        this.requestReloadTableData();
    }

    private ImdiTreeObject getImdiNodeFromRow(int rowNumber) {
        if (this.data[rowNumber][0] instanceof ImdiTreeObject) {
            return (ImdiTreeObject)this.data[rowNumber][0];
        }
        if (this.data[rowNumber][0] instanceof ImdiField[]) {
            return ((ImdiField[])this.data[rowNumber][this.columnNames.length - 1])[0].parentImdi;
        }
        return ((ImdiField)this.data[rowNumber][this.columnNames.length - 1]).parentImdi;
    }

    public void removeImdiRows(int[] selectedRows) {
        ImdiTreeObject[] nodesToRemove = new ImdiTreeObject[selectedRows.length];
        for (int selectedRowCounter = 0; selectedRowCounter < selectedRows.length; ++selectedRowCounter) {
            System.out.println("removing: " + selectedRowCounter);
            nodesToRemove[selectedRowCounter] = this.getImdiNodeFromRow(selectedRows[selectedRowCounter]);
        }
        this.removeImdiObjects(nodesToRemove);
    }

    private String joinArray(Object[] arrayToJoin) {
        String joinedString = "";
        for (Object currentArrayItem : arrayToJoin) {
            joinedString = joinedString + "," + currentArrayItem.toString();
        }
        if (joinedString.length() > 1) {
            joinedString = joinedString.substring(1);
        }
        return joinedString;
    }

    public void copyHtmlEmbedTagToClipboard(int tableHeight, int tableWidth) {
        try {
            LinorgVersion arbilVersion = new LinorgVersion();
            String embedTagString = "<APPLET CODEBASE=\"http://www.mpi.nl/tg/j2se/jnlp/arbil/\" CODE=\"nl.mpi.arbil.ArbilTableApplet.class\" ARCHIVE=\"arbil-" + arbilVersion.currentMajor + "-" + arbilVersion.currentMinor + "-" + arbilVersion.currentRevision + ".jar,lib/corpusstructure-1.6.1.jar,lib/imdiapi-1.0.6.jar,lib/log4j-1.2.14.jar,lib/saxon8.jar,lib/saxon8-dom.jar,lib/typecheck-1.5.16185.jar,lib/xalan-2.6.0.jar,lib/xercesImpl-2.9.0.jar\"";
            embedTagString = embedTagString + " WIDTH=" + tableWidth + " HEIGHT=" + tableHeight + " >\n";
            embedTagString = embedTagString + "  <PARAM NAME=\"ImdiFileList\" VALUE=\"" + this.joinArray(this.getImdiNodesURLs()) + "\">\n";
            embedTagString = embedTagString + "  <PARAM NAME=\"ShowOnlyColumns\" VALUE=\"" + this.joinArray(this.columnNames) + "\">\n";
            embedTagString = embedTagString + "  <PARAM NAME=\"ChildNodeColumns\" VALUE=\"" + this.joinArray(this.childColumnNames.toArray()) + "\">\n";
            embedTagString = embedTagString + "  <PARAM NAME=\"HighlightText\" VALUE=\"" + this.joinArray(this.highlightCells.toArray()) + "\">\n";
            embedTagString = embedTagString + "</APPLET>";
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(embedTagString);
            clipboard.setContents(stringSelection, GuiHelper.clipboardOwner);
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
    }

    public void copyImdiFields(ImdiField[] selectedCells) {
        String csvSeparator = "\t";
        String copiedString = "";
        copiedString = copiedString + "\"" + this.singleNodeViewHeadings[0] + "\"" + csvSeparator;
        copiedString = copiedString + "\"" + this.singleNodeViewHeadings[1] + "\"";
        copiedString = copiedString + "\n";
        boolean isFirstCol = true;
        for (ImdiField currentField : selectedCells) {
            if (!isFirstCol) {
                copiedString = copiedString + csvSeparator;
                isFirstCol = false;
            }
            copiedString = copiedString + "\"" + currentField.getTranslateFieldName() + "\"" + csvSeparator;
            copiedString = copiedString + "\"" + currentField.getFieldValue() + "\"";
            copiedString = copiedString + "\n";
        }
        System.out.println("copiedString: " + copiedString);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(copiedString);
        clipboard.setContents(stringSelection, GuiHelper.clipboardOwner);
    }

    public void copyImdiRows(int[] selectedRows) {
        String csvSeparator = "\t";
        String copiedString = "";
        int firstColumn = 0;
        if (this.showIcons && this.horizontalView) {
            firstColumn = 1;
        }
        int columnCount = this.getColumnCount();
        for (int selectedColCounter = firstColumn; selectedColCounter < columnCount; ++selectedColCounter) {
            copiedString = copiedString + "\"" + this.getColumnName(selectedColCounter) + "\"";
            if (selectedColCounter >= columnCount - 1) continue;
            copiedString = copiedString + csvSeparator;
        }
        copiedString = copiedString + "\n";
        for (int selectedRowCounter = 0; selectedRowCounter < selectedRows.length; ++selectedRowCounter) {
            System.out.println("copying row: " + selectedRowCounter);
            for (int selectedColCounter = firstColumn; selectedColCounter < columnCount; ++selectedColCounter) {
                copiedString = copiedString + "\"" + this.data[selectedRows[selectedRowCounter]][selectedColCounter].toString().replace("\"", "\"\"") + "\"";
                if (selectedColCounter >= columnCount - 1) continue;
                copiedString = copiedString + csvSeparator;
            }
            copiedString = copiedString + "\n";
        }
        System.out.println("copiedString: " + copiedString);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(copiedString);
        clipboard.setContents(stringSelection, GuiHelper.clipboardOwner);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String pasteIntoImdiFields(ImdiField[] selectedCells) {
        boolean pastedFieldOverwritten = false;
        int pastedCount = 0;
        String resultMessage = null;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transfer = clipboard.getContents(null);
        try {
            String clipBoardString = "";
            Object clipBoardData = transfer.getTransferData(DataFlavor.stringFlavor);
            if (clipBoardData != null) {
                clipBoardString = clipBoardData.toString();
            }
            System.out.println("clipBoardString: " + clipBoardString);
            String[] clipBoardLines = clipBoardString.split("\"\\n\"");
            if (clipBoardLines.length == 1) {
                clipBoardLines = clipBoardString.split("\n");
            }
            if (clipBoardLines.length == 1) {
                String messageString = selectedCells.length + " fields will be overwritten with the single value on the clipboard.\nContinue?";
                if (!LinorgWindowManager.getSingleInstance().showMessageDialogBox(messageString, "Paste")) return null;
                for (ImdiField targetField : selectedCells) {
                    targetField.setFieldValue(clipBoardString, true, false);
                    ++pastedCount;
                }
            } else if (clipBoardLines.length > 1) {
                String areYouSureMessageString = "";
                ArrayList<Object[]> pasteList = new ArrayList<Object[]>();
                int deletingValuesCounter = 0;
                String[] firstLine = clipBoardLines[0].split("\"\\t\"");
                if (firstLine.length == 1) {
                    firstLine = clipBoardLines[0].split("\t");
                }
                boolean singleNodeAxis = false;
                String regexString = "[(\"^)($\")]";
                System.out.println("regexString: " + firstLine[0].replaceAll(regexString, ""));
                if (firstLine[0].replaceAll(regexString, "").equals(this.singleNodeViewHeadings[0]) && firstLine[1].replaceAll(regexString, "").equals(this.singleNodeViewHeadings[1])) {
                    singleNodeAxis = true;
                }
                if (!singleNodeAxis) {
                    resultMessage = "Incorrect data to paste.\nThe data must be copied either from a table where only one IMDI file is displayed\nor by selecting individual cells in the table.";
                }
                if (singleNodeAxis) {
                    boolean pasteOneFieldToAll = clipBoardLines.length == 2;
                    HashSet<String> pastedFieldNames = new HashSet<String>();
                    for (int lineCounter = 1; lineCounter < clipBoardLines.length; ++lineCounter) {
                        String clipBoardLine = clipBoardLines[lineCounter];
                        System.out.println("clipBoardLine: " + clipBoardLine);
                        String[] clipBoardCells = clipBoardLine.split("\\t");
                        System.out.println("clipBoardCells.length: " + clipBoardCells.length);
                        if (clipBoardCells.length != 2) {
                            resultMessage = "Inconsistent number of columns in the data to paste.\nThe pasted data could be incorrect.";
                            continue;
                        }
                        String currentFieldName = clipBoardCells[0].replaceAll(regexString, "");
                        String currentFieldValue = clipBoardCells[1].replaceAll(regexString, "");
                        if (pastedFieldNames.contains(currentFieldName)) {
                            pastedFieldOverwritten = true;
                        } else {
                            pastedFieldNames.add(currentFieldName);
                        }
                        if (selectedCells == null) continue;
                        for (ImdiField targetField : selectedCells) {
                            System.out.println("targetField: " + targetField.getTranslateFieldName());
                            if (!currentFieldName.equals(targetField.getTranslateFieldName()) && !pasteOneFieldToAll) continue;
                            if (currentFieldValue.trim().length() == 0 && targetField.getFieldValue().trim().length() > 0) {
                                ++deletingValuesCounter;
                            }
                            pasteList.add(new Object[]{targetField, currentFieldValue});
                        }
                    }
                    if (pastedFieldOverwritten) {
                        areYouSureMessageString = areYouSureMessageString + "Two fields of the same name are to be pasted into this table,\nthis will cause at least one field to be overwritten by another.\n\n";
                    }
                    if (deletingValuesCounter > 0) {
                        areYouSureMessageString = areYouSureMessageString + "There are " + deletingValuesCounter + " fields that will have their contents deleted by this paste action.\n\n";
                    }
                    if (areYouSureMessageString.length() > 0 && !LinorgWindowManager.getSingleInstance().showMessageDialogBox(areYouSureMessageString + "Continue?", "Paste")) {
                        return null;
                    }
                    for (Object[] pasteListObject : pasteList) {
                        ImdiField currentField = (ImdiField)pasteListObject[0];
                        String currentValue = (String)pasteListObject[1];
                        currentField.setFieldValue(currentValue, true, false);
                        ++pastedCount;
                    }
                }
            } else {
                resultMessage = "No data to paste.";
            }
            if (pastedCount != 0) return resultMessage;
            if (resultMessage != null) return resultMessage;
            return "No fields matched the data on the clipboard.";
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
        return resultMessage;
    }

    public void removeImdiObjects(ImdiTreeObject[] nodesToRemove) {
        for (ImdiTreeObject imdiTreeObject : nodesToRemove) {
            if (imdiTreeObject == null) continue;
            System.out.println("removing: " + imdiTreeObject.toString());
            this.listModel.removeElement(imdiTreeObject);
            this.imdiObjectHash.remove(imdiTreeObject.getUrlString());
            imdiTreeObject.removeContainer(this);
        }
        this.requestReloadTableData();
    }

    public void clearCellColours() {
        this.highlightCells.clear();
        for (int rowCounter = 0; rowCounter < this.cellColour.length; ++rowCounter) {
            for (int colCounter = 0; colCounter < this.cellColour[rowCounter].length; ++colCounter) {
                this.cellColour[rowCounter][colCounter] = new Color(0xFFFFFF);
            }
        }
        this.fireTableDataChanged();
    }

    private Color[][] setCellColours(Object[][] dataTemp) {
        Color[][] cellColourTemp;
        if (dataTemp.length == 0) {
            cellColourTemp = new Color[0][0];
        } else {
            cellColourTemp = new Color[dataTemp.length][dataTemp[0].length];
            Color currentHighlightColur = new Color(0xFFFFFF);
            Enumeration currentHighlight = this.highlightCells.elements();
            while (currentHighlight.hasMoreElements()) {
                currentHighlightColur = new Color(currentHighlightColur.getGreen() - 40, currentHighlightColur.getRed(), currentHighlightColur.getBlue());
                String currentText = currentHighlight.nextElement().toString();
                for (int rowCounter = 0; rowCounter < dataTemp.length; ++rowCounter) {
                    for (int colCounter = 0; colCounter < dataTemp[rowCounter].length; ++colCounter) {
                        if (!new ImdiTableCellRenderer(dataTemp[rowCounter][colCounter]).getText().equals(currentText)) continue;
                        cellColourTemp[rowCounter][colCounter] = currentHighlightColur;
                    }
                }
            }
        }
        return cellColourTemp;
    }

    private Object[][] allocateCellData(int rows, int cols) {
        Object[][] dataTemp = new Object[rows][cols];
        return dataTemp;
    }

    private void sortTableRows(String[] columnNamesTemp, Object[][] dataTemp) {
        if (this.sortColumn < columnNamesTemp.length) {
            Arrays.sort(dataTemp, new TableRowComparator(this.sortColumn, this.sortReverse));
        }
    }

    public synchronized void requestReloadTableData() {
        this.reloadRequested = true;
        if (!this.treeNodeSortQueueRunning) {
            this.treeNodeSortQueueRunning = true;
            new Thread(){

                public void run() {
                    try {
                        while (ImdiTableModel.this.reloadRequested) {
                            ImdiTableModel.this.reloadRequested = false;
                            ImdiTableModel.this.reloadTableDataPrivate();
                        }
                    }
                    catch (Exception ex) {
                        GuiHelper.linorgBugCatcher.logError(ex);
                    }
                    ImdiTableModel.this.treeNodeSortQueueRunning = false;
                }
            }.start();
        }
    }

    private synchronized void reloadTableDataPrivate() {
        int previousColumnCount = this.getColumnCount();
        String[] columnNamesTemp = new String[]{};
        Object[][] dataTemp = new Object[0][0];
        ImdiTreeObject[] tableRowsImdiArray = this.updateAllImdiObjects();
        boolean lastHorizontalView = this.horizontalView;
        boolean bl = this.horizontalView = tableRowsImdiArray.length > 1;
        if (!this.horizontalView && this.filteredColumnNames.size() == 0) {
            this.horizontalView = true;
        }
        if (lastHorizontalView != this.horizontalView) {
            this.sortReverse = false;
            this.sortColumn = this.horizontalView ? 0 : -1;
        }
        if (this.horizontalView) {
            ImdiField[] displayedColumnNames = this.filteredColumnNames.values().toArray(new ImdiField[this.filteredColumnNames.size()]);
            Arrays.sort(displayedColumnNames, new Comparator(){

                public int compare(Object firstColumn, Object secondColumn) {
                    try {
                        int baseIntA = ((ImdiField)firstColumn).getFieldID();
                        int comparedIntA = ((ImdiField)secondColumn).getFieldID();
                        int returnValue = baseIntA - comparedIntA;
                        return returnValue;
                    }
                    catch (Exception ex) {
                        GuiHelper.linorgBugCatcher.logError(ex);
                        return 1;
                    }
                }
            });
            int firstFreeColumn = 0;
            if (this.showIcons) {
                firstFreeColumn = 1;
            }
            columnNamesTemp = new String[displayedColumnNames.length + firstFreeColumn + this.childColumnNames.size()];
            int columnPopulateCounter = firstFreeColumn;
            if (columnNamesTemp.length > 0) {
                columnNamesTemp[0] = " ";
            }
            for (ImdiField currentColumn : displayedColumnNames) {
                columnNamesTemp[columnPopulateCounter] = currentColumn.getTranslateFieldName();
                ++columnPopulateCounter;
            }
            Enumeration childColEnum = this.childColumnNames.elements();
            while (childColEnum.hasMoreElements()) {
                columnNamesTemp[columnPopulateCounter] = childColEnum.nextElement().toString();
                ++columnPopulateCounter;
            }
            dataTemp = this.allocateCellData(tableRowsImdiArray.length, columnNamesTemp.length);
            int rowCounter = 0;
            for (ImdiTreeObject currentNode : tableRowsImdiArray) {
                Hashtable<String, ImdiField[]> fieldsHash = currentNode.getFields();
                if (this.showIcons) {
                    dataTemp[rowCounter][0] = currentNode;
                }
                for (int columnCounter = firstFreeColumn; columnCounter < columnNamesTemp.length; ++columnCounter) {
                    if (columnCounter < columnNamesTemp.length - this.childColumnNames.size()) {
                        ImdiField[] currentValue = fieldsHash.get(columnNamesTemp[columnCounter]);
                        if (currentValue != null) {
                            if (currentValue.length == 1) {
                                dataTemp[rowCounter][columnCounter] = currentValue[0];
                                continue;
                            }
                            dataTemp[rowCounter][columnCounter] = currentValue;
                            continue;
                        }
                        dataTemp[rowCounter][columnCounter] = "";
                        continue;
                    }
                    dataTemp[rowCounter][columnCounter] = currentNode.getChildNodesArray(columnNamesTemp[columnCounter]);
                    if (dataTemp[rowCounter][columnCounter] != null) continue;
                    dataTemp[rowCounter][columnCounter] = "";
                }
                ++rowCounter;
            }
        } else {
            columnNamesTemp = this.singleNodeViewHeadings;
            if (tableRowsImdiArray.length == 0) {
                dataTemp = this.allocateCellData(0, columnNamesTemp.length);
            } else if (tableRowsImdiArray[0] != null) {
                Hashtable<String, ImdiField[]> fieldsHash = tableRowsImdiArray[0].getFields();
                Vector<ImdiField> allRowFields = new Vector<ImdiField>();
                Enumeration<ImdiField[]> valuesEnum = fieldsHash.elements();
                while (valuesEnum.hasMoreElements()) {
                    ImdiField[] currentFieldArray = valuesEnum.nextElement();
                    for (ImdiField currentField : currentFieldArray) {
                        if (!this.tableFieldView.viewShowsColumn(currentField.getTranslateFieldName())) continue;
                        allRowFields.add(currentField);
                    }
                }
                dataTemp = this.allocateCellData(allRowFields.size(), 2);
                int rowCounter = 0;
                Enumeration allFieldsEnum = allRowFields.elements();
                while (allFieldsEnum.hasMoreElements()) {
                    ImdiField currentField = (ImdiField)allFieldsEnum.nextElement();
                    dataTemp[rowCounter][0] = currentField.getTranslateFieldName();
                    dataTemp[rowCounter][1] = currentField;
                    ++rowCounter;
                }
            }
        }
        this.sortTableRows(columnNamesTemp, dataTemp);
        this.columnNames = columnNamesTemp;
        this.cellColour = this.setCellColours(dataTemp);
        Object[][] prevousData = this.data;
        this.data = dataTemp;
        if (previousColumnCount != this.getColumnCount() || prevousData.length != this.data.length) {
            try {
                this.fireTableStructureChanged();
            }
            catch (Exception ex) {
                GuiHelper.linorgBugCatcher.logError(ex);
            }
        } else {
            for (int rowCounter = 0; rowCounter < this.getRowCount(); ++rowCounter) {
                for (int colCounter = 0; colCounter < this.getColumnCount(); ++colCounter) {
                    this.fireTableCellUpdated(rowCounter, colCounter);
                }
            }
        }
        this.updateImageDisplayPanel();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.data.length;
    }

    public String getColumnName(int col) {
        if (col < this.columnNames.length) {
            return this.columnNames[col];
        }
        return "";
    }

    public Object getValueAt(int row, int col) {
        try {
            return this.data[row][col];
        }
        catch (Exception e) {
            return null;
        }
    }

    public Color getCellColour(int row, int col) {
        try {
            return this.cellColour[row][col];
        }
        catch (Exception e) {
            return new Color(0xFFFFFF);
        }
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public void sortByColumn(int columnIndex) {
        if (this.sortColumn == columnIndex) {
            if (this.horizontalView || !this.sortReverse) {
                this.sortReverse = !this.sortReverse;
            } else {
                this.sortColumn = -1;
            }
        } else {
            this.sortColumn = columnIndex;
            this.sortReverse = false;
        }
        System.out.println("sortByColumn: " + this.sortColumn);
        this.requestReloadTableData();
    }

    public void hideColumn(int columnIndex) {
        System.out.println("hideColumn: " + columnIndex);
        System.out.println("hideColumn: " + this.getColumnName(columnIndex));
        if (!this.childColumnNames.remove(this.getColumnName(columnIndex))) {
            this.tableFieldView.addHiddenColumn(this.getColumnName(columnIndex));
        }
        this.requestReloadTableData();
    }

    public void showOnlyCurrentColumns() {
        this.tableFieldView.setShowOnlyColumns(this.columnNames);
    }

    public LinorgFieldView getFieldView() {
        return this.tableFieldView;
    }

    public void addChildTypeToDisplay(String childType) {
        System.out.println("addChildTypeToDisplay: " + childType);
        this.childColumnNames.add(childType);
        this.requestReloadTableData();
    }

    public Object[] getChildNames() {
        Vector<String> childNames = new Vector<String>();
        Enumeration<ImdiTreeObject> imdiRowsEnum = this.imdiObjectHash.elements();
        while (imdiRowsEnum.hasMoreElements()) {
            for (ImdiTreeObject currentChild : imdiRowsEnum.nextElement().getChildArray()) {
                String currentChildName = currentChild.toString();
                if (childNames.contains(currentChildName)) continue;
                childNames.add(currentChildName);
            }
        }
        return childNames.toArray();
    }

    public void copyCellToColumn(int row, int col) {
        System.out.println("copyCellToColumn for row: " + row + " col: " + col);
        for (int rowCounter = 0; rowCounter < this.getRowCount(); ++rowCounter) {
            if (rowCounter == row) continue;
            if (this.data[rowCounter][col] instanceof ImdiField) {
                ((ImdiField)this.data[rowCounter][col]).setFieldValue(((ImdiField)this.data[row][col]).getFieldValue(), false, false);
            }
            this.fireTableCellUpdated(rowCounter, col);
        }
    }

    public void highlightMatchingText(String highlightText) {
        this.highlightCells.add(highlightText);
        this.cellColour = this.setCellColours(this.data);
        this.fireTableDataChanged();
    }

    public void highlightMatchingCells(int row, int col) {
        this.highlightCells.add(new ImdiTableCellRenderer(this.data[row][col]).getText());
        this.cellColour = this.setCellColours(this.data);
        this.fireTableDataChanged();
    }

    public Vector getMatchingRows(int sampleRowNumber) {
        System.out.println("MatchingRows for: " + sampleRowNumber);
        Vector<Integer> matchedRows = new Vector<Integer>();
        if (sampleRowNumber > -1 && sampleRowNumber < this.getRowCount()) {
            for (int rowCounter = 0; rowCounter < this.getRowCount(); ++rowCounter) {
                boolean rowMatches = true;
                for (int colCounter = 0; colCounter < this.getColumnCount(); ++colCounter) {
                    if (this.getValueAt(rowCounter, colCounter).toString().equals(this.getValueAt(sampleRowNumber, colCounter).toString())) continue;
                    rowMatches = false;
                    break;
                }
                if (!rowMatches) continue;
                matchedRows.add(rowCounter);
            }
        }
        return matchedRows;
    }

    private class TableRowComparator
    implements Comparator {
        int sortColumn = 0;
        boolean sortReverse = false;

        public TableRowComparator(int tempSortColumn, boolean tempSortReverse) {
            this.sortColumn = tempSortColumn;
            this.sortReverse = tempSortReverse;
        }

        public int compare(Object firstRowArray, Object secondRowArray) {
            if (this.sortColumn >= 0) {
                String baseValueA = new ImdiTableCellRenderer(((Object[])firstRowArray)[this.sortColumn]).getText();
                String comparedValueA = new ImdiTableCellRenderer(((Object[])secondRowArray)[this.sortColumn]).getText();
                int returnValue = baseValueA.compareTo(comparedValueA);
                if (this.sortReverse) {
                    returnValue = 1 - returnValue;
                }
                return returnValue;
            }
            try {
                int baseIntA = ((ImdiField)((Object[])firstRowArray)[1]).getFieldID();
                int comparedIntA = ((ImdiField)((Object[])secondRowArray)[1]).getFieldID();
                int returnValue = baseIntA - comparedIntA;
                return returnValue;
            }
            catch (Exception ex) {
                GuiHelper.linorgBugCatcher.logError(ex);
                return 1;
            }
        }
    }
}

