/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.templates;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import nl.mpi.arbil.DownloadAbortFlag;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiIcons;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.clarin.CmdiProfileReader;
import nl.mpi.arbil.data.ImdiSchema;
import nl.mpi.arbil.templates.ArbilTemplate;
import nl.mpi.arbil.templates.CmdiTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilTemplateManager {
    private static ArbilTemplateManager singleInstance = null;
    private Hashtable<String, ArbilTemplate> templatesHashTable;
    private String[] builtInTemplates2 = new String[]{"Default", "Sign Language"};

    public static synchronized ArbilTemplateManager getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new ArbilTemplateManager();
        }
        return singleInstance;
    }

    public File createTemplate(String selectedTemplate) {
        if (selectedTemplate.length() == 0) {
            return null;
        }
        if (Arrays.binarySearch(this.builtInTemplates2, selectedTemplate) > -1) {
            return null;
        }
        File selectedTemplateFile = this.getTemplateFile(selectedTemplate);
        selectedTemplateFile.getParentFile().mkdir();
        LinorgSessionStorage.getSingleInstance().saveRemoteResource(ImdiSchema.class.getResource("/nl/mpi/arbil/resources/templates/template.xml"), selectedTemplateFile, null, true, new DownloadAbortFlag());
        new File(selectedTemplateFile.getParentFile(), "components").mkdir();
        File examplesDirectory = new File(selectedTemplateFile.getParentFile(), "example-components");
        examplesDirectory.mkdir();
        for (String[] pathString : ArbilTemplateManager.getSingleInstance().getTemplate((String)this.builtInTemplates2[0]).templatesArray) {
            LinorgSessionStorage.getSingleInstance().saveRemoteResource(ImdiSchema.class.getResource("/nl/mpi/arbil/resources/templates/" + pathString[0]), new File(examplesDirectory, pathString[0]), null, true, new DownloadAbortFlag());
        }
        LinorgSessionStorage.getSingleInstance().saveRemoteResource(ImdiSchema.class.getResource("/nl/mpi/arbil/resources/xsl/imdi-viewer.xsl"), new File(selectedTemplateFile.getParentFile(), "example-format.xsl"), null, true, new DownloadAbortFlag());
        return selectedTemplateFile;
    }

    public File getTemplateFile(String currentTemplate) {
        File currentTemplateFile = new File(this.getTemplateDirectory().getAbsolutePath() + File.separatorChar + currentTemplate + File.separatorChar + "template.xml");
        return currentTemplateFile;
    }

    public File getTemplateDirectory() {
        return new File(LinorgSessionStorage.getSingleInstance().storageDirectory, "templates");
    }

    public void addSelectedTemplates(String templateString) {
        ArrayList<String> selectedTamplates = new ArrayList<String>();
        try {
            selectedTamplates.addAll(Arrays.asList(LinorgSessionStorage.getSingleInstance().loadStringArray("selectedTemplates")));
        }
        catch (Exception e) {
            GuiHelper.linorgBugCatcher.logError("No selectedTemplates file, will create one now.", e);
        }
        selectedTamplates.add(templateString);
        LinorgSessionStorage.getSingleInstance().saveStringArray("selectedTemplates", selectedTamplates.toArray(new String[0]));
    }

    public void removeSelectedTemplates(String templateString) {
        ArrayList<String> selectedTamplates = new ArrayList<String>();
        selectedTamplates.addAll(Arrays.asList(LinorgSessionStorage.getSingleInstance().loadStringArray("selectedTemplates")));
        while (selectedTamplates.contains(templateString)) {
            selectedTamplates.remove(templateString);
        }
        LinorgSessionStorage.getSingleInstance().saveStringArray("selectedTemplates", selectedTamplates.toArray(new String[0]));
    }

    public ArrayList<String> getSelectedTemplateArrayList() {
        ArrayList<String> selectedTamplates = new ArrayList<String>();
        try {
            selectedTamplates.addAll(Arrays.asList(LinorgSessionStorage.getSingleInstance().loadStringArray("selectedTemplates")));
        }
        catch (Exception e) {
            GuiHelper.linorgBugCatcher.logError("No selectedTemplates file, will create one now.", e);
        }
        return selectedTamplates;
    }

    public MenuItemData[] getSelectedTemplates() {
        ImdiIcons imdiIcons = ImdiIcons.getSingleInstance();
        String[] locationsArray = LinorgSessionStorage.getSingleInstance().loadStringArray("selectedTemplates");
        if (locationsArray == null || locationsArray.length == 0) {
            this.addSelectedTemplates("builtin:METATRANSCRIPT.Corpus.xml");
            this.addSelectedTemplates("builtin:METATRANSCRIPT.Catalogue.xml");
            this.addSelectedTemplates("builtin:METATRANSCRIPT.Session.xml");
            locationsArray = LinorgSessionStorage.getSingleInstance().loadStringArray("selectedTemplates");
        }
        MenuItemData[] returnArray = new MenuItemData[locationsArray.length];
        for (int insertableCounter = 0; insertableCounter < locationsArray.length; ++insertableCounter) {
            String currentString;
            returnArray[insertableCounter] = new MenuItemData();
            if (locationsArray[insertableCounter].startsWith("builtin:")) {
                currentString = locationsArray[insertableCounter].substring("builtin:".length());
                for (String[] currentTemplateName : ArbilTemplateManager.getSingleInstance().getTemplate(null).rootTemplatesArray) {
                    if (!currentString.equals(currentTemplateName[0])) continue;
                    returnArray[insertableCounter].menuText = currentTemplateName[1];
                    returnArray[insertableCounter].menuAction = "." + currentTemplateName[0].replaceFirst("\\.xml$", "");
                    returnArray[insertableCounter].menuToolTip = currentTemplateName[1];
                    returnArray[insertableCounter].menuIcon = returnArray[insertableCounter].menuText.contains("Corpus") ? imdiIcons.corpusnodeColorIcon : (returnArray[insertableCounter].menuText.contains("Catalogue") ? imdiIcons.catalogueColorIcon : imdiIcons.sessionColorIcon);
                }
            }
            if (locationsArray[insertableCounter].startsWith("template:")) {
                currentString = locationsArray[insertableCounter].substring("template:".length());
                returnArray[insertableCounter].menuText = currentString + " (not available)";
                returnArray[insertableCounter].menuAction = currentString;
                returnArray[insertableCounter].menuToolTip = currentString;
                returnArray[insertableCounter].menuIcon = imdiIcons.sessionColorIcon;
            }
            if (!locationsArray[insertableCounter].startsWith("clarin:")) continue;
            currentString = locationsArray[insertableCounter].substring("clarin:".length());
            CmdiProfileReader.CmdiProfile cmdiProfile = new CmdiProfileReader().getProfile(currentString);
            returnArray[insertableCounter].menuText = cmdiProfile.name;
            returnArray[insertableCounter].menuAction = cmdiProfile.getXsdHref();
            returnArray[insertableCounter].menuToolTip = cmdiProfile.description;
            returnArray[insertableCounter].menuIcon = imdiIcons.clarinIcon;
        }
        Arrays.sort(returnArray, new Comparator(){

            public int compare(Object firstItem, Object secondItem) {
                return ((MenuItemData)firstItem).menuText.compareToIgnoreCase(((MenuItemData)secondItem).menuText);
            }
        });
        return returnArray;
    }

    public String[] getAvailableTemplates() {
        Object[] templatesList;
        File templatesDir = this.getTemplateDirectory();
        if (!templatesDir.exists()) {
            templatesDir.mkdir();
        }
        ArrayList<String> templateList = new ArrayList<String>();
        for (String string : templatesList = templatesDir.list()) {
            if (!this.getTemplateFile(string).exists()) continue;
            templateList.add(string);
        }
        templatesList = templateList.toArray(new String[0]);
        Arrays.sort(templatesList);
        return templatesList;
    }

    private ArbilTemplateManager() {
        this.templatesHashTable = new Hashtable();
    }

    public ArbilTemplate getDefaultTemplate() {
        return this.getTemplate(this.builtInTemplates2[0]);
    }

    public ArbilTemplate getCmdiTemplate(String nameSpaceString) {
        if (nameSpaceString != null) {
            CmdiTemplate cmdiTemplate = (CmdiTemplate)this.templatesHashTable.get(nameSpaceString);
            if (cmdiTemplate == null) {
                cmdiTemplate = new CmdiTemplate();
                cmdiTemplate.loadTemplate(nameSpaceString);
                this.templatesHashTable.put(nameSpaceString, cmdiTemplate);
            }
            return cmdiTemplate;
        }
        GuiHelper.linorgBugCatcher.logError(new Exception("Name space URL not provided, cannot load the CMDI template, please check the XML file and ensure that the name space is specified."));
        return null;
    }

    public ArbilTemplate getTemplate(String templateName) {
        ArbilTemplate returnTemplate = new ArbilTemplate();
        if (templateName == null) {
            templateName = this.builtInTemplates2[0];
        }
        if (!this.templatesHashTable.containsKey(templateName)) {
            returnTemplate.readTemplate(this.getTemplateFile(templateName), templateName);
            this.templatesHashTable.put(templateName, returnTemplate);
        } else {
            returnTemplate = this.templatesHashTable.get(templateName);
        }
        return returnTemplate;
    }

    public class MenuItemData {
        public String menuText;
        public String menuAction;
        public String menuToolTip;
        public ImageIcon menuIcon;
    }
}

