/**
 * File  : additPopup.js
 * Author: Alexander Klassmann
 * Date  : June 7th, 2007
 *
 * Opens Popup window and calls index.jsp of ADDIT application
 *
 * Copyright (C) 2006  Freddy Offenga <freddy.offenga@mpi.nl>
 * Max Planck Institute for Psycholinguistics
 * Wundtlaan 1, 6525 XD Nijmegen, The Netherlands
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

var webnotesPopupWidth = 480;
var webnotesPopupHeight = 320;

function openAdditList(url, uri){
	url += url.indexOf('?')>0 ? '&' : '?';
	openAdditWindow(url + 'uri='+uri + '&transferuid=1');
}
 
/**
 * opens popup window with ADDIT notes
 */
function openAdditWindow(url){
	x = screen.availWidth/2 - webnotesPopupWidth/2;
	y = screen.availHeight/2 - webnotesPopupHeight/2;
	var popupWindow = window.open(
   		url,'ADDIT',
   	    	'scrollbars=1, width='+webnotesPopupWidth+',height='+webnotesPopupHeight+
   	    	',left='+x+',top='+y+',screenX='+x+',screenY='+y);
	popupWindow.focus();
}
