/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.archiving.corpusstructure.core.logging;

import java.lang.reflect.Method;
import nl.mpi.archiving.corpusstructure.core.logging.Loggable;
import nl.mpi.corpusstructure.crawler.service.model.Jaxrs;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class MethodLogger {
    private static final Logger logger = LoggerFactory.getLogger((String)"apiLogger");

    @Around(value="execution(* *(..)) && @annotation(Loggable)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long t1 = System.nanoTime();
        Object result = point.proceed();
        long t2 = System.nanoTime();
        long ms = (t2 - t1) / 1000000L;
        Method m = ((MethodSignature)MethodSignature.class.cast(point.getSignature())).getMethod();
        StringBuilder argsBuilder = new StringBuilder();
        for (Object a : point.getArgs()) {
            argsBuilder.append(a.toString());
            argsBuilder.append(", ");
        }
        String args = argsBuilder.toString();
        if (args.length() > 2) {
            args = args.substring(0, args.length() - 2);
        }
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        switch (m.getAnnotation(Loggable.class).type()) {
            case CLIENT: {
                this.clientLogging(new Timing(ms, "ms"), (Jaxrs)result, trace, args);
                break;
            }
            case SERVER: {
                this.serverLogging(new Timing(ms, "ms"), new Timing(), trace, args);
            }
        }
        return result;
    }

    protected void clientLogging(Timing local, Jaxrs jaxrs, StackTraceElement[] trace, String args) {
        logger.info("[{},{}] [CLIENT] {} --> {} --> {}({})", new Object[]{local, new Timing(jaxrs.server.time, jaxrs.server.unit), String.format("%18s", trace[4].getMethodName()), String.format("%18s", trace[3].getMethodName()), String.format("%18s", trace[2].getMethodName()), args});
    }

    protected void serverLogging(Timing local, Timing remote, StackTraceElement[] trace, String args) {
        logger.info("[{},{}] [SERVER] {} --> {}({})", new Object[]{local, remote, String.format("%18s", trace[3].getMethodName()), String.format("%18s", trace[2].getMethodName()), args});
    }

    protected static class Timing {
        Long ms;
        String unit;

        public Timing() {
            this.ms = null;
            this.unit = null;
        }

        public Timing(Long ms, String unit) {
            this.ms = ms;
            this.unit = unit;
        }

        public String toString() {
            if (this.ms == null) {
                return String.format("%7s%s", "", "  ");
            }
            return String.format("%7s%s", this.ms, "ms");
        }
    }
}

