/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.cmdi.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CMDIEntityResolver
implements EntityResolver {
    private static Logger logger = LoggerFactory.getLogger(CMDIEntityResolver.class);
    private static final String W3ORG_XML_XSD_URI = "http://www.w3.org/2001/xml.xsd";

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId.equalsIgnoreCase(W3ORG_XML_XSD_URI)) {
            return new InputSource(CMDIEntityResolver.class.getResourceAsStream("/xsd/xml.xsd"));
        }
        return new InputSource(systemId);
    }

    public static InputStream getInputStreamForURI(EntityResolver entityResolver, URI location) throws IOException, MalformedURLException {
        return CMDIEntityResolver.getInputStreamForURI(entityResolver, location.toString());
    }

    public static InputStream getInputStreamForURI(EntityResolver entityResolver, String location) throws IOException, MalformedURLException {
        if (entityResolver != null) {
            try {
                InputSource resolvedEntity = entityResolver.resolveEntity(null, location);
                InputStream byteStream = resolvedEntity.getByteStream();
                if (byteStream != null) {
                    return byteStream;
                }
                if (resolvedEntity.getSystemId() != null) {
                    return new URL(resolvedEntity.getSystemId()).openStream();
                }
            }
            catch (SAXException sEx) {
                logger.warn("SAXException while resolving schema location. Proceeding with unresolved location: " + location, (Throwable)sEx);
            }
        }
        return new URL(location).openStream();
    }
}

