/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.imdidb;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMDIRdbModel {
    private static final Logger logger = LoggerFactory.getLogger((String)IMDIRdbModel.class.getName());
    private static List mselements = new ArrayList();

    static boolean elementCanOccurMultipleTimes(String path, String element) {
        boolean result = false;
        if (!path.contains("Access")) {
            result = mselements.contains(element);
        }
        return result;
    }

    public static String toTableName(String element, String path) {
        if (element.indexOf(40) != -1) {
            element = element.substring(0, element.indexOf(40));
        }
        String pfx = "";
        if (path.contains("Catalogue") && !element.contains("Catalogue")) {
            pfx = pfx + "Catalogue";
        }
        if (element.equals("Language")) {
            if (path.indexOf("Content") != -1) {
                return pfx + "ContentLanguage";
            }
            if (path.indexOf("Participant") != -1) {
                return pfx + "ParticipantLanguage";
            }
            if (path.indexOf("Actor") != -1) {
                return pfx + "ActorLanguage";
            }
            if (path.indexOf("LexiconResource") != -1 && path.indexOf("MetaLanguage") != -1) {
                return pfx + "LexiconMetaLanguage";
            }
            if (path.indexOf("DocumentLanguages") != -1) {
                return pfx + "DocumentLanguages";
            }
            if (path.indexOf("SubjectLanguages") != -1) {
                return pfx + "SubjectLanguages";
            }
            logger.error("IMDIelements.toTableName: ERROR wrong context for element Language " + path);
            return null;
        }
        if (element.equals("Key")) {
            if (path.indexOf("MediaFile") != -1) {
                return pfx + "MediaFileKeys";
            }
            if (path.indexOf("AnnotationUnit") != -1) {
                return pfx + "AnnotationUnitKeys";
            }
            if (path.indexOf("WrittenResource") != -1) {
                return pfx + "WrittenResourceKeys";
            }
            if (path.indexOf("LexiconResource") != -1) {
                return pfx + "LexiconResourceKeys";
            }
            if (path.indexOf("Content") != -1) {
                return pfx + "ContentKeys";
            }
            if (path.indexOf("Actor") != -1) {
                return pfx + "ActorKeys";
            }
            if (path.indexOf("Source") != -1) {
                return pfx + "SourceKeys";
            }
            if (path.indexOf("Participant") != -1) {
                return pfx + "ParticipantKeys";
            }
            if (path.indexOf("Session") != -1) {
                return pfx + "SessionKeys";
            }
            if (path.indexOf("Catalogue") != -1) {
                return pfx + "Keys";
            }
            logger.error("IMDIelements.toTableName: ERROR wrong context for element Keys " + path);
            return null;
        }
        return pfx + element;
    }

    public static String toColumnName(String element, String path) {
        if (element.equalsIgnoreCase("Start")) {
            element = element + "_";
        } else if (element.equalsIgnoreCase("End")) {
            element = element + "_";
        } else if (element.equalsIgnoreCase("References")) {
            element = element + "_";
        }
        if (path.indexOf("CounterPosition") != -1) {
            element = "CounterPosition" + element;
        }
        if (path.indexOf("TimePosition") != -1) {
            element = "TimePosition" + element;
        }
        if (path.indexOf("Contact") != -1) {
            element = "Contact" + element;
        }
        if (path.indexOf("Project") != -1) {
            element = "Project" + element;
        } else if (path.indexOf("Collector") != -1) {
            element = "Collector" + element;
        } else if (path.indexOf("Validation") != -1) {
            element = "Validation" + element;
        }
        if (path.indexOf("Format") != -1 && !element.equalsIgnoreCase("Format")) {
            element = "Format" + element;
        } else if (path.indexOf("Quality") != -1 && !element.equalsIgnoreCase("Quality")) {
            element = "Quality" + element;
        }
        if (path.indexOf("Access") != -1) {
            element = "Access" + element;
        }
        element = element.replace('.', '_');
        return element;
    }

    static String toColumnType(String column) {
        if (column.endsWith("Age")) {
            return "DECIMAL";
        }
        if (column.endsWith("Date")) {
            return "DECIMAL";
        }
        if (column.startsWith("CGN")) {
            return IMDIRdbModel.toCGNColumnType(column);
        }
        return "VARCHAR";
    }

    static String toCGNColumnType(String column) {
        if (column.equals("CGN.wordCount") || column.equals("CGN.secCount") || column.equals("CGN.byteCount") || column.equals("CGN.tempoAv") || column.equals("CGN.tempoAv") || column.equals("CGN.birth.year")) {
            return "INTEGER";
        }
        return "VARCHAR";
    }

    public static Float agePeriodToFloat(String value) throws NumberFormatException {
        int isl = value.indexOf("/");
        if (isl == -1) {
            return IMDIRdbModel.ageToFloat(value);
        }
        Float a1 = IMDIRdbModel.ageToFloat(value.substring(0, isl));
        Float a2 = IMDIRdbModel.ageToFloat(value.substring(isl + 1));
        if (a1 != null && a2 != null) {
            float f1 = a1.floatValue();
            float f2 = a2.floatValue();
            return new Float((double)(f1 + f2) / 2.0);
        }
        return null;
    }

    public static Float datePeriodToFloat(String value) throws NumberFormatException {
        if (value == null || value.trim().equals("")) {
            return null;
        }
        int isl = value.indexOf("/");
        if (isl == -1) {
            return IMDIRdbModel.dateToFloat(value);
        }
        Float a1 = IMDIRdbModel.dateToFloat(value.substring(0, isl));
        Float a2 = IMDIRdbModel.dateToFloat(value.substring(isl + 1));
        if (a1 != null && a2 != null) {
            float f1 = a1.floatValue();
            float f2 = a2.floatValue();
            return new Float((double)(f1 + f2) / 2.0);
        }
        return null;
    }

    private static Float ageToFloat(String value) throws NumberFormatException {
        Float fv = null;
        float y = 0.0f;
        int isc = value.indexOf(";");
        int ip = value.indexOf(".");
        if (isc == -1 && ip == -1) {
            fv = value.equalsIgnoreCase("Unspecified") || value.equalsIgnoreCase("Unknown") ? null : new Float(value);
        } else if (isc != -1 && ip == -1) {
            y = new Float(value.substring(0, isc)).floatValue();
            int months = Integer.parseInt(value.substring(isc + 1));
            y = (float)((double)y + (double)months / 12.0);
            fv = new Float(y);
        } else if (isc != -1 && ip != -1) {
            y = new Float(value.substring(0, isc)).floatValue();
            int months = Integer.parseInt(value.substring(isc + 1, ip));
            int days = Integer.parseInt(value.substring(ip + 1));
            y = (float)((double)y + ((double)months / 12.0 + (double)days / 365.0));
            fv = new Float(y);
        }
        return fv;
    }

    private static Float dateToFloat(String value) throws NumberFormatException {
        Float fv = null;
        float y = 0.0f;
        int ifd = value.indexOf("-");
        int isd = value.indexOf("-", ifd + 1);
        if (ifd == -1 && isd == -1) {
            fv = value.equalsIgnoreCase("Unspecified") || value.equalsIgnoreCase("Unknown") ? null : new Float(value);
        } else if (ifd != -1 && isd == -1) {
            y = new Float(value.substring(0, ifd)).floatValue();
            int months = Integer.parseInt(value.substring(ifd + 1));
            if (months > 12) {
                throw new NumberFormatException("Illegal Date " + value);
            }
            y = (float)((double)y + (double)months / 12.0);
            fv = new Float(y);
        } else if (ifd != -1 && isd != -1) {
            if (isd < 6) {
                int days = Integer.parseInt(value.substring(0, ifd));
                if (days > 32) {
                    throw new NumberFormatException("Illegal Date " + value);
                }
                int months = Integer.parseInt(value.substring(ifd + 1, isd));
                if (months > 12) {
                    throw new NumberFormatException("Illegal Date " + value);
                }
                y = Integer.parseInt(value.substring(isd + 1));
                y = (float)((double)y + ((double)months / 12.0 + (double)days / 365.0));
                fv = new Float(y);
            } else {
                y = new Float(value.substring(0, ifd)).floatValue();
                int months = Integer.parseInt(value.substring(ifd + 1, isd));
                if (months > 12) {
                    throw new NumberFormatException("Illegal Date " + value);
                }
                int days = Integer.parseInt(value.substring(isd + 1));
                if (days > 32) {
                    throw new NumberFormatException("Illegal Date " + value);
                }
                y = (float)((double)y + ((double)months / 12.0 + (double)days / 365.0));
                fv = new Float(y);
            }
        }
        return fv;
    }

    static {
        mselements.add("Region");
        mselements.add("Key");
        mselements.add("Author");
        mselements.add("ContentType");
        mselements.add("Publisher");
    }
}

