/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnaryExpression
extends Expression {
    protected Expression operand;

    public UnaryExpression() {
    }

    public UnaryExpression(Expression p0) {
        this.operand = p0;
        this.adoptChildExpression(p0);
    }

    public Expression getBaseExpression() {
        return this.operand;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.operand = visitor.simplify(this.operand);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        try {
            if (this.operand instanceof Literal) {
                return Literal.makeLiteral(Value.asValue(SequenceExtent.makeSequenceExtent(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext()))));
            }
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.operand = visitor.optimize(this.operand, contextItemType);
        try {
            if (this.operand instanceof Literal) {
                return Literal.makeLiteral(Value.asValue(SequenceExtent.makeSequenceExtent(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext()))));
            }
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.operand = this.doPromotion(this.operand, offer);
        return this;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new MonoIterator<Expression>(this.operand);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.operand == original) {
            this.operand = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public int computeSpecialProperties() {
        return this.operand.getSpecialProperties();
    }

    @Override
    public int computeCardinality() {
        return this.operand.getCardinality();
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.operand.getItemType(th);
    }

    public boolean equals(Object other) {
        return other != null && this.getClass().equals(other.getClass()) && this.operand.equals(((UnaryExpression)other).operand);
    }

    public int hashCode() {
        return ("UnaryExpression " + this.getClass()).hashCode() ^ this.operand.hashCode();
    }

    @Override
    public String toString() {
        return this.getExpressionName() + "(" + this.operand.toString() + ")";
    }

    @Override
    public void explain(ExpressionPresenter out) {
        String name = this.getExpressionName();
        if (name == null) {
            out.startElement("unaryOperator");
            String op = this.displayOperator(out.getConfiguration());
            if (op != null) {
                out.emitAttribute("op", op);
            }
        } else {
            out.startElement(name);
        }
        this.operand.explain(out);
        out.endElement();
    }

    protected String displayOperator(Configuration config) {
        return null;
    }
}

