/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.ui.ArbilDragDrop;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilWindowComponent;
import nl.mpi.arbil.ui.FindReplacePanel;
import nl.mpi.arbil.ui.ImageBoxRenderer;
import nl.mpi.arbil.ui.menu.ImagePreviewContextMenu;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.TreeHelper;

public class ArbilSplitPanel
extends JPanel
implements ArbilWindowComponent {
    private static SessionStorage sessionStorage;
    private static TreeHelper treeHelper;
    private JList imagePreview;
    public ArbilTable arbilTable;
    private JScrollPane tableScrollPane;
    private JScrollPane listScroller;
    private JSplitPane splitPane;
    private JLabel hiddenColumnsLabel;
    private FindReplacePanel findReplacePanel = null;
    private boolean showSearchPanel = false;
    private JPanel tableOuterPanel;
    boolean selectionChangeInProcess = false;

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static void setTreeHelper(TreeHelper treeHelperInstance) {
        treeHelper = treeHelperInstance;
    }

    public ArbilSplitPanel(ArbilTable localArbilTable) {
        this.setLayout(new BorderLayout());
        this.arbilTable = localArbilTable;
        this.splitPane = new JSplitPane();
        this.hiddenColumnsLabel = new JLabel();
        this.tableScrollPane = new JScrollPane(this.arbilTable);
        this.tableScrollPane.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent e) {
                ArbilSplitPanel.this.arbilTable.setColumnWidths();
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
            }
        });
        this.tableOuterPanel = new JPanel(new BorderLayout());
        this.tableOuterPanel.add((Component)this.tableScrollPane, "Center");
        this.tableOuterPanel.add((Component)this.hiddenColumnsLabel, "South");
        localArbilTable.getArbilTableModel().setHiddenColumnsLabel(this.hiddenColumnsLabel);
        this.imagePreview = new JList(localArbilTable.getArbilTableModel().getListModel(this));
        this.imagePreview.setSelectionMode(1);
        this.imagePreview.setLayoutOrientation(2);
        this.imagePreview.setVisibleRowCount(-1);
        this.listScroller = new JScrollPane(this.imagePreview);
        this.listScroller.setPreferredSize(new Dimension(250, 80));
        ImageBoxRenderer renderer = new ImageBoxRenderer();
        this.imagePreview.setCellRenderer(renderer);
        this.splitPane.setOrientation(0);
        this.splitPane.setDividerSize(5);
        this.imagePreview.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    new ImagePreviewContextMenu(ArbilSplitPanel.this.imagePreview).show(evt.getX(), evt.getY());
                }
            }

            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    new ImagePreviewContextMenu(ArbilSplitPanel.this.imagePreview).show(evt.getX(), evt.getY());
                }
            }
        });
        this.imagePreview.setSelectionMode(2);
        this.imagePreview.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && !ArbilSplitPanel.this.selectionChangeInProcess) {
                    ArbilSplitPanel.this.selectionChangeInProcess = true;
                    if (e.getSource() instanceof JList) {
                        ArbilSplitPanel.this.arbilTable.clearSelection();
                        int minSelectedRow = -1;
                        int maxSelectedRow = -1;
                        for (Object selectedRow : ((JList)e.getSource()).getSelectedValues()) {
                            ArbilSplitPanel.this.arbilTable.setColumnSelectionAllowed(false);
                            ArbilSplitPanel.this.arbilTable.setRowSelectionAllowed(true);
                            for (int rowCount = 0; rowCount < ArbilSplitPanel.this.arbilTable.getRowCount(); ++rowCount) {
                                if (!ArbilSplitPanel.this.arbilTable.getTableCellContentAt(rowCount, 0).equals(selectedRow)) continue;
                                ArbilSplitPanel.this.arbilTable.addRowSelectionInterval(rowCount, rowCount);
                                if (maxSelectedRow == -1 || maxSelectedRow < rowCount) {
                                    maxSelectedRow = rowCount;
                                }
                                if (minSelectedRow != -1 && minSelectedRow <= rowCount) continue;
                                minSelectedRow = rowCount;
                            }
                            if (maxSelectedRow == -1) continue;
                            ArbilSplitPanel.this.arbilTable.scrollRectToVisible(ArbilSplitPanel.this.arbilTable.getCellRect(minSelectedRow, 0, true));
                        }
                        if (sessionStorage.loadBoolean("trackTableSelection", false)) {
                            treeHelper.jumpToSelectionInTree(true, (ArbilDataNode)((JList)e.getSource()).getSelectedValue());
                        }
                    }
                    ArbilSplitPanel.this.selectionChangeInProcess = false;
                }
            }
        });
        this.arbilTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && !ArbilSplitPanel.this.selectionChangeInProcess) {
                    ArbilSplitPanel.this.selectionChangeInProcess = true;
                    ArbilSplitPanel.this.imagePreview.clearSelection();
                    int minSelectedRow = -1;
                    int maxSelectedRow = -1;
                    for (ArbilDataNode selectedRow : ArbilSplitPanel.this.arbilTable.getSelectedRowsFromTable()) {
                        for (int rowCount = 0; rowCount < ArbilSplitPanel.this.imagePreview.getModel().getSize(); ++rowCount) {
                            if (!ArbilSplitPanel.this.imagePreview.getModel().getElementAt(rowCount).equals(selectedRow)) continue;
                            ArbilSplitPanel.this.imagePreview.addSelectionInterval(rowCount, rowCount);
                            if (maxSelectedRow == -1 || maxSelectedRow < rowCount) {
                                maxSelectedRow = rowCount;
                            }
                            if (minSelectedRow != -1 && minSelectedRow <= rowCount) continue;
                            minSelectedRow = rowCount;
                        }
                    }
                    if (maxSelectedRow != -1) {
                        ArbilSplitPanel.this.imagePreview.scrollRectToVisible(ArbilSplitPanel.this.imagePreview.getCellBounds(minSelectedRow, maxSelectedRow));
                    }
                    if (sessionStorage.loadBoolean("trackTableSelection", false)) {
                        treeHelper.jumpToSelectionInTree(true, ArbilSplitPanel.this.arbilTable.getDataNodeForSelection());
                    }
                    ArbilSplitPanel.this.selectionChangeInProcess = false;
                }
            }
        });
    }

    public void showSearchPane() {
        if (this.findReplacePanel == null) {
            this.findReplacePanel = new FindReplacePanel(this);
        }
        if (!this.showSearchPanel) {
            this.tableOuterPanel.remove(this.hiddenColumnsLabel);
            this.tableOuterPanel.add((Component)this.findReplacePanel, "South");
        } else {
            this.tableOuterPanel.remove(this.findReplacePanel);
            this.tableOuterPanel.add((Component)this.hiddenColumnsLabel, "South");
        }
        this.showSearchPanel = !this.showSearchPanel;
        this.revalidate();
        this.repaint();
    }

    public void setSplitDisplay() {
        this.removeAll();
        if (this.imagePreview.getModel().getSize() == 0) {
            this.add(this.tableOuterPanel);
        } else {
            this.splitPane.setTopComponent(this.tableOuterPanel);
            this.splitPane.setBottomComponent(this.listScroller);
            ArbilDragDrop.getSingleInstance().addDrag(this.imagePreview);
            ArbilDragDrop.getSingleInstance().setTransferHandlerOnComponent(this.tableScrollPane);
            this.add(this.splitPane);
            this.doLayout();
            this.splitPane.setDividerLocation(0.5);
        }
        ArbilDragDrop.getSingleInstance().addDrag(this.arbilTable);
        ArbilDragDrop.getSingleInstance().setTransferHandlerOnComponent(this);
        this.doLayout();
    }

    public void doLayout() {
        super.doLayout();
    }

    public void addFocusListener(JInternalFrame internalFrame) {
        internalFrame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameDeactivated(InternalFrameEvent e) {
                TableCellEditor tableCellEditor = ArbilSplitPanel.this.arbilTable.getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.stopCellEditing();
                }
                super.internalFrameDeactivated(e);
            }
        });
    }

    public void arbilWindowClosed() {
        this.arbilTable.getArbilTableModel().removeAllArbilDataNodeRows();
    }
}

