/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.util;

import nl.mpi.arbil.util.BugCatcher;

public class BugCatcherManager {
    private static BugCatcher bugCatcher;
    private static BugCatcher fallBackBugCatcher;

    public static synchronized BugCatcher getBugCatcher() {
        if (bugCatcher == null) {
            if (fallBackBugCatcher == null) {
                System.err.println("BugCatcher requested but no instance has been configured. Using fallback BugCatcher.");
                fallBackBugCatcher = new FallbackBugCatcher();
            }
            return fallBackBugCatcher;
        }
        return bugCatcher;
    }

    public static synchronized void setBugCatcher(BugCatcher aBugCatcher) {
        bugCatcher = aBugCatcher;
    }

    private static class FallbackBugCatcher
    implements BugCatcher {
        private FallbackBugCatcher() {
        }

        public void logError(Exception exception) {
            if (exception != null) {
                exception.printStackTrace(System.err);
            }
        }

        public void logError(String messageString, Exception exception) {
            System.err.println(messageString);
            if (exception != null) {
                exception.printStackTrace(System.err);
            }
        }
    }
}

