/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.simple;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.security.PrivateKey;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.ListHandlesRequest;
import net.handle.hdllib.ListHandlesResponse;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class HDLList
implements ResponseMessageCallback {
    public static void main(String[] argv) {
        if (argv.length != 4) {
            System.err.println("usage: java net.handle.apps.simple.HDLList <auth handle> <auth index> <privkey> <naming authority>");
            System.exit(-1);
        }
        HDLList h = new HDLList(argv);
    }

    public HDLList(String[] argv) {
        byte[] key = null;
        try {
            File f = new File(argv[2]);
            FileInputStream fs = new FileInputStream(f);
            key = new byte[(int)f.length()];
            int n = 0;
            while (n < key.length) {
                key[n++] = (byte)fs.read();
            }
            fs.read(key);
        }
        catch (Throwable t) {
            System.err.println("Cannot read private key " + argv[2] + ": " + t);
            System.exit(-1);
        }
        HandleResolver resolver = new HandleResolver();
        resolver.traceMessages = true;
        PrivateKey privkey = null;
        byte[] secKey = null;
        try {
            if (Util.requiresSecretKey(key)) {
                secKey = Util.getPassphrase("passphrase: ");
            }
            key = Util.decrypt(key, secKey);
            privkey = Util.getPrivateKeyFromBytes(key, 0);
        }
        catch (Throwable t) {
            System.err.println("Can't load private key in " + argv[2] + ": " + t);
            System.exit(-1);
        }
        PrintStream consolePrintStream = new PrintStream(System.out, true);
        ResolutionRequest resReq = new ResolutionRequest(Util.encodeString(argv[3] + "/test"), null, null, null);
        System.err.println("finding local sites for " + resReq);
        SiteInfo[] sites = null;
        try {
            sites = resolver.findLocalSites(resReq);
        }
        catch (HandleException e) {
            e.printStackTrace();
        }
        PublicKeyAuthenticationInfo auth = new PublicKeyAuthenticationInfo(Util.encodeString(argv[0]), Integer.valueOf(argv[1]), privkey);
        ListHandlesRequest req = new ListHandlesRequest(Util.encodeString("0.NA/" + argv[3]), auth);
        for (int i = 0; i < sites[0].servers.length; ++i) {
            try {
                ServerInfo server = sites[0].servers[i];
                AbstractResponse response = resolver.sendRequestToServer(req, server, this);
                if (response instanceof ListHandlesResponse) {
                    byte[][] handles = ((ListHandlesResponse)response).handles;
                    for (i = 0; i < handles.length; ++i) {
                        System.out.println(Util.decodeString(handles[i]));
                    }
                    continue;
                }
                System.out.println("\nError: " + response.toString());
                continue;
            }
            catch (Throwable t) {
                System.err.println("\nHDLError: " + t);
            }
        }
    }

    public void handleResponse(AbstractResponse response) {
        if (response instanceof ListHandlesResponse) {
            try {
                ListHandlesResponse lhResp = (ListHandlesResponse)response;
                byte[][] handles = lhResp.handles;
                for (int i = 0; i < handles.length; ++i) {
                    System.out.println(Util.decodeString(handles[i]));
                }
            }
            catch (Exception e) {
                System.err.println("Error: " + e);
                e.printStackTrace(System.err);
            }
        } else if (response.responseCode != 402) {
            System.err.println(response);
        }
    }
}

