/*
 * Decompiled with CFR 0.152.
 */
package net.handle.security;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;

public abstract class HdlSecurityProvider {
    private static HdlSecurityProvider instance = null;
    static final String DEFAULT_PROVIDER = "net.handle.security.provider.SunJceHdlSecurityProvider";

    public static final HdlSecurityProvider getInstance() {
        if (instance != null) {
            return instance;
        }
        String clssName = System.getProperty("handle.security.provider_class", DEFAULT_PROVIDER);
        try {
            Class<?> klass = Class.forName(clssName);
            Object obj = klass.newInstance();
            if (obj instanceof HdlSecurityProvider) {
                instance = (HdlSecurityProvider)obj;
                return instance;
            }
            System.err.println("Security provider (" + clssName + ") not found");
        }
        catch (Exception e) {
            System.err.println("Security provider (" + clssName + ") not found; reason: " + e);
        }
        return null;
    }

    public abstract byte[] encrypt_DES_ECB_PKCS5(byte[] var1, int var2, int var3, byte[] var4) throws Exception;

    public abstract byte[] decrypt_DES_ECB_PKCS5(byte[] var1, int var2, int var3, byte[] var4) throws Exception;

    public KeyPair generateRSAKeyPair(int keySize) throws Exception {
        throw new NoSuchAlgorithmException("RSA not supported.");
    }

    public byte[] encrypt_RSA_ECB_PKCS1(byte[] cleartext, int offset, int len, RSAPublicKey publicKey) throws Exception {
        throw new NoSuchAlgorithmException("RSA not supported.");
    }

    public byte[] decrypt_RSA_ECB_PKCS1(byte[] ciphertext, int offset, int len, RSAPrivateKey privateKey) throws Exception {
        throw new NoSuchAlgorithmException("RSA not supported.");
    }

    public byte[] sign_RSA_MD5_PKCS1(byte[] ciphertext, int offset, int len, RSAPrivateKey privateKey) throws Exception {
        throw new NoSuchAlgorithmException("RSA not supported.");
    }

    public boolean verify_RSA_MD5_PKCS1(byte[] plaintext, int offset, int len, byte[] signature, RSAPublicKey publicKey) throws Exception {
        throw new NoSuchAlgorithmException("RSA not supported.");
    }

    public byte[] sign_RSA_SHA1_PKCS1(byte[] ciphertext, int offset, int len, RSAPrivateKey privateKey) throws Exception {
        throw new NoSuchAlgorithmException("RSA not supported.");
    }

    public boolean verify_RSA_SHA1_PKCS1(byte[] plaintext, int offset, int len, byte[] signature, RSAPublicKey publicKey) throws Exception {
        throw new NoSuchAlgorithmException("RSA not supported.");
    }

    public KeyPair generateDHKeyPair(int keySize) throws Exception {
        throw new NoSuchAlgorithmException("Diffie-Hellman key exchange not supported.");
    }

    public KeyPair generateDHKeyPair(BigInteger p, BigInteger g) throws Exception {
        throw new NoSuchAlgorithmException("Diffie-Hellman key exchange not supported.");
    }

    public byte[] getDESKeyFromDH(DHPublicKey pub, DHPrivateKey priv) throws Exception {
        throw new NoSuchAlgorithmException("Diffie-Hellman key exchange not supported.");
    }
}

