/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.bcarchive.typecheck;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import nl.mpi.bcarchive.typecheck.CharSetCheck;
import nl.mpi.bcarchive.typecheck.FileType;
import nl.mpi.bcarchive.typecheck.JpegCheck;
import nl.mpi.bcarchive.typecheck.QuickTimeCheck;
import nl.mpi.bcarchive.typecheck.TiffCheck;
import nl.mpi.bcarchive.typecheck.XMLCheck;

public class DeepFileType {
    static int annexPresent = 0;
    static Class annexParser = null;
    static Class annexTranscription = null;
    FileType fileType = new FileType();
    XMLCheck xmlCheck = new XMLCheck();
    TiffCheck tiffCheck = new TiffCheck();
    JpegCheck jpegCheck = new JpegCheck();
    QuickTimeCheck quickTimeCheck = new QuickTimeCheck();
    boolean verbose = false;

    String badWhy(String oldResult, String badReason) {
        return oldResult.replaceFirst("true", "false").replaceFirst("ARCHIVABLE", "BadVariant") + " " + badReason;
    }

    String invokeAnnex(String mimeType, File theFile) {
        try {
            int type = -1;
            if (mimeType.equals("text/x-eaf+xml")) {
                type = annexParser.getField("EAF_TYPE").getInt(annexParser);
            } else if (mimeType.equals("text/x-chat")) {
                type = annexParser.getField("CHAT_TYPE").getInt(annexParser);
            } else if (mimeType.startsWith("text/x-shoebox") || mimeType.startsWith("text/x-toolbox")) {
                type = annexParser.getField("SHOEBOX_TYPE").getInt(annexParser);
            } else if (mimeType.equals("text/csv")) {
                type = annexParser.getField("TEXT_CSV_TYPE").getInt(annexParser);
            } else if (mimeType.equals("application/pdf")) {
                type = annexParser.getField("PDF_TYPE").getInt(annexParser);
            } else if (mimeType.equals("text/xml")) {
                type = annexParser.getField("TEXT_XML_TYPE").getInt(annexParser);
            } else if (mimeType.equals("text/html")) {
                type = annexParser.getField("TEXT_HTML_TYPE").getInt(annexParser);
            } else if (mimeType.equals("text/x-subrip")) {
                type = annexParser.getField("TEXT_SUBRIP_TYPE").getInt(annexParser);
            } else if (mimeType.equals("text/praat-textgrid")) {
                type = annexParser.getField("TEXT_TEXTGRID_TYPE").getInt(annexParser);
            } else if (mimeType.equals("text/plain")) {
                type = annexParser.getField("TEXT_PLAIN_TYPE").getInt(annexParser);
            } else {
                return "";
            }
            Object[] args = new Object[]{null, type, theFile};
            Class[] argTypes = new Class[]{Class.forName("java.lang.String"), Integer.TYPE, Class.forName("java.io.File")};
            Object at = annexTranscription.getConstructor(argTypes).newInstance(args);
            Object res = annexTranscription.getMethod("isValid", null).invoke(at, (Object[])null);
            boolean result = false;
            if (res instanceof Boolean) {
                if (((Boolean)res).toString().equals("true")) {
                    return "[AnnexValidated]";
                }
                return "[AnnexRejected]";
            }
        }
        catch (Exception e) {
            System.err.println("Too old Annex JAR? Failed to parse: " + mimeType);
            e.printStackTrace();
            return "";
        }
        return "";
    }

    public void setVerbose(boolean v) {
        this.verbose = v;
        this.fileType.setVerbose(v);
        this.tiffCheck.setVerbose(v);
        this.jpegCheck.setVerbose(v);
        this.quickTimeCheck.setVerbose(v);
    }

    private static synchronized void loadAnnex() {
        if (annexPresent != 0) {
            return;
        }
        try {
            boolean oldAnnex = false;
            try {
                annexParser = Class.forName("nl.mpi.annex.data.AnnexParser");
                annexTranscription = Class.forName("nl.mpi.annex.data.AnnexTranscription");
            }
            catch (ClassNotFoundException cnfe) {
                oldAnnex = true;
                annexParser = Class.forName("mpi.annex.search.AnnexParser");
                annexTranscription = Class.forName("mpi.annex.search.AnnexTranscription");
            }
            annexPresent = 1;
            System.err.println("AnnexParser loaded" + (oldAnnex ? " (old version)" : ""));
        }
        catch (ClassNotFoundException e) {
            annexPresent = -1;
            System.err.println("Cannot load AnnexParser, exception: " + e);
        }
        catch (UnsupportedClassVersionError ucve) {
            annexPresent = -1;
            System.err.println("AnnexParser is in CLASSPATH but not for this Java version: " + ucve);
        }
    }

    public String checkStream(InputStream is, String name) throws IOException {
        byte[] buf;
        int size;
        DeepFileType.loadAnnex();
        String result = this.fileType.checkStream(is, name);
        String[] results = result.split(" ", 4);
        if (results.length < 4 || !results[0].equals("true") || !results[1].startsWith("ARCHIVABLE")) {
            return result;
        }
        if (name == null) {
            return result + " shallow/noname: No file name given, only contents checked.";
        }
        String fileName = name.replaceFirst("file:", "").replaceFirst("//", "");
        if ((results[2].startsWith("text/") || results[2].startsWith("application/")) && results[2].indexOf("xml") != -1 && name != null) {
            URL url = null;
            try {
                url = name.indexOf(58) > 2 && name.indexOf(58) < 6 ? new URL(name) : new File(fileName).toURL();
            }
            catch (MalformedURLException e) {
                result = result + " shallow/badurl: Cannot check XML contents, no valid URL.";
                return result;
            }
            if (url == null) {
                result = result + " shallow/badurl: Cannot check XML contents, URL not known.";
                return result;
            }
            String result2 = "";
            try {
                InputStream ist = url.openStream();
                result2 = this.xmlCheck.checkStream(ist, name);
                if (ist != null) {
                    ist.close();
                }
            }
            catch (IOException e) {
                return this.badWhy(result, "[BADXML] Exception: " + e.getMessage());
            }
            if (!result2.startsWith("true")) {
                if (annexPresent > 0) {
                    try {
                        if (fileName.indexOf(58) == -1) {
                            result2 = result2 + " " + this.invokeAnnex(results[2], new File(fileName));
                        }
                    }
                    catch (Exception e) {
                        return this.badWhy(result, "[BADXML] " + result2.replaceFirst("false ", "") + " Exception: " + e.getMessage());
                    }
                }
                return this.badWhy(result, "[BADXML] " + result2.replaceFirst("false ", ""));
            }
            result = result + " [XML] " + result2.replaceFirst("true ", "");
        }
        if (name.startsWith("http:") || name.startsWith("https:") || name.startsWith("ftp:")) {
            return result + " shallow/remote: Cannot check remote file contents for this format.";
        }
        if (!(results[2].equals("image/tiff") || results[2].equals("image/jpeg") || results[2].equals("image/gif") || results[2].equals("image/png") || results[2].equals("image/x-ms-bmp") || results[2].equals("audio/x-wav") || results[2].equals("audio/mp4") || results[2].equals("video/quicktime") || results[2].equals("video/mp4") || results[2].equals("application/pdf") || results[2].startsWith("text/"))) {
            return result;
        }
        RandomAccessFile what = null;
        try {
            what = new RandomAccessFile(fileName, "r");
        }
        catch (FileNotFoundException fnfe) {
            return this.badWhy(result, "Access error: " + fnfe.getMessage());
        }
        if (annexPresent > 0) {
            String annexResult = this.invokeAnnex(results[2], new File(fileName));
            result = result + (annexResult.length() > 0 ? " " + annexResult : "");
        }
        if (results[2].equals("image/gif") || results[2].equals("image/png") || results[2].equals("text/html") || results[2].equals("audio/x-wav") || results[2].equals("image/x-ms-bmp")) {
            int height;
            long longsize = what.length();
            size = longsize > 2048L ? 2048 : (int)longsize;
            buf = new byte[2048];
            if (buf == null) {
                return result + " shallow/outofmemory: Not enough memory for further checks.";
            }
            what.seek(0L);
            what.readFully(buf, 0, size);
            if (results[2].equals("text/html")) {
                String asString = new String(buf);
                int offs1 = asString.toLowerCase().indexOf("<title>");
                int offs2 = asString.toLowerCase().indexOf("</title>");
                if (offs1 < 0 || offs2 < 0 || offs1 > offs2) {
                    result = result + " [no title]";
                } else if (this.verbose) {
                    String title = asString.substring(offs1 + 7, offs2).replaceAll("\\s", " ").replaceAll("\\p{Cntrl}", "*");
                    if (title.length() > 250) {
                        title = title.substring(0, 245) + "...";
                    }
                    result = result + " [Title: " + title + "]";
                }
            }
            if (results[2].equals("audio/x-wav")) {
                what.close();
                int j = 0;
                if (buf[12] == 74 && buf[13] == 85 && buf[14] == 78 && buf[15] == 75) {
                    j = (buf[16] & 0xFF) + 256 * (buf[17] & 0xFF) + 65536 * (buf[18] & 0xFF) + 0x1000000 * (buf[19] & 0x7F);
                    if (j > 2004) {
                        return this.badWhy(result, "[Too much JUNK: " + j + "]");
                    }
                    result = result + " [JUNK: " + j + "]";
                    if (buf[12 + (j += 8)] != 102 || buf[13 + j] != 109 || buf[14 + j] != 116 || buf[15 + j] != 32) {
                        return this.badWhy(result, "[Only 1 JUNK block between WAVE and fmt supported]");
                    }
                }
                int freq = (buf[24 + j] & 0xFF) + 256 * (buf[25 + j] & 0xFF) + 65536 * (buf[26 + j] & 0xFF);
                result = result + " [" + buf[22 + j] + "*" + freq;
                if (buf[20 + j] == 1 && buf[21 + j] == 0) {
                    result = result + "/" + buf[34 + j];
                }
                return result + "]";
            }
            if (results[2].equals("image/gif")) {
                what.close();
                int width = (buf[6] & 0xFF) + 256 * (buf[7] & 0xFF);
                height = (buf[8] & 0xFF) + 256 * (buf[9] & 0xFF);
                int flags = buf[10] & 0x77;
                int colors1 = 2 << (flags >> 4);
                int colors2 = 2 << (flags & 0xF);
                result = result + " r: " + width + "x" + height + "/";
                if (colors1 != colors2) {
                    return result + colors1 + "/" + colors2 + "]";
                }
                return result + colors1;
            }
            if (results[2].equals("image/png")) {
                what.close();
                if ((buf[16] | buf[17] | buf[20] | buf[21]) != 0) {
                    return this.badWhy(result, "[BAD PNG RESOLUTION]");
                }
                int width = (buf[19] & 0xFF) + 256 * (buf[18] & 0xFF);
                height = (buf[23] & 0xFF) + 256 * (buf[22] & 0xFF);
                int cspace = buf[25] & 0xFF;
                if (buf[24] < 1 || buf[24] > 16 || cspace != 6 && cspace != 4 && cspace != 3 && cspace != 2 && cspace != 0) {
                    return this.badWhy(result, "[BAD PNG COLORS: " + buf[24] + " bit, type " + cspace + "]");
                }
                if (buf[26] != 0 || buf[27] != 0 || (buf[28] & 0xFE) != 0) {
                    return this.badWhy(result, "[BAD PNG ENCODING]");
                }
                String[] cSpaceStrings = new String[]{"GREY", null, "RGB", "PAL", "GREYA", null, "RGBA"};
                return result + " r: " + width + "x" + height + "/" + buf[24] + "/" + cSpaceStrings[cspace];
            }
            if (results[2].equals("image/x-ms-bmp")) {
                what.close();
                if (buf[20] != 0 || buf[21] != 0 || buf[24] != 0 || buf[25] != 0) {
                    return this.badWhy(result, "[BAD BMP RESOLUTION]");
                }
                int width = (buf[18] & 0xFF) + 256 * (buf[19] & 0xFF);
                height = (buf[22] & 0xFF) + 256 * (buf[23] & 0xFF);
                int planes = (buf[26] & 0xFF) + 256 * (buf[27] & 0xFF);
                int depth = (buf[28] & 0xFF) + 256 * (buf[29] & 0xFF);
                if (buf[30] > 5 || buf[30] < 0 || buf[31] != 0 || buf[32] != 0 || buf[33] != 0) {
                    return this.badWhy(result, "[BAD BMP COMPRESSION]");
                }
                if (buf[30] != 0) {
                    result = result + " [COMPRESSED BMP:" + buf[30] + "]";
                }
                if (planes > 4 || planes < 1 || depth > 32 || depth < 1 || planes * depth > 32) {
                    return this.badWhy(result, "[BAD BMP COLORS: " + planes + " planes, " + depth + " bits]");
                }
                if (planes != 1) {
                    return result + " r: " + width + "x" + height + "/" + planes + "*" + depth;
                }
                return result + " r: " + width + "x" + height + "/" + depth;
            }
        }
        if (results[2].startsWith("text/")) {
            boolean badForAnnex;
            long longsize = what.length();
            int n = size = longsize > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)longsize;
            if (size > 0x800000) {
                return result + " shallow/big: File is too big to check encoding.";
            }
            buf = new byte[size];
            if (buf == null) {
                return result + " shallow/outofmemory: Not enough memory to check encoding.";
            }
            what.seek(0L);
            what.readFully(buf, 0, size);
            what.close();
            boolean bl = badForAnnex = result.indexOf("[AnnexRejected]") != -1;
            if (CharSetCheck.isASCII(buf, size)) {
                if (result.endsWith(", ASCII")) {
                    result = result.substring(0, result.indexOf(", ASCII"));
                }
                return badForAnnex ? this.badWhy(result, " [ASCII]") : result + " [ASCII]";
            }
            if (CharSetCheck.isUTF8(buf, size)) {
                if (result.endsWith(", ASCII")) {
                    result = result + " header";
                }
                if (result.endsWith(", UTF-8")) {
                    result = result.substring(0, result.indexOf(", UTF-8"));
                }
                return badForAnnex ? this.badWhy(result, " [UTF-8]") : result + " [UTF-8]";
            }
            String charInfo = CharSetCheck.charClasses(buf, size);
            if (charInfo.indexOf("STRANGE") != -1 || charInfo.indexOf("other") != -1) {
                return this.badWhy(result, "[BAD ENCODING] " + charInfo + " CHARS[ " + CharSetCheck.nonASCII(buf, size, this.verbose) + "]");
            }
            return this.badWhy(result, "[BAD ENCODING] " + charInfo);
        }
        if (results[2].equals("image/tiff")) {
            String result2 = null;
            try {
                result2 = this.tiffCheck.checkTiff(what);
            }
            catch (IOException e) {
                return this.badWhy(result, "TIFF access error: " + e.getMessage());
            }
            what.close();
            if (!result2.startsWith("bad")) {
                return result + " [tiff] " + result2;
            }
            return this.badWhy(result, " [BAD TIFF] " + result2);
        }
        if (results[2].equals("image/jpeg")) {
            String result2 = null;
            try {
                result2 = this.jpegCheck.checkJpeg(what);
            }
            catch (IOException e) {
                return this.badWhy(result, "JPEG access error: " + e.getMessage());
            }
            what.close();
            if (!result2.startsWith("bad")) {
                return result + " [jpeg] " + result2;
            }
            return this.badWhy(result, " [BAD JPEG] " + result2);
        }
        if (!results[2].equals("application/pdf")) {
            String result2 = null;
            try {
                result2 = this.quickTimeCheck.checkQuickTime(what);
            }
            catch (IOException e) {
                return this.badWhy(result, "QuickTime access error: " + e.getMessage());
            }
            what.close();
            if (result2.indexOf("evil") == -1) {
                return result + " [qt] " + result2;
            }
            return this.badWhy(result, " [BAD QT] " + result2);
        }
        return result;
    }

    public static void main(String[] args) {
        DeepFileType me = new DeepFileType();
        me.setVerbose(false);
        if (args.length < 1) {
            System.out.println("Give input filename(s) as argument(s)...");
            System.exit(1);
        }
        for (int i = 0; i < args.length; ++i) {
            FileInputStream what = null;
            try {
                what = new FileInputStream(args[i]);
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("Could not open input file: " + fnfe);
                continue;
            }
            try {
                String result = me.checkStream(what, args[i]);
                System.out.println(result + " file: " + args[i]);
                what.close();
                continue;
            }
            catch (IOException ioe) {
                System.out.println("Could not check, I/O error: " + ioe + " file: " + args[i]);
                try {
                    what.close();
                    continue;
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
            }
        }
    }
}

