/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.plugins;

import java.util.HashSet;
import nl.mpi.arbil.plugin.ActivatablePlugin;
import nl.mpi.arbil.plugin.ArbilWindowPlugin;
import nl.mpi.arbil.plugin.PluginArbilDataNodeLoader;
import nl.mpi.arbil.plugin.PluginBugCatcher;
import nl.mpi.arbil.plugin.PluginDialogHandler;
import nl.mpi.arbil.plugin.PluginException;
import nl.mpi.arbil.plugin.PluginSessionStorage;
import nl.mpi.arbil.plugin.PluginWidgetFactory;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcher;
import nl.mpi.kinnate.plugin.BasePlugin;
import nl.mpi.pluginloader.PluginManager;

public class ArbilPluginManager
implements PluginManager {
    private final SessionStorage arbilSessionStorage;
    private final ArbilWindowManager dialogHandler;
    private final BugCatcher bugCatcher;
    private final PluginArbilDataNodeLoader arbilDataNodeLoader;
    private final HashSet<BasePlugin> hashSet = new HashSet();

    public ArbilPluginManager(SessionStorage arbilSessionStorage, ArbilWindowManager dialogHandler, PluginArbilDataNodeLoader arbilDataNodeLoader, BugCatcher bugCatcher) {
        this.arbilSessionStorage = arbilSessionStorage;
        this.dialogHandler = dialogHandler;
        this.arbilDataNodeLoader = arbilDataNodeLoader;
        this.bugCatcher = bugCatcher;
    }

    public void activatePlugin(BasePlugin kinOathPlugin) {
        boolean pluginActivated = false;
        if (kinOathPlugin instanceof ActivatablePlugin) {
            try {
                ((ActivatablePlugin)kinOathPlugin).activatePlugin((PluginDialogHandler)this.dialogHandler, (PluginSessionStorage)this.arbilSessionStorage);
                this.hashSet.add(kinOathPlugin);
                pluginActivated = true;
            }
            catch (PluginException exception) {
                this.dialogHandler.addMessageDialogToQueue("Failed to activate the requested plugin.\n" + exception.getMessage() + "\n" + kinOathPlugin.getName() + "\n" + kinOathPlugin.getMajorVersionNumber() + "." + kinOathPlugin.getMinorVersionNumber() + "." + kinOathPlugin.getBuildVersionNumber() + "\n" + kinOathPlugin.getDescription(), "Enable Plugin Error");
            }
        }
        if (kinOathPlugin instanceof ArbilWindowPlugin) {
            try {
                this.dialogHandler.createWindow(kinOathPlugin.getName(), ((ArbilWindowPlugin)kinOathPlugin).getUiPanel((PluginDialogHandler)this.dialogHandler, (PluginSessionStorage)this.arbilSessionStorage, (PluginBugCatcher)this.bugCatcher, this.arbilDataNodeLoader, (PluginWidgetFactory)this.dialogHandler));
                pluginActivated = true;
            }
            catch (PluginException exception) {
                this.dialogHandler.addMessageDialogToQueue("Failed to show the requested plugin.\n" + exception.getMessage() + "\n" + kinOathPlugin.getName() + "\n" + kinOathPlugin.getMajorVersionNumber() + "." + kinOathPlugin.getMinorVersionNumber() + "." + kinOathPlugin.getBuildVersionNumber() + "\n" + kinOathPlugin.getDescription(), "Enable Plugin Error");
            }
        }
        if (!pluginActivated) {
            this.dialogHandler.addMessageDialogToQueue("No method to activate this type of plugin yet.\n" + kinOathPlugin.getName() + "\n" + kinOathPlugin.getMajorVersionNumber() + "." + kinOathPlugin.getMinorVersionNumber() + "." + kinOathPlugin.getBuildVersionNumber() + "\n" + kinOathPlugin.getDescription(), "Enable Plugin");
        }
    }

    public void deactivatePlugin(BasePlugin kinOathPlugin) {
        if (kinOathPlugin instanceof ActivatablePlugin) {
            try {
                ((ActivatablePlugin)kinOathPlugin).deactivatePlugin((PluginDialogHandler)this.dialogHandler, (PluginSessionStorage)this.arbilSessionStorage);
                this.hashSet.remove(kinOathPlugin);
            }
            catch (PluginException exception) {
                this.dialogHandler.addMessageDialogToQueue("Failed to deactivate the requested plugin.\n" + exception.getMessage() + "\n" + kinOathPlugin.getName() + "\n" + kinOathPlugin.getMajorVersionNumber() + "." + kinOathPlugin.getMinorVersionNumber() + "." + kinOathPlugin.getBuildVersionNumber() + "\n" + kinOathPlugin.getDescription(), "Enable Plugin Error");
            }
        } else {
            this.dialogHandler.addMessageDialogToQueue("No method to deactivate this type of plugin yet.\n" + kinOathPlugin.getName() + "\n" + kinOathPlugin.getMajorVersionNumber() + "." + kinOathPlugin.getMinorVersionNumber() + "." + kinOathPlugin.getBuildVersionNumber() + "\n" + kinOathPlugin.getDescription(), "Enable Plugin");
        }
    }

    public boolean isActivated(BasePlugin kinOathPlugin) {
        return this.hashSet.contains(kinOathPlugin);
    }
}

