/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeArrayTableCell;
import nl.mpi.arbil.data.ArbilDataNodeContainer;
import nl.mpi.arbil.data.ArbilDataNodeTableCell;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilFieldComparator;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.ArbilTableCell;
import nl.mpi.arbil.data.DefaultArbilTableCell;
import nl.mpi.arbil.plugin.PluginArbilDataNode;
import nl.mpi.arbil.plugin.PluginArbilTableModel;
import nl.mpi.arbil.ui.ArbilFieldPlaceHolder;
import nl.mpi.arbil.ui.ArbilFieldView;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.NumberedStringComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractArbilTableModel
extends AbstractTableModel
implements ArbilDataNodeContainer,
PluginArbilTableModel {
    protected static final String SINGLE_NODE_VIEW_HEADING_NAME = "Field Name";
    protected static final String SINGLE_NODE_VIEW_HEADING_VALUE = "Value";
    protected static final String[] SINGLE_NODE_VIEW_HEADINGS = new String[]{"Field Name", "Value"};
    private boolean showIcons = false;
    private boolean sortReverse = false;
    private HashMap<String, ArbilField> filteredColumnNames = new HashMap();
    private ArbilFieldView tableFieldView;
    private Vector childColumnNames = new Vector();
    private boolean horizontalView = false;
    private int sortColumn = -1;
    private Vector highlightCells = new Vector();
    private String[] highFieldPaths = new String[0];
    private String[] columnNames = new String[0];
    private Color[][] cellColour = new Color[0][0];

    public AbstractArbilTableModel(ArbilFieldView tableFieldView) {
        this.tableFieldView = tableFieldView;
    }

    public AbstractArbilTableModel() {
    }

    public void addArbilDataNodes(PluginArbilDataNode[] pluginArbilDataNodes) {
        for (int draggedCounter = 0; draggedCounter < pluginArbilDataNodes.length; ++draggedCounter) {
            this.addArbilDataNode((ArbilDataNode)pluginArbilDataNodes[draggedCounter]);
        }
        this.requestReloadTableData();
    }

    public void addArbilDataNodes(ArbilDataNode[] nodesToAdd) {
        for (int draggedCounter = 0; draggedCounter < nodesToAdd.length; ++draggedCounter) {
            this.addArbilDataNode(nodesToAdd[draggedCounter]);
        }
        this.requestReloadTableData();
    }

    public void addArbilDataNodes(Enumeration nodesToAdd) {
        while (nodesToAdd.hasMoreElements()) {
            Object currentObject = nodesToAdd.nextElement();
            if (!(currentObject instanceof ArbilDataNode)) continue;
            this.addArbilDataNode((ArbilDataNode)currentObject);
        }
        this.requestReloadTableData();
    }

    public void addChildTypeToDisplay(String childType) {
        System.out.println("addChildTypeToDisplay: " + childType);
        this.getChildColumnNames().add(childType);
        this.requestReloadTableData();
    }

    public void addSingleArbilDataNode(ArbilDataNode arbilDataNode) {
        this.addArbilDataNode(arbilDataNode);
        this.requestReloadTableData();
    }

    public void clearCellColours() {
        this.getHighlightCells().clear();
        for (int rowCounter = 0; rowCounter < this.cellColour.length; ++rowCounter) {
            for (int colCounter = 0; colCounter < this.cellColour[rowCounter].length; ++colCounter) {
                this.cellColour[rowCounter][colCounter] = new Color(0xFFFFFF);
            }
        }
        this.fireTableDataChanged();
    }

    public boolean containsArbilDataNode(ArbilDataNode findable) {
        if (findable == null) {
            return false;
        }
        return this.getDataNodeHash().contains(findable);
    }

    public void copyCellToColumn(int row, int col) {
        System.out.println("copyCellToColumn for row: " + row + " col: " + col);
        for (int rowCounter = 0; rowCounter < this.getRowCount(); ++rowCounter) {
            if (rowCounter == row) continue;
            if (this.getData()[rowCounter][col].getContent() instanceof ArbilField) {
                ((ArbilField)this.getData()[rowCounter][col].getContent()).setFieldValue(((ArbilField)this.getData()[row][col].getContent()).getFieldValue(), false, false);
            }
            this.fireTableCellUpdated(rowCounter, col);
        }
    }

    @Override
    public boolean isFullyLoadedNodeRequired() {
        return true;
    }

    @Override
    public abstract void dataNodeIconCleared(ArbilNode var1);

    @Override
    public abstract void dataNodeRemoved(ArbilNode var1);

    @Override
    public abstract void dataNodeChildAdded(ArbilNode var1, ArbilNode var2);

    public int getArbilDataNodeCount() {
        return this.getDataNodeHash().size();
    }

    public Enumeration getArbilDataNodes() {
        return this.getDataNodeHash().elements();
    }

    public String[] getArbilDataNodesURLs() {
        return this.getDataNodeHash().keySet().toArray(new String[0]);
    }

    public Color getCellColour(int row, int col) {
        try {
            return this.cellColour[row][col];
        }
        catch (Exception e) {
            return new Color(0xFFFFFF);
        }
    }

    public Object[] getChildNames() {
        Vector<String> childNames = new Vector<String>();
        Enumeration<ArbilDataNode> arbilRowsEnum = this.getDataNodeHash().elements();
        while (arbilRowsEnum.hasMoreElements()) {
            for (ArbilDataNode currentChild : arbilRowsEnum.nextElement().getChildArray()) {
                String currentChildName = currentChild.toString();
                if (childNames.contains(currentChildName)) continue;
                childNames.add(currentChildName);
            }
        }
        return childNames.toArray();
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public int getColumnCount() {
        return this.getColumnNames().length;
    }

    @Override
    public String getColumnName(int col) {
        if (col < this.getColumnNames().length) {
            return this.getColumnNames()[col];
        }
        return "";
    }

    protected abstract Hashtable<String, ArbilDataNode> getDataNodeHash();

    public Vector getMatchingRows(int sampleRowNumber) {
        System.out.println("MatchingRows for: " + sampleRowNumber);
        Vector<Integer> matchedRows = new Vector<Integer>();
        if (sampleRowNumber > -1 && sampleRowNumber < this.getRowCount()) {
            for (int rowCounter = 0; rowCounter < this.getRowCount(); ++rowCounter) {
                boolean rowMatches = true;
                for (int colCounter = 0; colCounter < this.getColumnCount(); ++colCounter) {
                    if (this.getValueAt(rowCounter, colCounter).toString().equals(this.getValueAt(sampleRowNumber, colCounter).toString())) continue;
                    rowMatches = false;
                    break;
                }
                if (!rowMatches) continue;
                matchedRows.add(rowCounter);
            }
        }
        return matchedRows;
    }

    @Override
    public int getRowCount() {
        return this.getData().length;
    }

    public ArbilDataNode[] getSelectedDataNodes(int[] selectedRows) {
        ArbilDataNode[] selectedNodesArray = new ArbilDataNode[selectedRows.length];
        for (int selectedRowCounter = 0; selectedRowCounter < selectedRows.length; ++selectedRowCounter) {
            selectedNodesArray[selectedRowCounter] = this.getDataNodeFromRow(selectedRows[selectedRowCounter]);
        }
        return selectedNodesArray;
    }

    public ArbilTableCell getTableCellAt(int row, int col) {
        return this.getData()[row][col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        try {
            return this.getTableCellAt(row, col);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getTableCellContentAt(int row, int col) {
        Object tableCell = this.getValueAt(row, col);
        if (tableCell instanceof ArbilTableCell) {
            return ((ArbilTableCell)tableCell).getContent();
        }
        return null;
    }

    public void hideColumn(int columnIndex) {
        System.out.println("hideColumn: " + columnIndex);
        System.out.println("hideColumn: " + this.getColumnName(columnIndex));
        if (!this.childColumnNames.remove(this.getColumnName(columnIndex))) {
            this.getFieldView().addHiddenColumn(this.getColumnName(columnIndex));
        }
        this.requestReloadTableData();
    }

    protected abstract String getRenderedText(ArbilTableCell var1);

    public void highlightMatchingCells(int row, int col) {
        this.getHighlightCells().add(this.getRenderedText(this.getData()[row][col]));
        this.cellColour = this.setCellColours(this.getData());
        this.fireTableDataChanged();
    }

    public void highlightMatchingFieldPaths(String[] fieldPaths) {
        this.highFieldPaths = fieldPaths;
        this.cellColour = this.setCellColours(this.getData());
        this.fireTableDataChanged();
    }

    public void highlightMatchingText(String highlightText) {
        this.getHighlightCells().add(highlightText);
        this.cellColour = this.setCellColours(this.getData());
        this.fireTableDataChanged();
    }

    public boolean isHorizontalView() {
        return this.horizontalView;
    }

    public void removeAllArbilDataNodeRows() {
        Enumeration<ArbilDataNode> removableNodes = this.getDataNodeHash().elements();
        while (removableNodes.hasMoreElements()) {
            removableNodes.nextElement().removeContainer(this);
        }
        this.clearDataNodeHash();
        this.filteredColumnNames.clear();
        this.columnNames = new String[0];
        this.setData(new ArbilTableCell[0][0]);
        this.cellColour = new Color[0][0];
        this.setShowIcons(this.isShowIcons());
        this.requestReloadTableData();
    }

    protected void clearDataNodeHash() {
        this.getDataNodeHash().clear();
    }

    public void removeArbilDataNodeRows(int[] selectedRows) {
        ArbilDataNode[] nodesToRemove = new ArbilDataNode[selectedRows.length];
        for (int selectedRowCounter = 0; selectedRowCounter < selectedRows.length; ++selectedRowCounter) {
            System.out.println("removing: " + selectedRowCounter);
            nodesToRemove[selectedRowCounter] = this.getDataNodeFromRow(selectedRows[selectedRowCounter]);
        }
        this.removeArbilDataNodes(nodesToRemove);
    }

    public void removeArbilDataNodes(ArbilDataNode[] nodesToRemove) {
        for (ArbilDataNode arbilDataNode : nodesToRemove) {
            if (arbilDataNode == null) continue;
            this.removeArbilDataNode(arbilDataNode);
        }
        this.requestReloadTableData();
    }

    protected void putInDataNodeHash(ArbilDataNode arbilDataNode) {
        this.getDataNodeHash().put(arbilDataNode.getUrlString(), arbilDataNode);
    }

    protected void removeArbilDataNode(ArbilDataNode arbilDataNode) {
        this.removeFromDataNodeHash(arbilDataNode);
        arbilDataNode.removeContainer(this);
    }

    protected void removeFromDataNodeHash(ArbilDataNode arbilDataNode) {
        this.getDataNodeHash().remove(arbilDataNode.getUrlString());
    }

    public abstract void requestReloadTableData();

    public void setShowIcons(boolean localShowIcons) {
        this.showIcons = localShowIcons;
    }

    public void showOnlyCurrentColumns() {
        this.getFieldView().setShowOnlyColumns(this.getColumnNames());
    }

    public void sortByColumn(int columnIndex) {
        if (this.sortColumn == columnIndex) {
            if (this.isHorizontalView() || !this.sortReverse) {
                this.sortReverse = !this.sortReverse;
            } else {
                this.sortColumn = -1;
            }
        } else {
            this.sortColumn = columnIndex;
            this.sortReverse = false;
        }
        System.out.println("sortByColumn: " + this.sortColumn);
        this.requestReloadTableData();
    }

    public void setCurrentView(ArbilFieldView localFieldView) {
        ArbilFieldView tempFieldView = localFieldView.clone();
        Enumeration oldKnowenColoumns = this.getFieldView().getKnownColumns();
        while (oldKnowenColoumns.hasMoreElements()) {
            tempFieldView.addKnownColumn(oldKnowenColoumns.nextElement().toString());
        }
        this.tableFieldView = tempFieldView;
        this.requestReloadTableData();
    }

    protected void addArbilDataNode(ArbilDataNode arbilDataNode) {
        if (arbilDataNode != null) {
            if (arbilDataNode.isDirectory() || !arbilDataNode.getParentDomNode().isLoading() && arbilDataNode.isEmptyMetaNode()) {
                for (ArbilDataNode currentChild : arbilDataNode.getChildArray()) {
                    this.putInDataNodeHash(currentChild);
                    currentChild.registerContainer(this);
                }
            } else {
                this.putInDataNodeHash(arbilDataNode);
                arbilDataNode.registerContainer(this);
            }
        }
    }

    protected ArbilDataNode getDataNodeFromRow(int rowNumber) {
        if (this.getData()[rowNumber][0].getContent() instanceof ArbilDataNode) {
            return (ArbilDataNode)this.getData()[rowNumber][0].getContent();
        }
        if (this.getData()[rowNumber][0].getContent() instanceof ArbilField[]) {
            return ((ArbilField[])this.getData()[rowNumber][this.getColumnNames().length - 1].getContent())[0].getParentDataNode();
        }
        return ((ArbilField)this.getData()[rowNumber][this.getColumnNames().length - 1].getContent()).getParentDataNode();
    }

    protected synchronized void reloadTableDataPrivate() {
        int previousColumnCount = this.getColumnCount();
        ArbilDataNode[] tableRowsArbilArray = this.updateAllDataNodes();
        this.updateViewOrientation(tableRowsArbilArray);
        this.initTableData(tableRowsArbilArray, previousColumnCount);
    }

    private ArbilDataNode[] updateAllDataNodes() {
        ArbilDataNode[] returnArray = this.getDataNodeHash().values().toArray(new ArbilDataNode[0]);
        this.filteredColumnNames.clear();
        HashSet<String> hiddenColumns = new HashSet<String>();
        int hiddenCellsCount = 0;
        for (ArbilDataNode currentRowNode : returnArray) {
            ArbilField[][] arr$ = (ArbilField[][])currentRowNode.getFields().values().toArray((T[])new ArbilField[0][]);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                ArbilField[] currentFieldArray;
                for (ArbilField currentField : currentFieldArray = arr$[i$]) {
                    String currentColumnName = currentField.getTranslateFieldName();
                    if (this.getFieldView().viewShowsColumn(currentColumnName)) {
                        if (!this.filteredColumnNames.containsKey(currentColumnName)) {
                            this.filteredColumnNames.put(currentColumnName, currentField);
                        } else {
                            ArbilField lastStoredField = this.filteredColumnNames.get(currentColumnName);
                            if (currentField.getFieldOrder() != -1 && lastStoredField.getFieldOrder() > currentField.getFieldOrder()) {
                                this.filteredColumnNames.put(currentColumnName, currentField);
                            }
                        }
                    } else {
                        hiddenColumns.add(currentColumnName);
                        ++hiddenCellsCount;
                    }
                    this.getFieldView().addKnownColumn(currentColumnName);
                }
            }
        }
        this.updateHiddenColumnsLabel(hiddenColumns.size(), hiddenCellsCount);
        return returnArray;
    }

    protected abstract void updateHiddenColumnsLabel(int var1, int var2);

    private void updateViewOrientation(ArbilDataNode[] tableRowsArbilArray) {
        boolean lastHorizontalView = this.isHorizontalView();
        boolean bl = this.horizontalView = tableRowsArbilArray.length > 1;
        if (!this.isHorizontalView() && this.filteredColumnNames.isEmpty()) {
            this.horizontalView = true;
        }
        if (lastHorizontalView != this.isHorizontalView()) {
            this.sortReverse = false;
            this.sortColumn = this.isHorizontalView() ? 0 : -1;
        }
    }

    private void initTableData(ArbilDataNode[] tableRowsArbilArray, int previousColumnCount) {
        Object[][] newData;
        String[] columnNamesTemp;
        if (this.isHorizontalView()) {
            ArbilField[] displayedColumnNames = this.filteredColumnNames.values().toArray(new ArbilField[this.filteredColumnNames.size()]);
            Arrays.sort(displayedColumnNames, new ArbilFieldComparator());
            int firstFreeColumn = 0;
            if (this.isShowIcons()) {
                firstFreeColumn = 1;
            }
            columnNamesTemp = new String[displayedColumnNames.length + firstFreeColumn + this.getChildColumnNames().size()];
            String[] fieldNames = new String[displayedColumnNames.length + firstFreeColumn + this.getChildColumnNames().size()];
            int columnPopulateCounter = firstFreeColumn;
            if (columnNamesTemp.length > 0) {
                columnNamesTemp[0] = " ";
            }
            for (ArbilField currentColumn : displayedColumnNames) {
                fieldNames[columnPopulateCounter] = currentColumn.xmlPath;
                columnNamesTemp[columnPopulateCounter] = currentColumn.getTranslateFieldName();
                ++columnPopulateCounter;
            }
            Enumeration childColEnum = this.getChildColumnNames().elements();
            while (childColEnum.hasMoreElements()) {
                columnNamesTemp[columnPopulateCounter] = childColEnum.nextElement().toString();
                ++columnPopulateCounter;
            }
            newData = this.allocateCellData(tableRowsArbilArray.length, columnNamesTemp.length);
            int rowCounter = 0;
            int childColumnsIndex = columnNamesTemp.length - this.getChildColumnNames().size();
            for (ArbilDataNode currentNode : tableRowsArbilArray) {
                Hashtable<String, ArbilField[]> fieldsHash = currentNode.getFields();
                if (this.isShowIcons()) {
                    newData[rowCounter][0] = new ArbilDataNodeTableCell(currentNode);
                }
                for (int columnCounter = firstFreeColumn; columnCounter < columnNamesTemp.length; ++columnCounter) {
                    if (columnCounter < childColumnsIndex) {
                        if (fieldsHash.containsKey(columnNamesTemp[columnCounter])) {
                            ArbilField[] currentValue = fieldsHash.get(columnNamesTemp[columnCounter]);
                            if (currentValue.length == 1) {
                                newData[rowCounter][columnCounter] = new DefaultArbilTableCell<ArbilField>(currentValue[0]);
                                continue;
                            }
                            newData[rowCounter][columnCounter] = new DefaultArbilTableCell<ArbilField[]>(currentValue);
                            continue;
                        }
                        newData[rowCounter][columnCounter] = new DefaultArbilTableCell<ArbilFieldPlaceHolder>(new ArbilFieldPlaceHolder(fieldNames[columnCounter], currentNode));
                        continue;
                    }
                    ArbilDataNode[] childNodes = currentNode.getChildNodesArray(columnNamesTemp[columnCounter]);
                    if (childNodes != null) {
                        newData[rowCounter][columnCounter] = new ArbilDataNodeArrayTableCell(childNodes);
                    }
                    if (newData[rowCounter][columnCounter] != null) continue;
                    newData[rowCounter][columnCounter] = new DefaultArbilTableCell<String>("");
                }
                ++rowCounter;
            }
        } else {
            columnNamesTemp = SINGLE_NODE_VIEW_HEADINGS;
            if (tableRowsArbilArray.length == 0) {
                newData = this.allocateCellData(0, columnNamesTemp.length);
            } else if (tableRowsArbilArray[0] != null) {
                Hashtable<String, ArbilField[]> fieldsHash = tableRowsArbilArray[0].getFields();
                Vector<ArbilField> allRowFields = new Vector<ArbilField>();
                Enumeration<ArbilField[]> valuesEnum = fieldsHash.elements();
                while (valuesEnum.hasMoreElements()) {
                    ArbilField[] currentFieldArray;
                    for (ArbilField currentField : currentFieldArray = valuesEnum.nextElement()) {
                        if (currentField.xmlPath.length() <= 0 || !this.getFieldView().viewShowsColumn(currentField.getTranslateFieldName())) continue;
                        allRowFields.add(currentField);
                    }
                }
                newData = this.allocateCellData(allRowFields.size(), 2);
                int rowCounter = 0;
                Enumeration allFieldsEnum = allRowFields.elements();
                while (allFieldsEnum.hasMoreElements()) {
                    ArbilField currentField = (ArbilField)allFieldsEnum.nextElement();
                    newData[rowCounter][0] = new DefaultArbilTableCell<String>(currentField.getTranslateFieldName());
                    newData[rowCounter][1] = new DefaultArbilTableCell<ArbilField>(currentField);
                    ++rowCounter;
                }
            } else {
                newData = new ArbilTableCell[0][0];
            }
        }
        this.sortTableRows(columnNamesTemp, newData);
        this.columnNames = columnNamesTemp;
        this.cellColour = this.setCellColours((ArbilTableCell[][])newData);
        ArbilTableCell[][] prevousData = this.getData();
        this.setData((ArbilTableCell[][])newData);
        if (previousColumnCount != this.getColumnCount() || prevousData.length != this.getData().length) {
            try {
                this.fireTableStructureChanged();
            }
            catch (Exception ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
            }
        } else {
            for (int rowCounter = 0; rowCounter < this.getRowCount(); ++rowCounter) {
                for (int colCounter = 0; colCounter < this.getColumnCount(); ++colCounter) {
                    this.fireTableCellUpdated(rowCounter, colCounter);
                }
            }
        }
    }

    private void sortTableRows(String[] columnNamesTemp, Object[][] dataTemp) {
        if (this.sortColumn < columnNamesTemp.length) {
            Arrays.sort(dataTemp, new TableRowComparator(this.sortColumn, this.sortReverse));
        }
    }

    protected Color[][] setCellColours(ArbilTableCell[][] dataTemp) {
        Color[][] cellColourTemp;
        if (dataTemp.length == 0) {
            cellColourTemp = new Color[0][0];
        } else {
            cellColourTemp = new Color[dataTemp.length][dataTemp[0].length];
            Color currentHighlightColur = new Color(0xFFFFFF);
            Enumeration currentHighlight = this.getHighlightCells().elements();
            while (currentHighlight.hasMoreElements()) {
                currentHighlightColur = new Color(currentHighlightColur.getGreen() - 40, currentHighlightColur.getRed(), currentHighlightColur.getBlue());
                String currentText = currentHighlight.nextElement().toString();
                for (int rowCounter = 0; rowCounter < dataTemp.length; ++rowCounter) {
                    for (int colCounter = 0; colCounter < dataTemp[rowCounter].length; ++colCounter) {
                        if (!this.getRenderedText(dataTemp[rowCounter][colCounter]).equals(currentText)) continue;
                        cellColourTemp[rowCounter][colCounter] = currentHighlightColur;
                    }
                }
            }
            for (String currentFeildPath : this.highFieldPaths) {
                if (currentFeildPath == null) continue;
                for (int rowCounter = 0; rowCounter < dataTemp.length; ++rowCounter) {
                    for (int colCounter = 0; colCounter < dataTemp[rowCounter].length; ++colCounter) {
                        String fullXmlPath;
                        if (dataTemp[rowCounter][colCounter] == null || !(dataTemp[rowCounter][colCounter].getContent() instanceof ArbilField) || ((fullXmlPath = ((ArbilField)dataTemp[rowCounter][colCounter].getContent()).getFullXmlPath()) == null || !fullXmlPath.equals(currentFeildPath)) && !((ArbilField)dataTemp[rowCounter][colCounter].getContent()).getFullXmlPath().equals(currentFeildPath.replaceFirst("\\(1\\)$", ""))) continue;
                        cellColourTemp[rowCounter][colCounter] = new Color(0xDDCCFF);
                    }
                }
            }
        }
        return cellColourTemp;
    }

    protected ArbilTableCell[][] allocateCellData(int rows, int cols) {
        ArbilTableCell[][] dataTemp = new ArbilTableCell[rows][cols];
        return dataTemp;
    }

    protected abstract ArbilTableCell[][] getData();

    protected abstract void setData(ArbilTableCell[][] var1);

    protected Vector getChildColumnNames() {
        return this.childColumnNames;
    }

    protected Vector getHighlightCells() {
        return this.highlightCells;
    }

    protected String[] getColumnNames() {
        return this.columnNames;
    }

    protected boolean isShowIcons() {
        return this.showIcons;
    }

    public ArbilFieldView getFieldView() {
        return this.tableFieldView;
    }

    private String getOriginalValue(ArbilTableCell data) {
        Object content = data.getContent();
        if (content instanceof ArbilField) {
            return ((ArbilField)content).originalFieldValue;
        }
        return this.getRenderedText(data);
    }

    protected boolean isSortReverse() {
        return this.sortReverse;
    }

    protected int getSortColumn() {
        return this.sortColumn;
    }

    private class TableRowComparator
    extends NumberedStringComparator
    implements Serializable {
        int sortColumn = 0;
        boolean sortReverse = false;

        public TableRowComparator(int tempSortColumn, boolean tempSortReverse) {
            this.sortColumn = tempSortColumn;
            this.sortReverse = tempSortReverse;
        }

        public int compare(Object firstRowArray, Object secondRowArray) {
            if (this.sortColumn >= 0) {
                String comparedValueA;
                String baseValueA = AbstractArbilTableModel.this.getOriginalValue(((ArbilTableCell[])firstRowArray)[this.sortColumn]).toLowerCase();
                Integer returnValue = this.compareNumberedStrings(baseValueA, comparedValueA = AbstractArbilTableModel.this.getOriginalValue(((ArbilTableCell[])secondRowArray)[this.sortColumn]).toLowerCase());
                if (returnValue == null) {
                    returnValue = baseValueA.compareTo(comparedValueA);
                }
                if (this.sortReverse) {
                    returnValue = 1 - returnValue;
                }
                return returnValue;
            }
            try {
                int baseIntA = ((ArbilField)((ArbilTableCell[])firstRowArray)[1].getContent()).getFieldOrder();
                int comparedIntA = ((ArbilField)((ArbilTableCell[])secondRowArray)[1].getContent()).getFieldOrder();
                int returnValue = baseIntA - comparedIntA;
                if (returnValue == 0) {
                    String baseStrA = ((ArbilField)((ArbilTableCell[])firstRowArray)[1].getContent()).getFieldValue();
                    String comparedStrA = ((ArbilField)((ArbilTableCell[])secondRowArray)[1].getContent()).getFieldValue();
                    returnValue = baseStrA.compareToIgnoreCase(comparedStrA);
                }
                return returnValue;
            }
            catch (Exception ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
                return 1;
            }
        }
    }
}

