/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.ui.ArbilTree;
import nl.mpi.arbil.ui.ArbilTreeController;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.TreeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilTrackingTree
extends ArbilTree {
    private HashMap<ArbilNode, TreeNode> treeNodeMap = new HashMap();

    public ArbilTrackingTree(ArbilTreeController treeController, TreeHelper treeHelper, MessageDialogHandler dialogHandler) {
        super(treeController, treeHelper, dialogHandler);
    }

    @Override
    public void setModel(TreeModel newModel) {
        Object rootUserObject;
        if (this.getModel() != null && this.getModel().getRoot() instanceof DefaultMutableTreeNode && (rootUserObject = ((DefaultMutableTreeNode)this.getModel().getRoot()).getUserObject()) instanceof ArbilNode) {
            this.treeNodeMap.remove((ArbilNode)rootUserObject);
            ((ArbilNode)rootUserObject).removeContainer(this);
        }
        super.setModel(newModel);
        if (newModel.getRoot() instanceof DefaultMutableTreeNode && (rootUserObject = ((DefaultMutableTreeNode)newModel.getRoot()).getUserObject()) instanceof ArbilNode) {
            this.treeNodeMap.put((ArbilNode)rootUserObject, (TreeNode)newModel.getRoot());
            ((ArbilNode)rootUserObject).registerContainer(this);
        }
    }

    @Override
    public void dataNodeChildAdded(ArbilNode destination, ArbilNode newNode) {
        this.jumpToNode(destination, newNode);
    }

    public boolean jumpToNode(ArbilNode startingNode, ArbilNode targetNode) {
        List<ArbilNode> nodePath;
        TreeNode startingTreeNode = null;
        if (startingNode == null) {
            if (this.getModel().getRoot() instanceof TreeNode) {
                startingTreeNode = (TreeNode)this.getModel().getRoot();
                startingNode = this.getRootNodeObject();
            }
        } else {
            startingTreeNode = this.treeNodeMap.get(startingNode);
        }
        if (startingTreeNode != null && (nodePath = ArbilTrackingTree.createArbilNodePath(startingNode, targetNode)) != null) {
            TreePath newNodePath = this.findTreePathForNodePath(startingTreeNode, nodePath);
            this.setSelectionPath(newNodePath);
            this.scrollPathToVisible(newNodePath);
            return true;
        }
        return false;
    }

    @Override
    protected void nodeAdded(DefaultMutableTreeNode addableNode, ArbilNode addedDataNode) {
        this.treeNodeMap.put(addedDataNode, addableNode);
    }

    @Override
    protected void nodeRemoved(DefaultMutableTreeNode toRemove) {
        for (int i = 0; i < toRemove.getChildCount(); ++i) {
            TreeNode child = toRemove.getChildAt(i);
            if (!(child instanceof DefaultMutableTreeNode)) continue;
            this.nodeRemoved((DefaultMutableTreeNode)toRemove.getChildAt(i));
        }
        if (toRemove.getUserObject() instanceof ArbilNode) {
            this.treeNodeMap.remove((ArbilNode)toRemove.getUserObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreePath findTreePathForNodePath(TreeNode rootTreeNode, List<ArbilNode> arbilNodePath) {
        TreePath treePath = ArbilTrackingTree.createTreePathForTreeNode(rootTreeNode);
        for (ArbilNode currentTargetNode : arbilNodePath) {
            this.expandPath(treePath);
            Object object = this.sortRunnerLock;
            synchronized (object) {
                try {
                    this.sortRunnerLock.wait(250L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            treePath = this.extendTreePathWithChildNode(treePath, currentTargetNode);
        }
        return treePath;
    }

    private TreePath extendTreePathWithChildNode(TreePath treePath, ArbilNode currentTargetNode) {
        Object lastPathComponent = treePath.getLastPathComponent();
        if (lastPathComponent instanceof TreeNode) {
            TreeNode currentTreeNode = (TreeNode)lastPathComponent;
            for (int i = 0; i < currentTreeNode.getChildCount(); ++i) {
                TreeNode currentTreeNodeChild = currentTreeNode.getChildAt(i);
                if (!(currentTreeNodeChild instanceof DefaultMutableTreeNode) || !((DefaultMutableTreeNode)currentTreeNodeChild).getUserObject().equals(currentTargetNode)) continue;
                treePath = treePath.pathByAddingChild(currentTreeNodeChild);
                break;
            }
        }
        return treePath;
    }

    private static TreePath createTreePathForTreeNode(TreeNode treeNode) {
        ArrayList<TreeNode> pathList = new ArrayList<TreeNode>();
        for (TreeNode node = treeNode; node != null; node = node.getParent()) {
            pathList.add(node);
        }
        Collections.reverse(pathList);
        return new TreePath(pathList.toArray());
    }

    private static List<ArbilNode> createArbilNodePath(ArbilNode rootNode, ArbilNode targetNode) {
        for (ArbilNode child : rootNode.getChildArray()) {
            if (child.equals(targetNode)) {
                return Collections.singletonList(targetNode);
            }
            List<ArbilNode> childList = ArbilTrackingTree.createArbilNodePath(child, targetNode);
            if (childList == null) continue;
            LinkedList<ArbilNode> list = new LinkedList<ArbilNode>();
            list.add(child);
            list.addAll(childList);
            return list;
        }
        return null;
    }

    private ArbilNode getRootNodeObject() {
        Object userObject;
        Object localTreeRoot = this.getModel().getRoot();
        if (localTreeRoot instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)localTreeRoot).getUserObject()) instanceof ArbilNode) {
            return (ArbilNode)userObject;
        }
        return null;
    }
}

