/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.util;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Scanner;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.MetadataFormat;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ArbilResourceResolver;
import nl.mpi.arbil.util.BugCatcherManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XsdChecker
extends JSplitPane {
    private static SessionStorage sessionStorage;
    private ArbilResourceResolver resourceResolver = new ArbilResourceResolver();
    JTextPane outputPane = new JTextPane();
    JTextPane fileViewPane = new JTextPane();
    StyledDocument doc;
    Style styleFatalError;
    Style styleError;
    Style styleWarning;
    Style styleNormal;
    boolean encounteredAdditionalErrors;
    String reportedError = "";

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public XsdChecker() {
        this.setOrientation(0);
        this.setTopComponent(new JScrollPane(this.outputPane));
        this.setBottomComponent(new JScrollPane(this.fileViewPane));
        this.doc = this.outputPane.getStyledDocument();
        this.styleNormal = this.outputPane.addStyle("Normal", null);
        StyleConstants.setForeground(this.styleNormal, Color.BLACK);
        this.styleWarning = this.outputPane.addStyle("Warning", null);
        StyleConstants.setForeground(this.styleWarning, new Color(0, 153, 0));
        this.styleError = this.outputPane.addStyle("Error", null);
        StyleConstants.setForeground(this.styleError, Color.BLUE);
        this.styleFatalError = this.outputPane.addStyle("FatalError", null);
        StyleConstants.setForeground(this.styleFatalError, Color.RED);
    }

    private Validator createValidator(URL schemaFile) throws Exception {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver(this.resourceResolver);
        Schema schema = schemaFactory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        validator.setResourceResolver(this.resourceResolver);
        return validator;
    }

    private URL getXsd(File metadataFile) {
        String nameSpaceURI = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(metadataFile);
            String schemaLocationString = null;
            Node schemaLocationNode = document.getDocumentElement().getAttributes().getNamedItem("xsi:noNamespaceSchemaLocation");
            if (schemaLocationNode == null) {
                schemaLocationNode = document.getDocumentElement().getAttributes().getNamedItem("xsi:schemaLocation");
            }
            if (schemaLocationNode != null) {
                schemaLocationString = schemaLocationNode.getNodeValue();
                String[] schemaLocation = schemaLocationString.split("\\s");
                schemaLocationString = schemaLocation[schemaLocation.length - 1];
                nameSpaceURI = metadataFile.toURI().resolve(schemaLocationString).toString();
            }
            System.out.println("schemaLocationString: " + schemaLocationString);
        }
        catch (IOException iOException) {
            BugCatcherManager.getBugCatcher().logError(iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            BugCatcherManager.getBugCatcher().logError(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            BugCatcherManager.getBugCatcher().logError(sAXException);
        }
        System.out.println("nameSpaceURI: " + nameSpaceURI);
        int daysTillExpire = 15;
        File schemaFile = null;
        if (nameSpaceURI != null && nameSpaceURI.toLowerCase().startsWith("http:/")) {
            schemaFile = sessionStorage.updateCache(nameSpaceURI, daysTillExpire, false);
        }
        if (nameSpaceURI != null && nameSpaceURI.toLowerCase().startsWith("file:/")) {
            try {
                schemaFile = new File(new URI(nameSpaceURI));
            }
            catch (URISyntaxException ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
            }
        }
        URL schemaURL = null;
        if (!MetadataFormat.isPathImdi(metadataFile.toString())) {
            try {
                schemaURL = schemaFile.toURL();
            }
            catch (Exception e) {
                System.out.println("error getting xsd from the server: " + e.getMessage());
            }
        } else {
            if (schemaFile == null || !schemaFile.exists()) {
                schemaFile = sessionStorage.updateCache("http://www.mpi.nl/IMDI/Schema/IMDI_3.0.xsd", daysTillExpire, false);
            }
            if (schemaFile.exists()) {
                try {
                    schemaURL = schemaFile.toURL();
                }
                catch (Exception e) {
                    System.out.println("error getting xsd from the server: " + e.getMessage());
                }
            }
            if (schemaURL == null) {
                schemaURL = this.getClass().getResource("/nl/mpi/arbil/resources/IMDI/FallBack/IMDI_3.0.xsd");
            }
        }
        return schemaURL;
    }

    private void alternateCheck(File metadataFile) throws Exception {
        URL schemaURL = this.getXsd(metadataFile);
        if (schemaURL == null) {
            this.doc.insertString(this.doc.getLength(), "Failed to find the schema file.\n\n", this.styleFatalError);
        } else {
            this.doc.insertString(this.doc.getLength(), "using schema file: " + schemaURL.getFile() + "\n\n", this.styleNormal);
            StreamSource xmlFile = new StreamSource(metadataFile);
            String checkingString = "Checking, please wait...\n\n";
            int checkingOffset = this.doc.getLength();
            this.doc.insertString(checkingOffset, "Checking, please wait...\n\n", this.styleNormal);
            Validator validator = this.createValidator(schemaURL);
            class CustomErrorHandler
            implements ErrorHandler {
                File imdiFile;

                public CustomErrorHandler(File imdiFileLocal) {
                    this.imdiFile = imdiFileLocal;
                }

                private String getLine(int lineNumber) {
                    try {
                        String returnText = "";
                        Scanner scanner = new Scanner(this.imdiFile);
                        for (int lineCounter = 0; lineCounter < lineNumber - 1; ++lineCounter) {
                            returnText = scanner.nextLine();
                        }
                        return lineNumber - 1 + ": " + returnText + "\n" + lineNumber + ": " + scanner.nextLine() + "\n" + (lineNumber + 1) + ": " + scanner.nextLine();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        BugCatcherManager.getBugCatcher().logError(fileNotFoundException);
                        return fileNotFoundException.getMessage();
                    }
                }

                public void warning(SAXParseException exception) throws SAXException {
                    try {
                        XsdChecker.this.doc.insertString(XsdChecker.this.doc.getLength(), "warning: " + exception.getMessage() + "\nline: " + exception.getLineNumber() + " col: " + exception.getColumnNumber() + "\n" + this.getLine(exception.getLineNumber()) + "\n", XsdChecker.this.styleWarning);
                    }
                    catch (BadLocationException badLocationException) {
                        BugCatcherManager.getBugCatcher().logError(badLocationException);
                    }
                }

                public void error(SAXParseException exception) throws SAXException {
                    try {
                        XsdChecker.this.doc.insertString(XsdChecker.this.doc.getLength(), "error: " + exception.getMessage() + "\nline: " + exception.getLineNumber() + " col: " + exception.getColumnNumber() + "\n" + this.getLine(exception.getLineNumber()) + "\n", XsdChecker.this.styleError);
                    }
                    catch (BadLocationException badLocationException) {
                        BugCatcherManager.getBugCatcher().logError(badLocationException);
                    }
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    try {
                        XsdChecker.this.doc.insertString(XsdChecker.this.doc.getLength(), "fatalError: " + exception.getMessage() + "\nline: " + exception.getLineNumber() + " col: " + exception.getColumnNumber() + "\n" + this.getLine(exception.getLineNumber()) + "\n", XsdChecker.this.styleError);
                    }
                    catch (BadLocationException badLocationException) {
                        BugCatcherManager.getBugCatcher().logError(badLocationException);
                    }
                }
            }
            CustomErrorHandler errorHandler = new CustomErrorHandler(metadataFile);
            validator.setErrorHandler(errorHandler);
            try {
                validator.validate(xmlFile);
            }
            catch (SAXException e) {
                System.out.println(xmlFile.getSystemId() + " is NOT valid");
                System.out.println("Reason: " + e.getLocalizedMessage());
                this.doc.insertString(this.doc.getLength(), xmlFile.getSystemId() + " is NOT valid\n", this.styleError);
                this.doc.insertString(this.doc.getLength(), "Reason: " + e.getLocalizedMessage() + "\n", this.styleError);
            }
            this.doc.remove(checkingOffset, "Checking, please wait...\n\n".length());
        }
    }

    public String simpleCheck(File metadataFile) {
        URL schemaURL = this.getXsd(metadataFile);
        StreamSource xmlFile = new StreamSource(metadataFile);
        try {
            Validator validator = this.createValidator(schemaURL);
            validator.validate(xmlFile);
            return null;
        }
        catch (Exception e) {
            String messageString = "Error validating " + metadataFile.toURI() + "\n" + "Reason: " + e.getLocalizedMessage() + "\n";
            return messageString;
        }
    }

    public void checkXML(final ArbilDataNode dataNode) {
        Runnable checkXmlRunner = new Runnable(){

            public void run() {
                XsdChecker.this.doCheckXML(dataNode);
            }
        };
        Thread thread = new Thread(checkXmlRunner);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheckXML(final ArbilDataNode imdiObject) {
        this.encounteredAdditionalErrors = false;
        try {
            this.doc.insertString(this.doc.getLength(), "Checking the IMDI file conformance to the XSD\nThere are three types or messages: ", this.styleNormal);
            this.doc.insertString(this.doc.getLength(), "Message, ", this.styleWarning);
            this.doc.insertString(this.doc.getLength(), "Errors, ", this.styleError);
            this.doc.insertString(this.doc.getLength(), "and ", this.styleNormal);
            this.doc.insertString(this.doc.getLength(), "Fatal Errors.\n\n", this.styleFatalError);
            ArbilDataNode arbilDataNode = imdiObject;
            synchronized (arbilDataNode) {
                this.alternateCheck(imdiObject.getFile());
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        XsdChecker.this.fileViewPane.setPage(imdiObject.getURI().toURL());
                    }
                    catch (Exception ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                    }
                }
            });
        }
        catch (Exception ex) {
            this.encounteredAdditionalErrors = true;
            this.reportedError = ex.getMessage();
            System.out.println(ex.getMessage());
        }
        try {
            if (this.encounteredAdditionalErrors) {
                this.doc.insertString(this.doc.getLength(), "\n" + this.reportedError + "\n", this.styleFatalError);
            }
            this.doc.insertString(this.doc.getLength(), "\nDone.\n", this.styleWarning);
        }
        catch (Exception ex) {
            System.out.println("error: " + ex.getMessage());
        }
    }
}

