/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.util.XsdChecker;
import nl.mpi.arbil.util.task.ArbilTask;
import nl.mpi.arbil.util.task.ArbilTaskListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataNodeLoaderThreadManager {
    private static final Logger logger = LoggerFactory.getLogger(DataNodeLoaderThreadManager.class);
    private static final int MAX_REMOTE_THREADS = 6;
    private static final int MAX_LOCAL_THREADS = 6;
    private boolean continueThread = true;
    private int arbilFilesLoaded = 0;
    private int remoteArbilFilesLoaded = 0;
    private int threadStartCounter = 0;
    private ThreadGroup remoteLoaderThreadGroup;
    private ThreadGroup localLoaderThreadGroup;
    private final Vector<ArbilDataNode> arbilRemoteNodesToInit = new Vector();
    private final Vector<ArbilDataNode> arbilLocalNodesToInit = new Vector();
    private boolean schemaCheckLocalFiles = false;
    private ScheduledThreadPoolExecutor remoteExecutor = new ScheduledThreadPoolExecutor(DataNodeLoaderThreadManager.MAX_REMOTE_THREADS()){

        protected void beforeExecute(Thread t, Runnable r) {
            DataNodeLoaderThreadManager.this.beforeExecuteLoaderThread(t, r, false);
        }

        protected void afterExecute(Runnable r, Throwable t) {
            DataNodeLoaderThreadManager.this.afterExecuteLoaderThread(r, t, false);
        }

        public ThreadFactory getThreadFactory() {
            return new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    String threadName = "ArbilDataNodeLoader-remote-" + DataNodeLoaderThreadManager.this.threadStartCounter++;
                    Thread thread = new Thread(DataNodeLoaderThreadManager.this.remoteLoaderThreadGroup, r, threadName);
                    thread.setPriority(4);
                    return thread;
                }
            };
        }
    };
    private ScheduledThreadPoolExecutor localExecutor = new ScheduledThreadPoolExecutor(DataNodeLoaderThreadManager.MAX_LOCAL_THREADS()){

        protected void beforeExecute(Thread t, Runnable r) {
            DataNodeLoaderThreadManager.this.beforeExecuteLoaderThread(t, r, true);
        }

        protected void afterExecute(Runnable r, Throwable t) {
            DataNodeLoaderThreadManager.this.afterExecuteLoaderThread(r, t, true);
        }

        public ThreadFactory getThreadFactory() {
            return new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    String threadName = "ArbilDataNodeLoader-local-" + DataNodeLoaderThreadManager.this.threadStartCounter++;
                    Thread thread = new Thread(DataNodeLoaderThreadManager.this.localLoaderThreadGroup, r, threadName);
                    thread.setPriority(4);
                    return thread;
                }
            };
        }
    };
    private Set<ArbilTaskListener> taskListeners = new HashSet<ArbilTaskListener>();
    private int loadingNodesCount = 0;
    private ArbilTask loadingTask = null;

    public DataNodeLoaderThreadManager() {
        this.remoteLoaderThreadGroup = new ThreadGroup("RemoteLoaderThreads");
        this.localLoaderThreadGroup = new ThreadGroup("LocalLoaderThreads");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeToQueue(ArbilDataNode nodeToAdd) {
        this.startLoaderThreads();
        if (ArbilDataNode.isStringLocal(nodeToAdd.getUrlString())) {
            Vector<ArbilDataNode> vector = this.arbilLocalNodesToInit;
            synchronized (vector) {
                if (!this.arbilLocalNodesToInit.contains(nodeToAdd)) {
                    nodeToAdd.updateLoadingState(1);
                    this.arbilLocalNodesToInit.addElement(nodeToAdd);
                    this.arbilLocalNodesToInit.notifyAll();
                }
            }
        }
        Vector<ArbilDataNode> vector = this.arbilRemoteNodesToInit;
        synchronized (vector) {
            if (!this.arbilRemoteNodesToInit.contains(nodeToAdd)) {
                nodeToAdd.updateLoadingState(1);
                this.arbilRemoteNodesToInit.addElement(nodeToAdd);
                this.arbilRemoteNodesToInit.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArbilDataNode getNodeFromQueue(Vector<ArbilDataNode> dataNodesQueue) {
        Vector<ArbilDataNode> vector = dataNodesQueue;
        synchronized (vector) {
            if (dataNodesQueue.size() > 0) {
                ArbilDataNode tempDataNode = dataNodesQueue.remove(0);
                if (tempDataNode.lockedByLoadingThread) {
                    dataNodesQueue.add(tempDataNode);
                    return null;
                }
                tempDataNode.lockedByLoadingThread = true;
                dataNodesQueue.notifyAll();
                return tempDataNode;
            }
            return null;
        }
    }

    public synchronized void startLoaderThreads() {
        while (this.isContinueThread() && this.remoteExecutor.getActiveCount() < DataNodeLoaderThreadManager.MAX_REMOTE_THREADS()) {
            this.remoteExecutor.submit(new RemoteLoader());
        }
        while (this.isContinueThread() && this.localExecutor.getActiveCount() < DataNodeLoaderThreadManager.MAX_LOCAL_THREADS()) {
            this.localExecutor.submit(new LocalLoader());
        }
    }

    synchronized void stopLoaderThreads() {
        this.remoteExecutor.shutdownNow();
        this.localExecutor.shutdownNow();
    }

    public boolean isSchemaCheckLocalFiles() {
        return this.schemaCheckLocalFiles;
    }

    public void setSchemaCheckLocalFiles(boolean schemaCheckLocalFiles) {
        this.schemaCheckLocalFiles = schemaCheckLocalFiles;
    }

    public boolean isContinueThread() {
        return this.continueThread;
    }

    public void setContinueThread(boolean continueThread) {
        this.continueThread = continueThread;
    }

    public static int MAX_REMOTE_THREADS() {
        return 6;
    }

    public static int MAX_LOCAL_THREADS() {
        return 6;
    }

    protected void beforeExecuteLoaderThread(Thread t, Runnable r, boolean local) {
    }

    protected void afterExecuteLoaderThread(Runnable r, Throwable t, boolean local) {
    }

    private synchronized void addToLoadingTask(int count) {
        this.loadingNodesCount += count;
        if (this.loadingNodesCount == 0) {
            // empty if block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocalLoader
    extends Loader {
        private LocalLoader() {
        }

        @Override
        protected Vector<ArbilDataNode> getNodesToInit() {
            return DataNodeLoaderThreadManager.this.arbilLocalNodesToInit;
        }

        @Override
        protected void loadNode(ArbilDataNode currentArbilDataNode) {
            if (currentArbilDataNode.getNeedsSaveToDisk(false)) {
                currentArbilDataNode.saveChangesToCache(false);
            }
            currentArbilDataNode.loadArbilDom();
            if (DataNodeLoaderThreadManager.this.isSchemaCheckLocalFiles()) {
                if (currentArbilDataNode.isMetaDataNode()) {
                    XsdChecker xsdChecker = new XsdChecker();
                    String checkerResult = xsdChecker.simpleCheck(currentArbilDataNode.getFile());
                    currentArbilDataNode.hasSchemaError = checkerResult != null;
                }
            } else {
                currentArbilDataNode.hasSchemaError = false;
            }
            currentArbilDataNode.updateLoadingState(-1);
            currentArbilDataNode.clearIcon();
            currentArbilDataNode.clearChildIcons();
            DataNodeLoaderThreadManager.this.arbilFilesLoaded++;
            currentArbilDataNode.lockedByLoadingThread = false;
            currentArbilDataNode.notifyLoaded();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemoteLoader
    extends Loader {
        private RemoteLoader() {
        }

        @Override
        protected Vector<ArbilDataNode> getNodesToInit() {
            return DataNodeLoaderThreadManager.this.arbilRemoteNodesToInit;
        }

        @Override
        protected void loadNode(ArbilDataNode currentArbilDataNode) {
            currentArbilDataNode.loadArbilDom();
            currentArbilDataNode.updateLoadingState(-1);
            currentArbilDataNode.clearIcon();
            currentArbilDataNode.clearChildIcons();
            DataNodeLoaderThreadManager.this.remoteArbilFilesLoaded++;
            currentArbilDataNode.notifyLoaded();
            currentArbilDataNode.lockedByLoadingThread = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class Loader
    implements Runnable {
        private Loader() {
        }

        protected abstract void loadNode(ArbilDataNode var1);

        protected abstract Vector<ArbilDataNode> getNodesToInit();

        @Override
        public void run() {
            ArbilDataNode currentArbilDataNode = null;
            while (DataNodeLoaderThreadManager.this.isContinueThread() && !Thread.currentThread().isInterrupted()) {
                try {
                    currentArbilDataNode = this.waitForNodes(this.getNodesToInit());
                }
                catch (InterruptedException ex) {
                    logger.debug(Thread.currentThread().getName() + " interrupted. " + ex.getMessage());
                    return;
                }
                if (currentArbilDataNode == null) continue;
                this.loadNode(currentArbilDataNode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ArbilDataNode waitForNodes(Vector<ArbilDataNode> queue) throws InterruptedException {
            Vector<ArbilDataNode> vector = queue;
            synchronized (vector) {
                while (queue.isEmpty()) {
                    queue.wait();
                }
                return DataNodeLoaderThreadManager.this.getNodeFromQueue(queue);
            }
        }
    }
}

