/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data.importexport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.MetadataBuilder;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.flap.plugin.PluginDialogHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArbilCsvImporter {
    private static final Logger logger = LoggerFactory.getLogger(ArbilCsvImporter.class);
    private static MessageDialogHandler messageDialogHandler;
    private static DataNodeLoader dataNodeLoader;
    private ArbilDataNode destinationCorpusNode;

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public static void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        dataNodeLoader = dataNodeLoaderInstance;
    }

    public ArbilCsvImporter(ArbilDataNode destinationCorpusNodeLocal) {
        this.destinationCorpusNode = destinationCorpusNodeLocal;
    }

    public void doImport() {
        File[] selectedFiles = messageDialogHandler.showFileSelectBox("Import CSV", false, true, null, PluginDialogHandler.DialogueType.open, null);
        if (selectedFiles != null && selectedFiles.length > 0) {
            for (File currentFile : selectedFiles) {
                this.processCsvFile(currentFile);
            }
        }
    }

    private void cleanQuotes(String[] arrayToClean, String fileType) {
        if (arrayToClean.length > 0 && fileType.indexOf("\"") != -1) {
            arrayToClean[0] = arrayToClean[0].replaceAll("^\"", "");
            arrayToClean[arrayToClean.length - 1] = arrayToClean[arrayToClean.length - 1].replaceAll("\"$", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCsvFile(File inputFile) {
        String[] csvHeaders = null;
        String fileType = ",";
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(inputFile));
            String currentLine = "";
            String remainderOfLastLine = "";
            Object stringTokeniser = null;
            while ((currentLine = bufferedReader.readLine()) != null) {
                if (csvHeaders == null) {
                    fileType = "\"\\t\"";
                    csvHeaders = currentLine.split(fileType);
                    if (csvHeaders.length == 1) {
                        fileType = "\t";
                        csvHeaders = currentLine.split(fileType);
                    }
                    if (csvHeaders.length == 1) {
                        fileType = "\",\"";
                        csvHeaders = currentLine.split(fileType);
                    }
                    if (csvHeaders.length == 1) {
                        fileType = ",";
                        csvHeaders = currentLine.split(fileType);
                    }
                    this.cleanQuotes(csvHeaders, fileType);
                    continue;
                }
                boolean skipLine = false;
                if (fileType.contains("\"")) {
                    if (!currentLine.endsWith("\"")) {
                        remainderOfLastLine = remainderOfLastLine + "\n" + currentLine;
                        skipLine = true;
                    } else if (remainderOfLastLine.length() > 0) {
                        currentLine = remainderOfLastLine + "\n" + currentLine;
                        remainderOfLastLine = "";
                    }
                }
                if (skipLine) continue;
                String nodeType = ".METATRANSCRIPT.Session";
                ArbilDataNode addedImdiObject = dataNodeLoader.getArbilDataNode(null, new MetadataBuilder().addChildNode(this.destinationCorpusNode, nodeType, null, null, null));
                addedImdiObject.waitTillLoaded();
                Hashtable<String, ArbilField[]> addedNodesFields = addedImdiObject.getFields();
                String[] currentLineArray = currentLine.split(fileType);
                this.cleanQuotes(currentLineArray, fileType);
                for (int columnCounter = 0; columnCounter < csvHeaders.length && columnCounter < currentLineArray.length; ++columnCounter) {
                    logger.debug(csvHeaders[columnCounter] + " : " + currentLineArray[columnCounter]);
                    ArbilField[] currentFieldArray = addedNodesFields.get(csvHeaders[columnCounter]);
                    if (currentFieldArray == null) continue;
                    currentFieldArray[0].setFieldValue(currentLineArray[columnCounter], false, true);
                }
            }
        }
        catch (IOException ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
        catch (ArbilMetadataException ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
        catch (RuntimeException ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ioe) {
                    BugCatcherManager.getBugCatcher().logError(ioe);
                }
            }
        }
    }
}

