/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data.importexport;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.security.KeyStoreException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.nikhef.slcshttps.CAHttps;
import nl.nikhef.slcshttps.PKCS12Https;
import nl.nikhef.slcshttps.gui.CATool;
import nl.nikhef.slcshttps.gui.GraphTools;
import nl.nikhef.slcshttps.gui.SURFCAInitDialog;
import nl.nikhef.slcshttps.trust.HttxURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShibbolethNegotiator
implements ActionListener {
    private static final Logger logger = LoggerFactory.getLogger(ShibbolethNegotiator.class);
    private static MessageDialogHandler messageDialogHandler;
    static CAHttps myCA;
    JPanel shibbolethControlPanel = null;
    JButton infoCaMenuItem;

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public ShibbolethNegotiator() {
        System.setProperty("nl.nikhef.slcshttps.CERT_URL", "https://knikker.surfnet.nl/onlineca/x509.php");
        System.setProperty("nl.nikhef.slcshttps.AUTH_URL", "https://knikker.surfnet.nl/onlineca/x509.php?hash=");
    }

    public boolean checkCertDate() {
        Calendar dateCheckCalendar = Calendar.getInstance();
        logger.debug("Today : " + dateCheckCalendar.getTime());
        dateCheckCalendar.add(5, -12);
        try {
            myCA.getCertificate().checkValidity(dateCheckCalendar.getTime());
        }
        catch (CertificateExpiredException cee) {
            return false;
        }
        catch (CertificateNotYetValidException cnyve) {
            return false;
        }
        catch (KeyStoreException kse) {
            return false;
        }
        return true;
    }

    public HttpURLConnection getShibbolethConnection(HttpURLConnection currentConnection) {
        try {
            return new HttxURLConnection(currentConnection);
        }
        catch (IOException ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
            messageDialogHandler.addMessageDialogToQueue("The Shibboleth Connection failed with: " + ex.getMessage(), "Shibboleth Connection");
            return currentConnection;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("caInit")) {
            try {
                myCA = SURFCAInitDialog.getDialog((CAHttps)myCA);
            }
            catch (Exception caExcep) {
                BugCatcherManager.getBugCatcher().logError(caExcep);
                messageDialogHandler.addMessageDialogToQueue("The Shibboleth 'CA Init' failed with: " + caExcep.getMessage(), "Shibboleth Connection");
            }
        }
        if (e.getActionCommand().equals("pkcs12Import")) {
            try {
                if (myCA == null || GraphTools.confirmPopup((String)"CA exists, replace?")) {
                    myCA = new PKCS12Https();
                    ((PKCS12Https)myCA).initialize();
                    ((PKCS12Https)myCA).storeCertificate();
                    myCA.setHttxSSLSocketFactory();
                }
            }
            catch (Exception caExcep) {
                BugCatcherManager.getBugCatcher().logError(caExcep);
                messageDialogHandler.addMessageDialogToQueue("The Shibboleth 'pkcs12 Import' failed with: " + caExcep.getMessage(), "Shibboleth Connection");
            }
        }
        if (e.getActionCommand().equals("caInfo")) {
            try {
                CATool.showCATool((CAHttps)myCA);
            }
            catch (Exception certExcep) {
                BugCatcherManager.getBugCatcher().logError(certExcep);
                messageDialogHandler.addMessageDialogToQueue("The Shibboleth 'CA Info' failed with: " + certExcep.getMessage(), "Shibboleth Connection");
            }
        }
        if (this.infoCaMenuItem != null) {
            this.infoCaMenuItem.setEnabled(myCA != null);
        }
    }

    public JPanel getControlls() {
        if (this.shibbolethControlPanel == null) {
            this.shibbolethControlPanel = new JPanel();
            this.shibbolethControlPanel.setLayout(new BoxLayout(this.shibbolethControlPanel, 3));
            this.shibbolethControlPanel.setBorder(BorderFactory.createEtchedBorder());
            this.infoCaMenuItem = new JButton("Certificate Information");
            this.infoCaMenuItem.setMnemonic('N');
            this.infoCaMenuItem.setActionCommand("caInfo");
            this.infoCaMenuItem.addActionListener(this);
            this.infoCaMenuItem.setEnabled(myCA != null);
            this.shibbolethControlPanel.add(this.infoCaMenuItem);
            JButton initCaMenuItem = new JButton("Log in");
            initCaMenuItem.setMnemonic('I');
            initCaMenuItem.setActionCommand("caInit");
            initCaMenuItem.addActionListener(this);
            this.shibbolethControlPanel.add(initCaMenuItem);
            JButton pkcs12ImportMenuItem = new JButton("Import PKCS12 file");
            pkcs12ImportMenuItem.setMnemonic('P');
            pkcs12ImportMenuItem.setActionCommand("pkcs12Import");
            pkcs12ImportMenuItem.addActionListener(this);
            this.shibbolethControlPanel.add(pkcs12ImportMenuItem);
        }
        return this.shibbolethControlPanel;
    }

    static {
        myCA = null;
    }
}

