/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArbilLogConsole {
    private static final Logger logger = LoggerFactory.getLogger(ArbilLogConsole.class);
    private final JDialog logDialog;
    private final JTextArea logTextArea;
    private Handler logHandler;

    public ArbilLogConsole(Frame owner) {
        this.logDialog = new JDialog(owner, "Arbil log console");
        this.logDialog.setModal(false);
        this.logDialog.setLayout(new BorderLayout());
        this.logDialog.setSize(new Dimension(600, 400));
        this.logDialog.setDefaultCloseOperation(2);
        this.logTextArea = new JTextArea();
        this.logTextArea.setEditable(false);
        this.logTextArea.setLineWrap(true);
        JScrollPane logTextAreaScrollPane = new JScrollPane(this.logTextArea);
        this.logDialog.add((Component)logTextAreaScrollPane, "Center");
        JButton closeButton = new JButton(new AbstractAction("Close"){

            public void actionPerformed(ActionEvent e) {
                ArbilLogConsole.this.logDialog.dispose();
            }
        });
        this.logDialog.add((Component)closeButton, "South");
        this.logDialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                ArbilLogConsole.this.removeHandlerFromLogger();
                logger.info("Log console closing");
            }
        });
        logger.debug("Log console created");
    }

    public void show() {
        this.addNewHandlerToLogger();
        this.logDialog.setVisible(true);
        logger.info("Log console shown");
    }

    private void addNewHandlerToLogger() throws SecurityException {
        this.logHandler = new ArbilLogConsoleHandler();
        LogManager.getLogManager().getLogger("").addHandler(this.logHandler);
    }

    private void removeHandlerFromLogger() throws SecurityException {
        if (this.logHandler != null) {
            logger.debug("Removing log handler");
            LogManager.getLogManager().getLogger("").removeHandler(this.logHandler);
        }
    }

    private class ArbilLogConsoleHandler
    extends Handler {
        private final DateFormat df = DateFormat.getDateTimeInstance(3, 3);

        private ArbilLogConsoleHandler() {
        }

        public void publish(final LogRecord record) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ArbilLogConsole.this.logTextArea.append(String.format("%s [%s] %s - %s\n", ArbilLogConsoleHandler.this.df.format(new Date(record.getMillis())), record.getLevel().toString(), record.getLoggerName(), record.getMessage().toString()));
                    if (record.getThrown() != null) {
                        this.printStackTrace();
                    }
                }

                private void printStackTrace() {
                    StringWriter sw = new StringWriter();
                    record.getThrown().printStackTrace(new PrintWriter((Writer)sw, true));
                    ArbilLogConsole.this.logTextArea.append(sw.toString());
                }
            });
        }

        public void flush() {
            logger.debug("Log console handler flushed");
        }

        public void close() throws SecurityException {
        }
    }
}

