/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.ArbilTableCell;
import nl.mpi.arbil.ui.AbstractArbilTableModel;
import nl.mpi.arbil.ui.ArbilFieldView;
import nl.mpi.arbil.ui.ArbilFieldViews;
import nl.mpi.arbil.ui.ArbilListDataListener;
import nl.mpi.arbil.ui.ArbilSplitPanel;
import nl.mpi.arbil.ui.ImageBoxRenderer;
import nl.mpi.arbil.util.ApplicationVersion;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.ArbilActionBuffer;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilTableModel
extends AbstractArbilTableModel
implements ClipboardOwner {
    private static final Logger logger = LoggerFactory.getLogger(ArbilTableModel.class);
    public static final char CSV_NEWLINE = '\n';
    public static final String CSV_SEPARATOR = "\t";
    public static final String CSV_DOUBLE_QUOTE = "\"\"";
    public static final char CSV_QUOTE = '\"';
    public static final String CSV_QUOTE_STRING = "\"";
    private Hashtable<String, ArbilDataNode> dataNodeHash = new Hashtable();
    private ArbilTableCell[][] data = new ArbilTableCell[0][0];
    private DefaultListModel listModel = new DefaultListModel();
    private boolean widthsChanged = true;
    private JLabel hiddenColumnsLabel;
    public boolean hideContextMenuAndStatusBar;
    private final ImageBoxRenderer imageBoxRenderer;
    protected static MessageDialogHandler messageDialogHandler;
    private static ApplicationVersionManager versionManager;
    private ArbilActionBuffer reloadRunner = new ArbilActionBuffer("TableReload-" + this.hashCode(), 50){

        public void executeAction() {
            ArbilTableModel.this.reloadTableDataPrivate();
        }
    };

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public static void setVersionManager(ApplicationVersionManager versionManagerInstance) {
        versionManager = versionManagerInstance;
    }

    public ArbilTableModel(ImageBoxRenderer imageBoxRenderer) {
        super(ArbilFieldViews.getSingleInstance().getCurrentGlobalView().clone());
        this.imageBoxRenderer = imageBoxRenderer;
    }

    public ArbilTableModel(ArbilFieldView tableFieldView, ImageBoxRenderer imageBoxRenderer) {
        super(tableFieldView);
        this.imageBoxRenderer = imageBoxRenderer;
    }

    public DefaultListModel getListModel(ArbilSplitPanel arbilSplitPanel) {
        ArbilListDataListener listDataListener = new ArbilListDataListener(arbilSplitPanel);
        this.listModel.addListDataListener(listDataListener);
        return this.listModel;
    }

    private void updateImageDisplayPanel() {
        this.listModel.removeAllElements();
        if (this.imageBoxRenderer != null) {
            for (int rowCounter = 0; rowCounter < this.data.length; ++rowCounter) {
                ArbilDataNode currentRowDataNode = this.getDataNodeFromRow(rowCounter);
                if (currentRowDataNode == null || !this.imageBoxRenderer.canDisplay(currentRowDataNode) || this.listModel.contains(currentRowDataNode)) continue;
                this.listModel.addElement(currentRowDataNode);
            }
        }
    }

    public void setHiddenColumnsLabel(JLabel hiddenColumnsLabelLocal) {
        this.hiddenColumnsLabel = hiddenColumnsLabelLocal;
    }

    @Override
    protected void updateHiddenColumnsLabel(int hiddenColumnCount, int hiddenCellsCount) {
        if (this.hiddenColumnsLabel != null) {
            this.hiddenColumnsLabel.setVisible(!this.hideContextMenuAndStatusBar && hiddenColumnCount > 0);
            this.hiddenColumnsLabel.setText(hiddenCellsCount + " cells hidden in " + hiddenColumnCount + " columns (edit \"Column View\" in the table header to show)");
        }
    }

    private String joinArray(Object[] arrayToJoin) {
        StringBuilder joinedString = new StringBuilder();
        boolean first = true;
        for (Object currentArrayItem : arrayToJoin) {
            if (!first) {
                joinedString.append(',');
            }
            first = false;
            joinedString.append(currentArrayItem.toString());
        }
        return joinedString.toString();
    }

    public void copyHtmlEmbedTagToClipboard(int tableHeight, int tableWidth) {
        try {
            ApplicationVersion appVersion = versionManager.getApplicationVersion();
            StringBuilder embadTagStringBuilder = new StringBuilder();
            embadTagStringBuilder.append("<applet codebase=\"http://www.mpi.nl/tg/j2se/jnlp/arbil/\"\n");
            embadTagStringBuilder.append(" code=\"nl.mpi.arbil.ui.applet.ArbilTableApplet.class\"\n");
            embadTagStringBuilder.append(" archive=\"arbil-").append(appVersion.branch).append("-").append(appVersion.currentMajor).append("-").append(appVersion.currentMinor).append("-").append(appVersion.currentRevision).append(".jar,");
            embadTagStringBuilder.append("lib/xmlbeans-2.4.0.jar,lib/stax-api-1.0.1.jar,lib/typechecker-1.7.0.jar,lib/slcshttps-0.2.jar,lib/imdi-api-1.1.2.jar,lib/mpi-util-1.0.0.jar,lib/Saxon-HE-9.4.jar,lib/jdom-1.1.jar,lib/xom-1.2.5.jar,lib/dom4j-1.6.1.jar,lib/xml-resolver-1.2.jar,lib/xercesImpl-2.9.0.jar,lib/xml-apis-1.3.04.jar,lib/xalan-2.7.1.jar,lib/serializer-2.7.1.jar,lib/commons-digester-2.0.jar,lib/commons-beanutils-1.8.0.jar,lib/commons-logging-1.1.1.jar,lib/log4j-1.2.16.jar,lib/corpusstructure-api-1.7.3.jar,lib/handle-6.1.jar,lib/commons-io-1.4.jar,lib/plugins-core-0.1.34211-pretesting.jar,lib/arbil-commons-0.2.34218-pretesting.jar,lib/arbil-localisation-1.0-SNAPSHOT.jar\"\n");
            embadTagStringBuilder.append(String.format(" width=\"%d\" height=\"%d\" >\n", tableWidth, tableHeight));
            embadTagStringBuilder.append(" <param name=\"ImdiFileList\" value=\"").append(this.joinArray(this.getArbilDataNodesURLs())).append("\">\n");
            embadTagStringBuilder.append(" <param name=\"ShowOnlyColumns\" value=\"").append(this.joinArray(this.getColumnNames())).append("\">\n");
            embadTagStringBuilder.append(" <param name=\"ChildNodeColumns\" value=\"").append(this.joinArray(this.getChildColumnNames().toArray())).append("\">\n");
            embadTagStringBuilder.append(" <param name=\"HighlightText\" value=\"").append(this.joinArray(this.getHighlightCells().toArray())).append("\">\n");
            embadTagStringBuilder.append("</applet>");
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(embadTagStringBuilder.toString());
            clipboard.setContents(stringSelection, this);
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    @Override
    public void dataNodeRemoved(ArbilNode dataNode) {
        if (!(dataNode instanceof ArbilDataNode)) {
            throw new UnsupportedOperationException("Cannot remove an ArbilNode from the table");
        }
        this.removeArbilDataNodes(new ArbilDataNode[]{(ArbilDataNode)dataNode});
    }

    @Override
    public void dataNodeIconCleared(ArbilNode dataNode) {
        this.requestReloadTableData();
    }

    @Override
    public void dataNodeChildAdded(ArbilNode destination, ArbilNode newNode) {
    }

    public boolean isWidthsChanged() {
        return this.widthsChanged;
    }

    public void setWidthsChanged(boolean widthsChanged) {
        this.widthsChanged = widthsChanged;
    }

    @Override
    protected Hashtable<String, ArbilDataNode> getDataNodeHash() {
        return this.dataNodeHash;
    }

    @Override
    protected synchronized void reloadTableDataPrivate() {
        super.reloadTableDataPrivate();
        this.updateImageDisplayPanel();
        this.setWidthsChanged(false);
    }

    @Override
    public void requestReloadTableData() {
        this.reloadRunner.requestActionAndNotify();
    }

    public void setPreferredColumnWidth(String columnName, Integer width) {
        Integer currentWidth = this.getFieldView().getColumnWidth(columnName);
        if (!(this.isWidthsChanged() || width == null && currentWidth == null || width != null && width.equals(currentWidth))) {
            this.setWidthsChanged(true);
            this.fireTableStructureChanged();
        }
        this.getFieldView().setColumnWidth(columnName, width);
    }

    public Integer getPreferredColumnWidth(String columnName) {
        return this.getFieldView().getColumnWidth(columnName);
    }

    public void copyArbilRows(int[] selectedRows) {
        int firstColumn = 0;
        if (this.isShowIcons() && this.isHorizontalView()) {
            firstColumn = 1;
        }
        int columnCount = this.getColumnCount();
        StringBuilder copiedString = new StringBuilder();
        for (int selectedColCounter = firstColumn; selectedColCounter < columnCount; ++selectedColCounter) {
            copiedString.append('\"').append(this.getColumnName(selectedColCounter)).append('\"');
            if (selectedColCounter >= columnCount - 1) continue;
            copiedString.append(CSV_SEPARATOR);
        }
        copiedString.append('\n');
        for (int selectedRowCounter = 0; selectedRowCounter < selectedRows.length; ++selectedRowCounter) {
            logger.debug("copying row: " + selectedRowCounter);
            for (int selectedColCounter = firstColumn; selectedColCounter < columnCount; ++selectedColCounter) {
                copiedString.append('\"').append(this.data[selectedRows[selectedRowCounter]][selectedColCounter].toString().replace(CSV_QUOTE_STRING, CSV_DOUBLE_QUOTE)).append('\"');
                if (selectedColCounter >= columnCount - 1) continue;
                copiedString.append(CSV_SEPARATOR);
            }
            copiedString.append('\n');
        }
        logger.debug("copiedString: " + copiedString.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(copiedString.toString());
        clipboard.setContents(stringSelection, this);
    }

    public void copyArbilFields(ArbilField[] selectedCells) {
        StringBuilder copiedString = new StringBuilder();
        copiedString.append('\"').append("Field Name".replace(CSV_QUOTE_STRING, CSV_DOUBLE_QUOTE)).append('\"').append(CSV_SEPARATOR);
        copiedString.append('\"').append("Value".replace(CSV_QUOTE_STRING, CSV_DOUBLE_QUOTE)).append('\"');
        copiedString.append('\n');
        boolean isFirstCol = true;
        for (ArbilField currentField : selectedCells) {
            if (!isFirstCol) {
                copiedString.append(CSV_SEPARATOR);
                isFirstCol = false;
            }
            copiedString.append('\"').append(currentField.getTranslateFieldName()).append('\"').append(CSV_SEPARATOR);
            copiedString.append('\"').append(currentField.getFieldValue()).append('\"');
            copiedString.append('\n');
        }
        logger.debug("copiedString: " + copiedString.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(copiedString.toString());
        clipboard.setContents(stringSelection, this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String pasteIntoArbilFields(ArbilField[] selectedCells) {
        boolean pastedFieldOverwritten = false;
        int pastedCount = 0;
        String resultMessage = null;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transfer = clipboard.getContents(null);
        try {
            String clipBoardString = "";
            Object clipBoardData = transfer.getTransferData(DataFlavor.stringFlavor);
            if (clipBoardData != null) {
                clipBoardString = clipBoardData.toString();
            }
            logger.debug("clipBoardString: " + clipBoardString);
            String[] clipBoardLines = clipBoardString.split("\"(\r?\n|\r)\"");
            if (clipBoardLines.length == 1) {
                clipBoardLines = clipBoardString.split("\r?\n|\r");
            }
            if (clipBoardLines.length == 1) {
                String messageString = selectedCells.length + " fields will be overwritten with the single value on the clipboard.\nContinue?";
                if (!messageDialogHandler.showConfirmDialogBox(messageString, "Paste")) return null;
                for (ArbilField targetField : selectedCells) {
                    targetField.setFieldValue(clipBoardString, true, false);
                    ++pastedCount;
                }
            } else if (clipBoardLines.length > 1) {
                String areYouSureMessageString = "";
                ArrayList<Object[]> pasteList = new ArrayList<Object[]>();
                int deletingValuesCounter = 0;
                String[] firstLine = clipBoardLines[0].split("\"\\t\"");
                if (firstLine.length == 1) {
                    firstLine = clipBoardLines[0].split(CSV_SEPARATOR);
                }
                boolean singleNodeAxis = false;
                String regexString = "[(\"^)($\")]";
                logger.debug("regexString: " + firstLine[0].replaceAll(regexString, ""));
                if (firstLine[0].replaceAll(regexString, "").equals("Field Name") && firstLine[1].replaceAll(regexString, "").equals("Value")) {
                    singleNodeAxis = true;
                }
                if (!singleNodeAxis) {
                    resultMessage = "Incorrect data to paste.\nThe data must be copied either from a table where only one IMDI file is displayed\nor by selecting individual cells in the table.";
                }
                if (singleNodeAxis) {
                    boolean pasteOneFieldToAll = clipBoardLines.length == 2;
                    HashSet<String> pastedFieldNames = new HashSet<String>();
                    for (int lineCounter = 1; lineCounter < clipBoardLines.length; ++lineCounter) {
                        String clipBoardLine = clipBoardLines[lineCounter];
                        logger.debug("clipBoardLine: " + clipBoardLine);
                        String[] clipBoardCells = clipBoardLine.split("\\t");
                        logger.debug("clipBoardCells.length: " + clipBoardCells.length);
                        if (clipBoardCells.length != 2) {
                            resultMessage = "Inconsistent number of columns in the data to paste.\nThe pasted data could be incorrect.";
                            continue;
                        }
                        String currentFieldName = clipBoardCells[0].replaceAll(regexString, "");
                        String currentFieldValue = clipBoardCells[1].replaceAll(regexString, "");
                        if (pastedFieldNames.contains(currentFieldName)) {
                            pastedFieldOverwritten = true;
                        } else {
                            pastedFieldNames.add(currentFieldName);
                        }
                        if (selectedCells == null) continue;
                        for (ArbilField targetField : selectedCells) {
                            logger.debug("targetField: " + targetField.getTranslateFieldName());
                            if (!currentFieldName.equals(targetField.getTranslateFieldName()) && !pasteOneFieldToAll) continue;
                            if (currentFieldValue.trim().length() == 0 && targetField.getFieldValue().trim().length() > 0) {
                                ++deletingValuesCounter;
                            }
                            pasteList.add(new Object[]{targetField, currentFieldValue});
                        }
                    }
                    if (pastedFieldOverwritten) {
                        areYouSureMessageString = areYouSureMessageString + "Two fields of the same name are to be pasted into this table,\nthis will cause at least one field to be overwritten by another.\n\n";
                    }
                    if (deletingValuesCounter > 0) {
                        areYouSureMessageString = areYouSureMessageString + "There are " + deletingValuesCounter + " fields that will have their contents deleted by this paste action.\n\n";
                    }
                    if (areYouSureMessageString.length() > 0 && !messageDialogHandler.showConfirmDialogBox(areYouSureMessageString + "Continue?", "Paste")) {
                        return null;
                    }
                    for (Object[] pasteListObject : pasteList) {
                        ArbilField currentField = (ArbilField)pasteListObject[0];
                        String currentValue = (String)pasteListObject[1];
                        currentField.setFieldValue(currentValue, true, false);
                        ++pastedCount;
                    }
                }
            } else {
                resultMessage = "No data to paste.";
            }
            if (pastedCount != 0) return resultMessage;
            if (resultMessage != null) return resultMessage;
            return "No fields matched the data on the clipboard.";
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
        return resultMessage;
    }

    @Override
    public void removeAllArbilDataNodeRows() {
        this.listModel.removeAllElements();
        super.removeAllArbilDataNodeRows();
    }

    @Override
    protected void removeArbilDataNode(ArbilDataNode arbilDataNode) {
        logger.debug("removing: " + arbilDataNode.toString());
        this.listModel.removeElement(arbilDataNode);
        super.removeArbilDataNode(arbilDataNode);
    }

    @Override
    protected ArbilTableCell[][] getData() {
        return this.data;
    }

    @Override
    protected void setData(ArbilTableCell[][] data) {
        this.data = data;
    }

    @Override
    protected String getRenderedText(ArbilTableCell data) {
        return data.toString();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        logger.debug("lost clipboard ownership");
    }
}

