/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.util.ResourceBundle;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.ui.ArbilDragDrop;
import nl.mpi.arbil.ui.ArbilTrackingTree;
import nl.mpi.arbil.ui.ArbilTree;
import nl.mpi.arbil.ui.ArbilTreeController;
import nl.mpi.arbil.util.MessageDialogHandler;

public class ArbilTreePanels
extends JSplitPane {
    private JScrollPane localDirectoryScrollPane;
    private JScrollPane remoteCorpusScrollPane;
    private JScrollPane localCorpusScrollPane;
    private JScrollPane favouritesScrollPane;
    private JSplitPane leftLocalSplitPane = new JSplitPane();
    public ArbilTree localCorpusTree;
    public ArbilTree localDirectoryTree;
    public ArbilTree remoteCorpusTree;
    public ArbilTree favouritesTree;

    public ArbilTreePanels(ArbilTreeHelper treeHelper, ArbilTreeController treeController, MessageDialogHandler dialogHandler) {
        this.localDirectoryScrollPane = new JScrollPane();
        this.localCorpusScrollPane = new JScrollPane();
        this.remoteCorpusScrollPane = new JScrollPane();
        this.favouritesScrollPane = new JScrollPane();
        this.setDividerSize(5);
        this.setOrientation(0);
        this.setName("ArbilTreePanels");
        this.leftLocalSplitPane.setDividerSize(5);
        this.leftLocalSplitPane.setOrientation(0);
        this.leftLocalSplitPane.setName("ArbilTreePanelsInner");
        this.remoteCorpusTree = new ArbilTree(treeController, treeHelper, dialogHandler);
        this.localDirectoryTree = new ArbilTree(treeController, treeHelper, dialogHandler);
        this.localCorpusTree = new ArbilTrackingTree(treeController, treeHelper, dialogHandler);
        this.favouritesTree = new ArbilTree(treeController, treeHelper, dialogHandler);
        ArbilDragDrop.getSingleInstance().addDrag(this.remoteCorpusTree);
        ArbilDragDrop.getSingleInstance().addDrag(this.localDirectoryTree);
        ArbilDragDrop.getSingleInstance().addDrag(this.localCorpusTree);
        ArbilDragDrop.getSingleInstance().addDrag(this.favouritesTree);
        this.remoteCorpusTree.setModel(treeHelper.getRemoteCorpusTreeModel());
        this.remoteCorpusScrollPane.setViewportView(this.remoteCorpusTree);
        this.localCorpusTree.setModel(treeHelper.getLocalCorpusTreeModel());
        this.localCorpusScrollPane.setViewportView(this.localCorpusTree);
        this.localDirectoryTree.setModel(treeHelper.getLocalDirectoryTreeModel());
        this.localDirectoryScrollPane.setViewportView(this.localDirectoryTree);
        this.favouritesTree.setModel(treeHelper.getFavouritesTreeModel());
        this.favouritesScrollPane.setViewportView(this.favouritesTree);
        JTabbedPane treeTabPane = new JTabbedPane();
        treeTabPane.add(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("FILES"), this.localDirectoryScrollPane);
        treeTabPane.add(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("FAVOURITES"), this.favouritesScrollPane);
        this.leftLocalSplitPane.setBottomComponent(treeTabPane);
        this.leftLocalSplitPane.setLeftComponent(this.localCorpusScrollPane);
        this.setBottomComponent(this.leftLocalSplitPane);
        this.setLeftComponent(this.remoteCorpusScrollPane);
        treeHelper.setTrees(this);
        this.setDefaultTreePaneSize();
    }

    public final void setDefaultTreePaneSize() {
        this.setDividerLocation(0.33);
        this.leftLocalSplitPane.setDividerLocation(0.5);
    }

    public ArbilTree[] getTreeArray() {
        return new ArbilTree[]{this.localCorpusTree, this.localDirectoryTree, this.remoteCorpusTree, this.favouritesTree};
    }
}

