/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.ui.ArbilSplitPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindReplacePanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(FindReplacePanel.class);
    private static final String defaultFindText = "<enter find text>";
    private static final String defaultReplaceText = "<enter replacement text>";
    private final ArbilSplitPanel splitPanel;
    private final JButton closeButton;
    private final JTextField searchField;
    private final JTextField replaceField;
    private final JCheckBox useJavaRegExCheckBox;
    private final JButton searchButton;
    private final JButton replaceButton;
    private final Action closeAction = new AbstractAction("Close"){

        public void actionPerformed(ActionEvent e) {
            FindReplacePanel.this.splitPanel.showSearchPane();
        }
    };
    private final ActionListener findActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            logger.debug(actionEvent.toString());
            String searchString = "";
            if (!FindReplacePanel.this.searchField.getText().equals(FindReplacePanel.defaultFindText)) {
                searchString = FindReplacePanel.this.searchField.getText();
            }
            String replaceString = null;
            if (actionEvent.getSource().equals(FindReplacePanel.this.replaceButton)) {
                replaceString = "";
                if (!FindReplacePanel.this.replaceField.getText().equals(FindReplacePanel.defaultReplaceText)) {
                    replaceString = FindReplacePanel.this.replaceField.getText();
                }
            }
            if (actionEvent.getSource().equals(FindReplacePanel.this.replaceButton)) {
                for (ArbilField currentField : ((FindReplacePanel)FindReplacePanel.this).splitPanel.arbilTable.getSelectedFields()) {
                    String currentFieldString;
                    if (!currentField.getParentDataNode().isEditable() || !currentField.getFieldValue().contains(searchString) || !(currentFieldString = currentField.getFieldValue()).contains(searchString)) continue;
                    currentFieldString = currentFieldString.replace(searchString, replaceString);
                    currentField.setFieldValue(currentFieldString, true, false);
                }
                return;
            }
            int startColumn = ((FindReplacePanel)FindReplacePanel.this).splitPanel.arbilTable.getSelectedColumn();
            int startRow = ((FindReplacePanel)FindReplacePanel.this).splitPanel.arbilTable.getSelectedRow();
            boolean firstTime = true;
            if (startColumn < 0) {
                firstTime = false;
                startColumn = 0;
            }
            if (startRow < 0) {
                firstTime = false;
                startRow = 0;
            }
            for (int currentRow = startRow; currentRow < ((FindReplacePanel)FindReplacePanel.this).splitPanel.arbilTable.getRowCount(); ++currentRow) {
                for (int currentColumn = startColumn; currentColumn < ((FindReplacePanel)FindReplacePanel.this).splitPanel.arbilTable.getColumnCount(); ++currentColumn) {
                    if (firstTime) {
                        firstTime = false;
                        continue;
                    }
                    ArbilField[] currentCellValue = ((FindReplacePanel)FindReplacePanel.this).splitPanel.arbilTable.getTableCellContentAt(currentRow, currentColumn);
                    if (currentCellValue instanceof ArbilField) {
                        currentCellValue = new ArbilField[]{(ArbilField)currentCellValue};
                    }
                    if (!(currentCellValue instanceof ArbilField[])) continue;
                    for (ArbilField currentField : (ArbilField[])currentCellValue) {
                        if (!currentField.getFieldValue().contains(searchString)) continue;
                        ((FindReplacePanel)FindReplacePanel.this).splitPanel.arbilTable.setCellSelectionEnabled(true);
                        ((FindReplacePanel)FindReplacePanel.this).splitPanel.arbilTable.changeSelection(currentRow, currentColumn, false, false);
                        return;
                    }
                }
                startColumn = 0;
            }
        }
    };
    private final FocusListener findReplaceFocusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
            JTextField currentTextField = (JTextField)e.getSource();
            if (currentTextField.getText().equals(FindReplacePanel.defaultFindText) || currentTextField.getText().equals(FindReplacePanel.defaultReplaceText)) {
                currentTextField.setText("");
            }
            currentTextField.setForeground(Color.black);
        }

        public void focusLost(FocusEvent e) {
            JTextField currentTextField = (JTextField)e.getSource();
            if (currentTextField.getText().length() < 1) {
                currentTextField.setText(currentTextField.getName());
                currentTextField.setForeground(Color.gray);
            }
        }
    };

    public FindReplacePanel(ArbilSplitPanel splitPanelLocal) {
        this.splitPanel = splitPanelLocal;
        this.searchField = new JTextField(defaultFindText);
        this.replaceField = new JTextField(defaultReplaceText);
        this.searchField.setName(defaultFindText);
        this.replaceField.setName(defaultReplaceText);
        this.searchField.setForeground(Color.gray);
        this.replaceField.setForeground(Color.gray);
        this.useJavaRegExCheckBox = new JCheckBox("Regular Expression");
        this.useJavaRegExCheckBox.setToolTipText("Use Java Style Regular Expressions (eg: . any \\d digit \\s whitespace ? zero or once * zero or more + one or more ^ line start $ line end)");
        this.closeButton = new JButton(this.closeAction);
        this.searchButton = new JButton("Find Next");
        this.replaceButton = new JButton("Replace Selected");
        this.searchField.addActionListener(this.findActionListener);
        this.replaceField.addActionListener(this.findActionListener);
        this.searchButton.addActionListener(this.findActionListener);
        this.replaceButton.addActionListener(this.findActionListener);
        this.searchField.addFocusListener(this.findReplaceFocusListener);
        this.replaceField.addFocusListener(this.findReplaceFocusListener);
        this.add(new JLabel("Find:"));
        this.add(this.searchField);
        this.add(this.replaceField);
        this.add(this.searchButton);
        this.add(this.replaceButton);
        this.add(this.closeButton);
        this.getActionMap().put("close", this.closeAction);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "close");
    }

    public void requestFocusOnSearchField() {
        this.searchField.requestFocus();
    }
}

