/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.SimpleFormatter;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArbilLogConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(ArbilLogConfigurer.class);
    public static final String ARBIL_LOG_FILE_PREFIX = "arbil-log-";
    private final ApplicationVersion appVersion;

    public ArbilLogConfigurer(ApplicationVersion applicationVersion) {
        this.appVersion = applicationVersion;
    }

    public boolean configureLoggingFromResource(Class scopeClass, String resourceName) {
        return this.configureLogging(scopeClass.getResourceAsStream(resourceName));
    }

    public boolean configureLogging(InputStream configurationStream) {
        try {
            LogManager.getLogManager().readConfiguration(configurationStream);
            return true;
        }
        catch (IOException ex) {
            logger.error("Could not configure initial logging", (Throwable)ex);
        }
        catch (SecurityException ex) {
            logger.error("Could not configure initial logging", (Throwable)ex);
        }
        return false;
    }

    public void setLogFile(File logFile, Level level) throws IOException {
        java.util.logging.Logger defaultLogger = LogManager.getLogManager().getLogger("");
        for (Handler handler : defaultLogger.getHandlers()) {
            if (!(handler instanceof FileHandler)) continue;
            ((FileHandler)handler).close();
            defaultLogger.removeHandler(handler);
        }
        FileHandler handler = new FileHandler(logFile.getAbsolutePath(), true);
        handler.setLevel(level);
        handler.setFormatter(new SimpleFormatter());
        defaultLogger.addHandler(handler);
    }

    public boolean configureLoggingFromSessionStorage(SessionStorage sessionStorage) {
        File applicationSettingsDirectory = sessionStorage.getApplicationSettingsDirectory();
        File loggingPropertiesFile = new File(applicationSettingsDirectory, "logging.properties");
        boolean foundCustomLoggingProperties = this.configureFromPropertiesFile(loggingPropertiesFile);
        if (foundCustomLoggingProperties) {
            return true;
        }
        try {
            this.removeOldLogs(sessionStorage);
            File logFile = this.getLogFile(sessionStorage);
            logger.debug("Reconfiguring logging to write to {}", (Object)logFile);
            this.setLogFile(logFile, Level.INFO);
            logger.debug("Reconfigured logging to write to {}", (Object)logFile);
            return true;
        }
        catch (IOException ex) {
            logger.warn("Could not configure log file in session storage directory", (Throwable)ex);
            return false;
        }
    }

    private boolean configureFromPropertiesFile(File loggingProperties) {
        logger.debug("Looking for logging logging properties at {}", (Object)loggingProperties);
        if (loggingProperties.exists()) {
            try {
                this.configureLogging(new FileInputStream(loggingProperties));
                logger.debug("Reconfigured logging from logging properties at {}", (Object)loggingProperties);
                return true;
            }
            catch (FileNotFoundException ex) {
                logger.error("Could not find file {}", (Object)loggingProperties, (Object)ex);
            }
        }
        return false;
    }

    public File getLogFile(SessionStorage sessionStorage) {
        File file = new File(sessionStorage.getApplicationSettingsDirectory(), this.getCurrentVersionLogFileName());
        if (!file.exists()) {
            this.startNewLogFile(file, sessionStorage);
        }
        return file;
    }

    private String getCurrentVersionLogFileName() {
        return ARBIL_LOG_FILE_PREFIX + this.appVersion.currentMajor + "-" + this.appVersion.currentMinor + "-" + this.appVersion.currentRevision + ".txt";
    }

    private void startNewLogFile(File file, SessionStorage sessionStorage) {
        try {
            FileWriter logFile = new FileWriter(file, false);
            logFile.append(this.appVersion.applicationTitle + " log" + System.getProperty("line.separator") + "Version: " + this.appVersion.currentMajor + "." + this.appVersion.currentMinor + "." + this.appVersion.currentRevision + System.getProperty("line.separator") + this.appVersion.lastCommitDate + System.getProperty("line.separator") + "Compile Date: " + this.appVersion.compileDate + System.getProperty("line.separator") + "Operating System: " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version") + System.getProperty("line.separator") + "Java version: " + System.getProperty("java.version") + " by " + System.getProperty("java.vendor") + System.getProperty("line.separator") + "User: " + System.getProperty("user.name") + System.getProperty("line.separator") + "Storage directory: " + sessionStorage.getApplicationSettingsDirectory().toString() + System.getProperty("line.separator") + "Project directory: " + sessionStorage.getProjectDirectory().toString() + System.getProperty("line.separator") + "Project working directory: " + sessionStorage.getProjectWorkingDirectory().toString() + System.getProperty("line.separator") + "Log started: " + new Date().toString() + System.getProperty("line.separator"));
            logFile.append("======================================================================" + System.getProperty("line.separator"));
            logFile.close();
        }
        catch (IOException ex) {
            logger.error("failed to write to the log", (Throwable)ex);
        }
    }

    private void removeOldLogs(SessionStorage sessionStorage) {
        String currentApplicationVersionMatch = ARBIL_LOG_FILE_PREFIX + this.appVersion.currentMajor + "-" + this.appVersion.currentMinor + "-";
        String currentLogFileMatch = this.getCurrentVersionLogFileName();
        for (String currentFile : sessionStorage.getApplicationSettingsDirectory().list()) {
            if (!currentFile.startsWith(currentApplicationVersionMatch) || currentFile.startsWith(currentLogFileMatch)) continue;
            logger.debug("deleting old log file: {}", (Object)currentFile);
            if (new File(sessionStorage.getApplicationSettingsDirectory(), currentFile).delete()) continue;
            logger.warn("Did not delete old log file: " + currentFile);
        }
    }
}

