/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.corpusstructure;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashSet;
import nl.mpi.corpusstructure.AccessInfo;
import nl.mpi.corpusstructure.ArchiveAccessContext;
import nl.mpi.corpusstructure.ArchiveObjectsDB;
import nl.mpi.corpusstructure.ArchiveObjectsDBWrite;
import nl.mpi.corpusstructure.CorpusStructureDB;
import nl.mpi.corpusstructure.CorpusStructureDBImpl;
import nl.mpi.corpusstructure.NodeIdUtils;
import nl.mpi.corpusstructure.UnknownNodeException;
import nl.mpi.corpusstructure.UpdateInProgressException;
import nl.mpi.util.Checksum;
import nl.mpi.util.DBConnection;

public class ArchiveObjectsDBWriteImpl
extends CorpusStructureDBImpl
implements ArchiveObjectsDB,
ArchiveObjectsDBWrite,
CorpusStructureDB {
    protected static String[] tables = new String[]{ARCHIVEOBJECTS, CORPUSNODES, CORPUSSTRUCTURE, "accessgroups"};
    private boolean iAmTheUpdater = false;
    private boolean updateInProgress = true;
    private static boolean useExistingNodeIds = true;
    private HashSet knownGroups = new HashSet();
    private static boolean bootstrapMode = false;
    private PreparedStatement newObjectInArchiveObjectsSTM = null;
    private PreparedStatement newObjectWithIdInArchiveObjectsSTM = null;
    private PreparedStatement updateFileInfoInArchiveObjectsSTM = null;
    private PreparedStatement selectPIDForArchiveObjectsSTM = null;
    private PreparedStatement updatePIDInArchiveObjectsSTM = null;
    private PreparedStatement moveObjectInArchiveObjectsSTM = null;
    private PreparedStatement updateAccessInfoInArchiveObjectsSTM = null;
    private PreparedStatement updateCrawlTimeInArchiveObjectsSTM = null;
    private PreparedStatement updateChecksumInArchiveObjectsSTM = null;
    private PreparedStatement deleteObjectInArchiveObjectsSTM = null;
    private PreparedStatement getIdFromOldArchiveObjectsSTM = null;

    protected boolean isBootstrapMode() {
        return bootstrapMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveObjectsDBWriteImpl(String dbname, boolean bootstrapMode, String user, String passwd) {
        super(new Exception());
        String string = staticSyncFlag;
        synchronized (string) {
            this.db = new DBConnection(dbname, user, passwd, "CorpusStructureDBWriteImpl:constructor");
            if (this.db == null || !this.db.getStatus()) {
                if (this.db == null) {
                    logger.error((Object)"constructor: NULL DB connection!");
                } else {
                    logger.error((Object)("constructor: ERROR creating DB connection: " + this.db.getMessage()));
                }
                this.status = false;
                if (this.db != null) {
                    this.db.close();
                }
                return;
            }
            this.updateInProgress = this.checkUpdateInProgressLock(bootstrapMode);
            if (bootstrapMode && this.updateInProgress) {
                logger.error((Object)"constructor: ERROR: attempt to use bootstrap mode more than once at a time");
                this.status = false;
                this.db.close();
                this.db = null;
                return;
            }
            HashSet tableNames = this.getTableNames();
            if (tableNames.contains("ARCHIVEOBJECTS")) {
                logger.info((Object)"Existing ARCHIVEOBJECTS table found, will preserve existing node IDs.");
                useExistingNodeIds = true;
            } else {
                logger.info((Object)"No ARCHIVEOBJECTS table found, no existing node IDs, will generate all new node IDs.");
                useExistingNodeIds = false;
                if (!bootstrapMode) {
                    logger.error((Object)"To create a new ARCHIVEOBJECTS table, bootstrap mode must be used");
                    this.status = false;
                    this.db.close();
                    this.db = null;
                    return;
                }
            }
            ++instance;
            this.status = this.db.getStatus();
            if (!this.status) {
                logger.error((Object)("ERROR creating DB for " + dbname));
                this.db.close();
                this.db = null;
                return;
            }
            ArchiveObjectsDBWriteImpl.dbname = dbname;
            ArchiveObjectsDBWriteImpl.bootstrapMode = bootstrapMode;
            if (bootstrapMode) {
                this.iAmTheUpdater = true;
                logger.info((Object)"dropping old temp tables, if any");
                this.setTmpTableNames();
                this.dropTmpTables();
                logger.info((Object)"creating tables and indexes");
                this.createTables();
                this.createIndexes(true);
            }
            this.initArchiveAccessRoots();
            logger.info((Object)"creating prepared statements");
            this.initPreparedStatements();
            if (user == null || user.equals("imdiArchive")) {
                logger.warn((Object)("Username " + user + " suggests that all write access will fail!"));
            }
        }
    }

    protected synchronized void initPreparedStatements() {
        super.initPreparedStatements();
        try {
            this.newObjectInArchiveObjectsSTM = this.db.getConnection().prepareStatement("INSERT INTO " + ARCHIVEOBJECTS + " ( " + "URL, CRAWLTIME, ONSITE, SIZE, CHECKSUM, FILETIME, READRIGHTS, WRITERIGHTS, PID, ACCESSLEVEL ) " + "VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )");
            this.newObjectWithIdInArchiveObjectsSTM = this.db.getConnection().prepareStatement("INSERT INTO " + ARCHIVEOBJECTS + " ( NODEID, " + "URL, CRAWLTIME, ONSITE, SIZE, CHECKSUM, FILETIME, READRIGHTS, WRITERIGHTS, PID, ACCESSLEVEL ) " + "VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )");
            this.updateFileInfoInArchiveObjectsSTM = this.db.getConnection().prepareStatement("UPDATE " + ARCHIVEOBJECTS + " SET SIZE = ?, FILETIME = ? WHERE NODEID = ?");
            this.updatePIDInArchiveObjectsSTM = this.db.getConnection().prepareStatement("UPDATE " + ARCHIVEOBJECTS + " SET PID = ? WHERE NODEID = ?");
            this.selectPIDForArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT PID FROM " + ARCHIVEOBJECTS + " WHERE NODEID = ?");
            this.moveObjectInArchiveObjectsSTM = this.db.getConnection().prepareStatement("UPDATE " + ARCHIVEOBJECTS + " SET URL = ? WHERE NODEID = ?");
            this.updateAccessInfoInArchiveObjectsSTM = this.db.getConnection().prepareStatement("UPDATE " + ARCHIVEOBJECTS + " SET READRIGHTS = ?, WRITERIGHTS = ?, ACCESSLEVEL = ? " + " WHERE NODEID = ? AND ((READRIGHTS <> ?) OR (WRITERIGHTS <> ?) OR (ACCESSLEVEL IS NULL OR ACCESSLEVEL <> ?))");
            this.updateCrawlTimeInArchiveObjectsSTM = this.db.getConnection().prepareStatement("UPDATE " + ARCHIVEOBJECTS + " SET CRAWLTIME = ? WHERE NODEID = ?");
            this.updateChecksumInArchiveObjectsSTM = this.db.getConnection().prepareStatement("UPDATE " + ARCHIVEOBJECTS + " SET CHECKSUM = ? WHERE NODEID = ?");
            this.deleteObjectInArchiveObjectsSTM = this.db.getConnection().prepareStatement("DELETE FROM " + ARCHIVEOBJECTS + " WHERE NODEID = ?");
            try {
                this.getIdFromOldArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT NODEID FROM ARCHIVEOBJECTS WHERE URL = ?");
            }
            catch (SQLException sqle) {}
        }
        catch (SQLException sqle) {
            logger.error((Object)("initPreparedStatements: SQL error: " + sqle), (Throwable)sqle);
            this.status = false;
        }
    }

    protected synchronized void closePreparedStatements() {
        super.closePreparedStatements();
        try {
            if (this.newObjectInArchiveObjectsSTM != null) {
                this.newObjectInArchiveObjectsSTM.close();
            }
            if (this.newObjectWithIdInArchiveObjectsSTM != null) {
                this.newObjectWithIdInArchiveObjectsSTM.close();
            }
            if (this.updateFileInfoInArchiveObjectsSTM != null) {
                this.updateFileInfoInArchiveObjectsSTM.close();
            }
            if (this.updatePIDInArchiveObjectsSTM != null) {
                this.updatePIDInArchiveObjectsSTM.close();
            }
            if (this.selectPIDForArchiveObjectsSTM != null) {
                this.selectPIDForArchiveObjectsSTM.close();
            }
            if (this.moveObjectInArchiveObjectsSTM != null) {
                this.moveObjectInArchiveObjectsSTM.close();
            }
            if (this.updateAccessInfoInArchiveObjectsSTM != null) {
                this.updateAccessInfoInArchiveObjectsSTM.close();
            }
            if (this.updateCrawlTimeInArchiveObjectsSTM != null) {
                this.updateCrawlTimeInArchiveObjectsSTM.close();
            }
            if (this.updateChecksumInArchiveObjectsSTM != null) {
                this.updateChecksumInArchiveObjectsSTM.close();
            }
            if (this.deleteObjectInArchiveObjectsSTM != null) {
                this.deleteObjectInArchiveObjectsSTM.close();
            }
            if (this.getIdFromOldArchiveObjectsSTM != null) {
                this.getIdFromOldArchiveObjectsSTM.close();
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)("closePreparedStatements: SQL error: " + sqle), (Throwable)sqle);
        }
        this.updateFileInfoInArchiveObjectsSTM = null;
        this.moveObjectInArchiveObjectsSTM = null;
        this.updateAccessInfoInArchiveObjectsSTM = null;
        this.updatePIDInArchiveObjectsSTM = null;
        this.selectPIDForArchiveObjectsSTM = null;
        this.updateCrawlTimeInArchiveObjectsSTM = null;
        this.updateChecksumInArchiveObjectsSTM = null;
        this.deleteObjectInArchiveObjectsSTM = null;
        this.getIdFromOldArchiveObjectsSTM = null;
    }

    private synchronized void setTmpTableNames() {
        if (ARCHIVEOBJECTS.startsWith("TMP")) {
            logger.error((Object)"Duplicate setTmpTableNames call!");
            System.exit(0);
        }
        ARCHIVEOBJECTS = "TMP" + ARCHIVEOBJECTS;
        CORPUSNODES = "TMP" + CORPUSNODES;
        CORPUSSTRUCTURE = "TMP" + CORPUSSTRUCTURE;
        tables = new String[]{ARCHIVEOBJECTS, CORPUSNODES, CORPUSSTRUCTURE, "accessgroups"};
    }

    private synchronized void unsetTmpTableNames() {
        if (!ARCHIVEOBJECTS.startsWith("TMP")) {
            logger.error((Object)"Duplicate unsetTmpTableNames call!");
            System.exit(0);
        }
        ARCHIVEOBJECTS = ARCHIVEOBJECTS.substring(3);
        CORPUSNODES = CORPUSNODES.substring(3);
        CORPUSSTRUCTURE = CORPUSSTRUCTURE.substring(3);
        tables = new String[]{ARCHIVEOBJECTS, CORPUSNODES, CORPUSSTRUCTURE, "accessgroups"};
        logger.info((Object)"unsetTmpTableNames: Re-preparing all prepared statements");
        this.closePreparedStatements();
        this.initPreparedStatements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean createTables() {
        Statement statement;
        block22: {
            if (!this.statusLog("createTables")) {
                return false;
            }
            long lastIssuedNodeIdInExistingTable = -1L;
            if (useExistingNodeIds && (lastIssuedNodeIdInExistingTable = this.getLastIssuedNodeIdInExistingTable()) == -1L) {
                useExistingNodeIds = false;
                logger.error((Object)"createTables: could not determine highest existing node id, disabled useExistingNodeIds again");
            }
            long startNodeId = lastIssuedNodeIdInExistingTable + 1L;
            String[] tableCreateCmd = new String[tables.length];
            String primaryKey = "";
            if (this.db.dbType == 2) {
                primaryKey = " PRIMARY KEY";
            }
            if (this.db.dbType == 1) {
                primaryKey = "";
                tableCreateCmd[0] = "CREATE " + this.db.tableType + " TABLE " + ARCHIVEOBJECTS + " ( " + "NODEID INTEGER DEFAULT NEXTVAL('" + "NODEID_SEQ" + "')" + primaryKey + ", ";
            } else {
                tableCreateCmd[0] = "CREATE " + this.db.tableType + " TABLE " + ARCHIVEOBJECTS + "( " + "NODEID INTEGER GENERATED BY DEFAULT AS " + "IDENTITY (START WITH " + startNodeId + ")" + primaryKey + ", ";
            }
            tableCreateCmd[0] = tableCreateCmd[0] + "URL VARCHAR NOT NULL, CRAWLTIME TIMESTAMP NOT NULL, ONSITE " + this.db.boolType + " DEFAULT TRUE, " + "SIZE BIGINT, " + "CHECKSUM VARCHAR, " + "FILETIME TIMESTAMP, " + "READRIGHTS VARCHAR NOT NULL, " + "WRITERIGHTS VARCHAR NOT NULL, " + "PID VARCHAR, " + "ACCESSLEVEL INTEGER) ";
            tableCreateCmd[1] = "CREATE " + this.db.tableType + " TABLE " + CORPUSNODES + "( " + "NODEID INTEGER" + primaryKey + ", " + "NODETYPE INTEGER NOT NULL, " + "FORMAT VARCHAR , " + "NAME VARCHAR , " + "TITLE VARCHAR " + " )";
            tableCreateCmd[2] = "CREATE " + this.db.tableType + " TABLE " + CORPUSSTRUCTURE + "( " + "NODEID INTEGER NOT NULL, " + "CANONICAL " + this.db.boolType + " DEFAULT FALSE, " + "VALID " + this.db.boolType + " DEFAULT TRUE, ";
            for (int i = 0; i < 3; ++i) {
                tableCreateCmd[2] = tableCreateCmd[2] + "VPATH" + i + " INTEGER DEFAULT NULL, ";
            }
            tableCreateCmd[2] = tableCreateCmd[2] + "VPATH VARCHAR )";
            tableCreateCmd[3] = "CREATE " + this.db.tableType + " TABLE " + "accessgroups" + "( " + "MD5 VARCHAR NOT NULL PRIMARY KEY, ACLSTRING VARCHAR NOT NULL )";
            statement = null;
            statement = this.db.getConnection().createStatement();
            if (this.db.dbType == 1 && !useExistingNodeIds) {
                try {
                    statement.execute("CREATE SEQUENCE NODEID_SEQ MINVALUE 0 START " + startNodeId);
                    logger.info((Object)("createTables: created new sequenceNODEID_SEQ, start value: " + startNodeId));
                }
                catch (SQLException sqle) {
                    logger.warn((Object)("createTables: tried to create new sequence but failed, error: " + sqle));
                }
            }
            for (int i = 0; i < tables.length; ++i) {
                try {
                    logger.debug((Object)("## createTables: Executing" + i + ": " + tableCreateCmd[i]));
                    statement.execute(tableCreateCmd[i]);
                    statement.execute("GRANT SELECT ON " + tables[i] + " TO PUBLIC");
                    logger.debug((Object)("createTables: Created table: " + tables[i]));
                    continue;
                }
                catch (SQLException sqle) {
                    logger.error((Object)("createTables: Error creating table: " + tables[i] + " error: " + sqle));
                    this.status = false;
                }
            }
            statement.execute("INSERT INTO accessgroups (MD5, ACLSTRING) VALUES ('nobody', 'nobody' )");
            statement.execute("INSERT INTO accessgroups (MD5, ACLSTRING) VALUES ('cleared', 'cleared' )");
            statement.execute("INSERT INTO accessgroups (MD5, ACLSTRING) VALUES ('everybody', 'everybody' )");
            statement.execute("INSERT INTO accessgroups (MD5, ACLSTRING) VALUES ('anyAuthenticatedUser', 'anyAuthenticatedUser' )");
            logger.debug((Object)"createTables: stored identity mapping for AccessInfo constants in accessgroups");
            Object var11_12 = null;
            if (statement == null) break block22;
            try {
                statement.close();
                break block22;
            }
            catch (SQLException sqle2) {
                // empty catch block
            }
            {
                break block22;
                catch (SQLException sqle) {
                    logger.error((Object)("createTables: unexpected SQL error: " + sqle), (Throwable)sqle);
                    this.status = false;
                    boolean bl = false;
                    Object var11_13 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sqle2) {
                            // empty catch block
                        }
                    }
                    statement = null;
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                }
                statement = null;
                throw throwable;
            }
        }
        statement = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean dropOldTables() {
        Statement statement;
        block16: {
            if (!this.statusLog("dropOldTables")) {
                return false;
            }
            HashSet tableNames = this.getTableNames();
            statement = null;
            statement = this.db.getConnection().createStatement();
            for (int i = tables.length - 1; i >= 0; --i) {
                String name = tables[i];
                if (name.startsWith("TMP")) {
                    name = name.substring(3);
                }
                if (tableNames != null && tableNames.contains(name) && !name.equals("accessgroups")) {
                    try {
                        statement.execute("DROP TABLE " + name);
                        logger.debug((Object)("dropOldTables: dropped table: " + name));
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)("dropOldTables: Error dropping table: " + name + ", SQL exception: " + sqle));
                    }
                    continue;
                }
                if (name.equals("accessgroups")) continue;
                logger.warn((Object)("dropOldTables: table not dropped as it did not exist anyway: " + name));
            }
            Object var7_8 = null;
            if (statement == null) break block16;
            try {
                statement.close();
                break block16;
            }
            catch (SQLException sqle2) {
                // empty catch block
            }
            {
                break block16;
                catch (SQLException sqle) {
                    logger.error((Object)("dropOldTables: unexpected SQL exception: " + sqle), (Throwable)sqle);
                    this.status = false;
                    boolean bl = false;
                    Object var7_9 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sqle2) {
                            // empty catch block
                        }
                    }
                    statement = null;
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                }
                statement = null;
                throw throwable;
            }
        }
        statement = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void copyOldArchiveObjects() {
        block16: {
            String command;
            Statement statement;
            block15: {
                block14: {
                    if (!this.statusLog("copyOldArchiveObjects")) {
                        return;
                    }
                    HashSet tableNames = this.getTableNames();
                    statement = null;
                    command = "INSERT INTO TMPARCHIVEOBJECTS ( nodeid, url, crawltime, onsite, size, checksum, filetime, readrights, writerights ) SELECT nodeid, url, crawltime, onsite, size, checksum, filetime, readrights, writerights FROM ARCHIVEOBJECTS WHERE NOT nodeid IN ( SELECT nodeid FROM TMPARCHIVEOBJECTS )";
                    int updatedRows = 0;
                    statement = this.db.getConnection().createStatement();
                    if (tableNames != null && tableNames.contains("ARCHIVEOBJECTS")) {
                        logger.info((Object)"copyOldArchiveObjects: will copy data from archiveobjects to tmparchiveobjects");
                        updatedRows = statement.executeUpdate(command);
                        if (updatedRows == 0) {
                            logger.info((Object)"copyOldArchiveObjects: Old archiveobjects table did not contain any information about objects other than those touched in the current crawler run!");
                        } else {
                            logger.info((Object)("copyOldArchiveObjects: preserved data about " + updatedRows + " objects from old archiveobjects table (current crawler run did not touch those)."));
                        }
                        break block14;
                    }
                    logger.info((Object)"No previous version of ARCHIVEOBJECTS table found, cannot copy data about old objects!");
                }
                Object var7_5 = null;
                if (statement == null) break block15;
                try {
                    statement.close();
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
            }
            statement = null;
            {
                break block16;
                catch (SQLException sqle) {
                    logger.error((Object)("copyOldArchiveObjects: SQL exception: " + sqle + " command: " + command));
                    this.status = false;
                    Object var7_6 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sqle2) {
                            // empty catch block
                        }
                    }
                    statement = null;
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                }
                statement = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void deleteArchiveObjectsTable(int key) {
        block18: {
            Statement statement;
            block17: {
                if (!this.statusLog("deleteArchiveObjectsTable")) {
                    return;
                }
                if (key != 42) {
                    return;
                }
                statement = null;
                statement = this.db.getConnection().createStatement();
                try {
                    statement.execute("DROP TABLE " + ARCHIVEOBJECTS);
                    logger.info((Object)("deleteArchiveObjectsTable: dropped table: " + ARCHIVEOBJECTS));
                }
                catch (SQLException sqle) {
                    logger.error((Object)("deleteArchiveObjectsTable: could not drop table " + ARCHIVEOBJECTS + " error: " + sqle));
                }
                if (this.db.dbType == 1) {
                    try {
                        statement.execute("DROP SEQUENCE NODEID_SEQ");
                        logger.info((Object)"deleteArchiveObjectsTable: dropped sequence: NODEID_SEQ");
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)("deleteArchiveObjectsTable: could not drop sequence NODEID_SEQ error: " + sqle));
                    }
                }
                Object var5_6 = null;
                if (statement == null) break block17;
                try {
                    statement.close();
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
            }
            statement = null;
            {
                break block18;
                catch (SQLException sqle) {
                    logger.error((Object)("deleteArchiveObjectsTable: unexpected SQL error: " + sqle), (Throwable)sqle);
                    this.status = false;
                    Object var5_7 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sqle2) {
                            // empty catch block
                        }
                    }
                    statement = null;
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                }
                statement = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void dropTmpTables() {
        Statement statement;
        block16: {
            if (!this.statusLog("dropTmpTables")) {
                return;
            }
            HashSet tableNames = this.getTableNames();
            statement = null;
            statement = this.db.getConnection().createStatement();
            logger.info((Object)"dropTmpTables: dropping tmp tables");
            for (int i = tables.length - 1; i >= 0; --i) {
                String name = tables[i];
                if (!name.startsWith("TMP")) {
                    name = "TMP" + name;
                }
                if (tableNames != null && tableNames.contains(name) && !name.equals("accessgroups")) {
                    try {
                        statement.execute("DROP TABLE " + name);
                        logger.debug((Object)("dropTmpTables: old tmp table dropped: " + name));
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)("dropTmpTables: error dropping table: " + name + " SQL error: " + sqle));
                    }
                    continue;
                }
                if (name.equals("accessgroups")) continue;
                logger.debug((Object)("dropTmpTables: table did not exist: " + name));
            }
            Object var7_7 = null;
            if (statement == null) break block16;
            try {
                statement.close();
                break block16;
            }
            catch (SQLException sqle2) {
                // empty catch block
            }
            {
                break block16;
                catch (SQLException sqle) {
                    logger.error((Object)("dropTmpTables: unexpected SQL error: " + sqle), (Throwable)sqle);
                    this.status = false;
                    Object var7_8 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sqle2) {
                            // empty catch block
                        }
                    }
                    statement = null;
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                }
                statement = null;
                throw throwable;
            }
        }
        statement = null;
    }

    private void createIndexes(boolean temp) {
        Statement statement = null;
        logger.info((Object)("createIndexes: " + (temp ? "temp" : "final")));
        try {
            statement = this.db.getConnection().createStatement();
            if (this.db.dbType == 1) {
                if (temp) {
                    statement.execute("CREATE UNIQUE INDEX BOOTSTRAP_NODEID_AO_IDX ON " + ARCHIVEOBJECTS + " ( NODEID )");
                    statement.execute("CREATE UNIQUE INDEX BOOTSTRAP_NODEID_CN_IDX ON " + CORPUSNODES + " ( NODEID )");
                } else {
                    statement.execute("ALTER TABLE " + ARCHIVEOBJECTS + " ADD CONSTRAINT " + "PK_" + ARCHIVEOBJECTS + " PRIMARY KEY (NODEID)");
                    statement.execute("ALTER TABLE " + CORPUSNODES + " ADD CONSTRAINT " + "PK_" + CORPUSNODES + " PRIMARY KEY (NODEID)");
                }
            }
            statement.execute("CREATE UNIQUE INDEX " + (temp ? "BOOTSTRAP_" : "") + "URL_AO_IDX ON " + ARCHIVEOBJECTS + " ( URL )");
            statement.execute("CREATE INDEX " + (temp ? "BOOTSTRAP_" : "") + "PID_AO_IDX ON " + ARCHIVEOBJECTS + " ( PID )");
            if (!temp) {
                statement.execute("CREATE INDEX CRAWLTIME_AO_IDX ON " + ARCHIVEOBJECTS + " ( CRAWLTIME )");
                statement.execute("CREATE INDEX FILETIME_AO_IDX ON " + ARCHIVEOBJECTS + " ( FILETIME )");
                statement.execute("CREATE INDEX CHECKSUM_AO_IDX ON " + ARCHIVEOBJECTS + " ( CHECKSUM )");
                statement.execute("CREATE INDEX READRIGHTS_AO_IDX ON " + ARCHIVEOBJECTS + " ( READRIGHTS )");
            }
            statement.execute("CREATE INDEX " + (temp ? "BOOTSTRAP_" : "") + "NODEID_CS_IDX ON " + CORPUSSTRUCTURE + " ( NODEID )");
            statement.execute("CREATE INDEX " + (temp ? "BOOTSTRAP_" : "") + "VPATH_CS_IDX ON " + CORPUSSTRUCTURE + " ( VPATH )");
            if (this.db.dbType == 1) {
                statement.execute("CREATE INDEX " + (temp ? "BOOTSTRAP_" : "") + "VPATH_CS_IDX_LIKE ON " + CORPUSSTRUCTURE + " ( VPATH varchar_pattern_ops )");
            }
            for (int i = 0; i < 3; ++i) {
                if (temp) continue;
                statement.execute("CREATE INDEX VPATH" + i + "_CS_IDX ON " + CORPUSSTRUCTURE + " ( VPATH" + i + " )");
            }
            if (!temp) {
                statement.execute("CREATE INDEX NODETYPE_CN_IDX ON " + CORPUSNODES + " ( NODETYPE )");
                statement.execute("CREATE INDEX FORMAT_CN_IDX ON " + CORPUSNODES + " ( FORMAT )");
            }
            if (this.db.dbType == 1 && !temp) {
                statement.execute("VACUUM ANALYZE " + CORPUSNODES);
                statement.execute("VACUUM ANALYZE " + CORPUSSTRUCTURE);
                statement.execute("VACUUM ANALYZE " + ARCHIVEOBJECTS);
                this.closePreparedStatements();
                this.initPreparedStatements();
            }
            logger.info((Object)"createIndexes: done");
        }
        catch (SQLException sqle) {
            logger.error((Object)("createIndexes: Unexpected Error creating indexes: " + sqle), (Throwable)sqle);
            this.status = false;
        }
        catch (Exception e) {
            logger.error((Object)("createIndexes: Unexpected Error creating indexes: " + e), (Throwable)e);
            this.status = false;
        }
    }

    private void renameTmpTables() {
        Statement statement = null;
        String name = "";
        try {
            statement = this.db.getConnection().createStatement();
            logger.info((Object)"renameTmpTables: dropping temp indexes");
            try {
                statement.execute("DROP INDEX BOOTSTRAP_NODEID_AO_IDX");
                statement.execute("DROP INDEX BOOTSTRAP_NODEID_CN_IDX");
                statement.execute("DROP INDEX BOOTSTRAP_URL_AO_IDX");
                statement.execute("DROP INDEX BOOTSTRAP_NODEID_CS_IDX");
                statement.execute("DROP INDEX BOOTSTRAP_VPATH_CS_IDX");
                statement.execute("DROP INDEX BOOTSTRAP_VPATH_CS_IDX_LIKE");
                statement.execute("DROP INDEX BOOTSTRAP_PID_AO_IDX");
            }
            catch (SQLException sqle) {
                logger.error((Object)("renameTmpTables: SQL error dropping temp index: " + sqle));
            }
            logger.info((Object)"renameTmpTables: renaming tables");
            for (int i = 0; i < tables.length; ++i) {
                try {
                    name = tables[i];
                    if (name.equals("accessgroups")) continue;
                    statement.execute("ALTER TABLE " + name + " RENAME TO " + name.substring(3));
                    logger.debug((Object)("renameTmpTables:renamed table " + name + " to " + name.substring(3)));
                    continue;
                }
                catch (SQLException sqle) {
                    logger.error((Object)("renameTmpTables:Error renaming table " + name + " SQL error: " + sqle));
                }
            }
            logger.info((Object)"renameTmpTables: renamed tables");
        }
        catch (SQLException sqle) {
            logger.error((Object)("renameTmpTables: Unexpected Error renaming tables and indexes: " + sqle));
        }
        catch (Exception e) {
            logger.error((Object)("renameTmpTables: Unexpected Error dropping tables and indexes: " + e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private HashSet getTableNames() {
        Object tableType;
        DatabaseMetaData md2222;
        ResultSet rs;
        block10: {
            rs = null;
            HashSet<String> results = new HashSet<String>();
            md2222 = this.db.getConnection().getMetaData();
            rs = md2222.getTables(null, null, null, null);
            while (rs.next()) {
                String name;
                tableType = rs.getString("TABLE_TYPE");
                if (!"TABLE".equals(tableType) || (name = rs.getString("TABLE_NAME")) == null) continue;
                results.add(name.toUpperCase());
            }
            tableType = results;
            Object var7_9 = null;
            if (rs == null) break block10;
            try {
                rs.close();
            }
            catch (SQLException sqle2) {
                // empty catch block
            }
        }
        md2222 = null;
        rs = null;
        return tableType;
        catch (SQLException sqle) {
            block11: {
                try {
                    logger.error((Object)("getTableNames: SQL exception: " + sqle), (Throwable)sqle);
                    Object var7_10 = null;
                    if (rs == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sqle2) {
                            // empty catch block
                        }
                    }
                    Object md2222 = null;
                    rs = null;
                    throw throwable;
                }
                try {
                    rs.close();
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
            }
            Object md2222 = null;
            rs = null;
            {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void freeUpdateInProgressLock() {
        block15: {
            Statement stat;
            block14: {
                block13: {
                    stat = null;
                    int n = 0;
                    if (this.db == null || !this.db.getStatus()) {
                        logger.info((Object)"freeUpdateInProgressLock: db already closed correctly");
                        return;
                    }
                    stat = this.db.getConnection().createStatement();
                    try {
                        n = stat.executeUpdate("UPDATE IMDIADMIN SET VALUE = 'FALSE' WHERE NAME = 'UPDATEINPROGRESS'");
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)("freeUpdateInProgressLock: SQLException: " + sqle));
                    }
                    if (n == 1) break block13;
                    logger.error((Object)"freeUpdateInProgressLock: ERROR freeing lock, record not found");
                }
                Object var5_5 = null;
                if (stat == null) break block14;
                try {
                    stat.close();
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
            }
            stat = null;
            {
                break block15;
                catch (SQLException sqle) {
                    logger.error((Object)("freeUpdateInProgressLock: unexpected error: " + sqle), (Throwable)sqle);
                    this.status = false;
                    Object var5_6 = null;
                    if (stat != null) {
                        try {
                            stat.close();
                        }
                        catch (SQLException sqle2) {
                            // empty catch block
                        }
                    }
                    stat = null;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (stat != null) {
                    try {
                        stat.close();
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                }
                stat = null;
                throw throwable;
            }
        }
    }

    private void resetSequencePosition() {
        logger.debug((Object)"resetSequencePosition: Scanning archiveobjects for highest node id...");
        long nextIndex = this.getLastIssuedNodeIdInExistingTable() + 1L;
        if (nextIndex <= 1L) {
            logger.error((Object)("resetSequencePosition: NOT setting position to " + nextIndex + " (too small)"));
            return;
        }
        Statement statement = null;
        try {
            statement = this.db.getConnection().createStatement();
            if (this.db.dbType == 1) {
                statement.execute("ALTER SEQUENCE NODEID_SEQ RESTART WITH " + nextIndex);
            } else {
                statement.execute("ALTER TABLE " + ARCHIVEOBJECTS + " ALTER COLUMN NODEID RESTART WITH " + nextIndex);
            }
            logger.debug((Object)("resetSequencePosition: Reset position to: " + nextIndex));
        }
        catch (SQLException sqle) {
            logger.error((Object)("resetSequencePosition: Unexpected Error setting position to" + nextIndex + ": " + sqle));
        }
        catch (Exception e) {
            logger.error((Object)("resetSequencePosition: Unexpected Error setting position to " + nextIndex + ": " + e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishUpdate() {
        if (!this.statusLog("finishUpdate")) {
            return;
        }
        logger.debug((Object)"finishUpdate called");
        String string = staticSyncFlag;
        synchronized (string) {
            if (!bootstrapMode) {
                logger.info((Object)"finishUpdate is only needed to leave bootstrap mode");
                return;
            }
            try {
                ArchiveAccessContext aac = (ArchiveAccessContext)rootsHash.get(dbname);
                logger.info((Object)"finishUpdate: dropping old DB objects");
                this.copyOldArchiveObjects();
                this.dropOldTables();
                logger.info((Object)"finishUpdate: renaming tables");
                this.renameTmpTables();
                this.unsetTmpTableNames();
                logger.info((Object)"finishUpdate: calling createIndexes - this may take a while");
                this.createIndexes(false);
                this.resetSequencePosition();
                logger.info((Object)"finishUpdate: storing setup parameters in imdiadmin table");
                int context = 1;
                String propName = ArchiveAccessContext.aRootsPropertyNames[context];
                this.insertAdminKey(propName, aac.getRoot(context));
                context = 2;
                propName = ArchiveAccessContext.aRootsPropertyNames[context];
                this.insertAdminKey(propName, aac.getRoot(context));
                context = 3;
                propName = ArchiveAccessContext.aRootsPropertyNames[context];
                this.insertAdminKey(propName, aac.getRoot(context));
                context = 4;
                propName = ArchiveAccessContext.aRootsPropertyNames[context];
                this.insertAdminKey(propName, aac.getRoot(context));
                context = 5;
                propName = ArchiveAccessContext.aRootsPropertyNames[context];
                this.insertAdminKey(propName, aac.getRoot(context));
                context = 6;
                propName = ArchiveAccessContext.aRootsPropertyNames[context];
                this.insertAdminKey(propName, aac.getRoot(context));
                Object var6_5 = null;
                bootstrapMode = false;
                this.freeUpdateInProgressLock();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                bootstrapMode = false;
                this.freeUpdateInProgressLock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void shutdown() {
        logger.info((Object)"shutdown called");
        if (this.db == null) {
            logger.info((Object)"DB already closed");
            return;
        }
        String string = staticSyncFlag;
        synchronized (string) {
            block18: {
                if (this.db.dbType == 2) {
                    Statement statement;
                    block17: {
                        logger.debug((Object)("CorpusStructureDBWriteImpl instance " + instance + " shutdown"));
                        statement = null;
                        statement = this.db.getConnection().createStatement();
                        statement.execute("SHUTDOWN COMPACT");
                        Object var5_3 = null;
                        if (statement == null) break block17;
                        try {
                            statement.close();
                        }
                        catch (SQLException sqle2) {
                            // empty catch block
                        }
                    }
                    statement = null;
                    {
                        break block18;
                        catch (SQLException sqle) {
                            if (sqle.toString().indexOf("is shutdown") != -1) {
                                logger.info((Object)"database already shutdown");
                            } else {
                                logger.error((Object)("shutdown: SQLException: " + sqle), (Throwable)sqle);
                            }
                            Object var5_4 = null;
                            if (statement != null) {
                                try {
                                    statement.close();
                                }
                                catch (SQLException sqle2) {
                                    // empty catch block
                                }
                            }
                            statement = null;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sqle2) {
                                // empty catch block
                            }
                        }
                        statement = null;
                        throw throwable;
                    }
                }
            }
        }
        this.close();
    }

    public void setSearchServletURL(String str) {
        this.insertAdminKey("MDSearchServletURL", str);
    }

    public boolean canWrite() {
        return this.statusLog("canWrite");
    }

    public String newArchiveObject(String name, URI uri, Timestamp crawltime, boolean onsite, long size, Timestamp filetime, AccessInfo ainfo, String checksum) throws UpdateInProgressException {
        return this.newArchiveObject(name, uri, null, crawltime, onsite, size, filetime, ainfo, checksum);
    }

    /*
     * Exception decompiling
     */
    public String newArchiveObject(String name, URI uri, String pid, Timestamp crawltime, boolean onsite, long size, Timestamp filetime, AccessInfo ainfo, String checksum) throws UpdateInProgressException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String newArchiveObject(URI uri, Timestamp crawltime, boolean onsite, long size, Timestamp filetime, AccessInfo ainfo) throws UpdateInProgressException {
        return this.newArchiveObject(uri, null, crawltime, onsite, size, filetime, ainfo);
    }

    public String newArchiveObject(URI uri, String pid, Timestamp crawltime, boolean onsite, long size, Timestamp filetime, AccessInfo ainfo) throws UpdateInProgressException {
        String checksum = null;
        return this.newArchiveObject(null, uri, pid, crawltime, onsite, size, filetime, ainfo, checksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteArchiveObject(String id) throws UpdateInProgressException {
        if (!this.statusLog("deleteArchiveObject")) {
            return false;
        }
        if (bootstrapMode) {
            logger.error((Object)"deleteArchiveObject: NOT ALLOWED IN BOOTSTRAP MODE");
            System.exit(0);
        }
        this.checkWriteAccess();
        if (!NodeIdUtils.isNodeId(id)) {
            logger.error((Object)("deleteArchiveObject: invalid NodeId: " + id));
            return false;
        }
        try {
            int n = 0;
            PreparedStatement preparedStatement = this.deleteObjectInArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.deleteObjectInArchiveObjectsSTM.clearParameters();
                this.deleteObjectInArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(id));
                n = this.deleteObjectInArchiveObjectsSTM.executeUpdate();
            }
            if (n > 0) {
                logger.debug((Object)("deleteArchiveObject: Deleted from main DB: " + id));
            }
            if (n == 0) {
                this.throwUnknownObjectException("deleteArchiveObject", "", id);
            }
            return true;
        }
        catch (SQLException sqle) {
            logger.error((Object)"deleteArchiveObject: ", (Throwable)sqle);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setArchiveObjectFileInfo(String nodeId, long filesize, Timestamp filetime) throws UpdateInProgressException {
        if (!this.statusLog("setArchiveObjectFileInfo")) {
            return;
        }
        if (bootstrapMode) {
            logger.error((Object)"setArchiveObjectFileInfo: NOT ALLOWED IN BOOTSTRAP MODE");
            System.exit(0);
        }
        this.checkWriteAccess();
        if (!NodeIdUtils.isNodeId(nodeId)) {
            logger.error((Object)("setArchiveObjectFileInfo: invalid NodeId: " + nodeId));
            return;
        }
        try {
            int n = 0;
            PreparedStatement preparedStatement = this.updateFileInfoInArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.updateFileInfoInArchiveObjectsSTM.clearParameters();
                this.updateFileInfoInArchiveObjectsSTM.setLong(1, filesize);
                this.updateFileInfoInArchiveObjectsSTM.setTimestamp(2, filetime);
                this.updateFileInfoInArchiveObjectsSTM.setInt(3, NodeIdUtils.TOINT(nodeId));
                n = this.updateFileInfoInArchiveObjectsSTM.executeUpdate();
            }
            if (n == 0) {
                logger.warn((Object)("setArchiveObjectFileInfo: nothing updated: " + nodeId));
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)("setArchiveObjectFileInfo: SQLException: " + sqle), (Throwable)sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean setArchiveObjectPid(String nodeId, String pid) throws UpdateInProgressException {
        boolean result;
        block25: {
            ResultSet rs;
            block24: {
                logger.debug((Object)("setArchiveObjectPid: NodeId: " + nodeId + ",PID=" + pid));
                result = false;
                if (!this.statusLog("setArchiveObjectPid")) {
                    return result;
                }
                this.checkWriteAccess();
                if (!NodeIdUtils.isNodeId(nodeId)) {
                    logger.error((Object)("setArchiveObjectPid: invalid NodeId: " + nodeId));
                    return result;
                }
                rs = null;
                String pidFromAoDb = null;
                boolean hasPIDAlready = true;
                PreparedStatement preparedStatement = this.selectPIDForArchiveObjectsSTM;
                synchronized (preparedStatement) {
                    this.selectPIDForArchiveObjectsSTM.clearParameters();
                    this.selectPIDForArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(nodeId));
                    rs = this.selectPIDForArchiveObjectsSTM.executeQuery();
                    if (rs != null) {
                        hasPIDAlready = rs.next() ? (pidFromAoDb = rs.getString("PID")) != null && pidFromAoDb.length() > 0 : false;
                        rs.close();
                    } else {
                        hasPIDAlready = false;
                    }
                }
                if (!hasPIDAlready) {
                    String formattedPid = NodeIdUtils.formatPIDForStorage(pid, this.getArchiveRoots().getHandlePrefix());
                    PreparedStatement preparedStatement2 = this.updatePIDInArchiveObjectsSTM;
                    synchronized (preparedStatement2) {
                        this.updatePIDInArchiveObjectsSTM.clearParameters();
                        this.updatePIDInArchiveObjectsSTM.setString(1, formattedPid);
                        this.updatePIDInArchiveObjectsSTM.setInt(2, NodeIdUtils.TOINT(nodeId));
                        if (this.updatePIDInArchiveObjectsSTM.executeUpdate() == 0) {
                            logger.warn((Object)("setArchiveObjectPid: nothing updated: " + nodeId));
                        } else {
                            result = true;
                        }
                        break block24;
                    }
                }
                if (NodeIdUtils.arePIDsEqual(pid, pidFromAoDb)) break block24;
                logger.warn((Object)("setArchiveObjectPid: nothing updated. The archiveobject with nodeid=" + nodeId + " already has a PID[" + pidFromAoDb + "]. Update with PID[" + pid + "] rejected."));
            }
            Object var11_12 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                break block25;
            }
            catch (SQLException e) {}
            break block25;
            {
                catch (SQLException sqle) {
                    logger.error((Object)("setArchiveObjectPid: SQLException: " + sqle), (Throwable)sqle);
                    Object var11_13 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        break block25;
                    }
                    catch (SQLException e) {}
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjectCrawlTime(String id, Timestamp whence) throws UpdateInProgressException {
        if (!this.statusLog("updateObjectTimestamp")) {
            return;
        }
        if (bootstrapMode) {
            logger.error((Object)"updateObjectAccessInfo: NOT ALLOWED IN BOOTSTRAP MODE");
            System.exit(0);
        }
        this.checkWriteAccess();
        if (!NodeIdUtils.isNodeId(id)) {
            logger.warn((Object)("setObjectCrawlTime: invalid NodeId: " + id));
            this.throwUnknownObjectException("setObjectCrawlTime", "", id);
        }
        try {
            int n = 0;
            PreparedStatement preparedStatement = this.updateCrawlTimeInArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.updateCrawlTimeInArchiveObjectsSTM.clearParameters();
                this.updateCrawlTimeInArchiveObjectsSTM.setTimestamp(1, whence);
                this.updateCrawlTimeInArchiveObjectsSTM.setInt(2, NodeIdUtils.TOINT(id));
                n = this.updateCrawlTimeInArchiveObjectsSTM.executeUpdate();
            }
            if (n == 0) {
                this.throwUnknownObjectException("updateObjectTimestamp", "", id);
            }
            return;
        }
        catch (SQLException sqle) {
            logger.error((Object)("updateObjectTimestamp: SQL exception: " + sqle), (Throwable)sqle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveArchiveObject(String id, URI newUri) throws UpdateInProgressException {
        String urlstr;
        if (!this.statusLog("moveArchiveObject")) {
            return false;
        }
        if (bootstrapMode) {
            logger.error((Object)"moveArchiveObject: NOT ALLOWED IN BOOTSTRAP MODE");
            System.exit(0);
        }
        this.checkWriteAccess();
        if (!NodeIdUtils.isNodeId(id)) {
            logger.warn((Object)("moveArchiveObject: invalid NodeId: " + id));
            this.throwUnknownObjectException("moveArchiveObject", "", id);
        }
        if ((urlstr = newUri.toString()).indexOf("///") != -1) {
            urlstr = urlstr.replaceFirst("///", "/");
        }
        urlstr = urlstr.replace("%20", " ");
        if (useExistingNodeIds) {
            ArchiveAccessContext aac = (ArchiveAccessContext)rootsHash.get(dbname);
            String oldId = null;
            try {
                oldId = this.getOldObjectId(aac.stringToURI(urlstr), 3);
            }
            catch (URISyntaxException use) {
                logger.warn((Object)("moveArchiveObject: invalid URI: " + urlstr));
                return false;
            }
            if (id.equals(oldId)) {
                logger.info((Object)("moveArchiveObject: zero distance move of " + id + " at: " + urlstr));
                return true;
            }
            if (oldId != null) {
                logger.warn((Object)("moveArchiveObject: COLLISION tried to change URI for " + id + " to URI of " + oldId));
                return false;
            }
        }
        try {
            int n = 0;
            PreparedStatement preparedStatement = this.moveObjectInArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.moveObjectInArchiveObjectsSTM.clearParameters();
                this.moveObjectInArchiveObjectsSTM.setString(1, urlstr);
                this.moveObjectInArchiveObjectsSTM.setInt(2, NodeIdUtils.TOINT(id));
                n = this.moveObjectInArchiveObjectsSTM.executeUpdate();
            }
            if (n == 0) {
                this.throwUnknownObjectException("moveArchiveObject", "", id);
            }
            return true;
        }
        catch (SQLException sqle) {
            logger.error((Object)("moveArchiveObject: SQL exception: " + sqle), (Throwable)sqle);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjectAccessInfo(String id, AccessInfo ainfo) throws UpdateInProgressException {
        if (!this.statusLog("setObjectAccessInfo")) {
            return;
        }
        if (bootstrapMode) {
            logger.error((Object)"setObjectAccessInfo: NOT ALLOWED IN BOOTSTRAP MODE");
            System.exit(0);
        }
        this.checkWriteAccess();
        if (!NodeIdUtils.isNodeId(id)) {
            logger.warn((Object)("setObjectAccessInfo: invalid NodeId: " + id));
            this.throwUnknownObjectException("setObjectAccessInfo", "", id);
        }
        if (ainfo.getOwner() != null) {
            logger.warn((Object)("setObjectAccessInfo: Owner ignored for " + id + ": " + ainfo.getOwner()));
        }
        if (ainfo.getCreator() != null) {
            logger.warn((Object)("setObjectAccessInfo: Creator ignored for " + id + ": " + ainfo.getCreator()));
        }
        String readEnc = this.encodeRights(ainfo.getReadRights());
        String writeEnc = this.encodeRights(ainfo.getWriteRights());
        int accessLevel = ainfo.getAccessLevel();
        try {
            int n = 0;
            PreparedStatement preparedStatement = this.updateAccessInfoInArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.updateAccessInfoInArchiveObjectsSTM.clearParameters();
                this.updateAccessInfoInArchiveObjectsSTM.setString(1, readEnc);
                this.updateAccessInfoInArchiveObjectsSTM.setString(2, writeEnc);
                this.updateAccessInfoInArchiveObjectsSTM.setInt(3, accessLevel);
                this.updateAccessInfoInArchiveObjectsSTM.setInt(4, NodeIdUtils.TOINT(id));
                this.updateAccessInfoInArchiveObjectsSTM.setString(5, readEnc);
                this.updateAccessInfoInArchiveObjectsSTM.setString(6, writeEnc);
                this.updateAccessInfoInArchiveObjectsSTM.setInt(7, accessLevel);
                n = this.updateAccessInfoInArchiveObjectsSTM.executeUpdate();
            }
            return;
        }
        catch (SQLException sqle) {
            logger.error((Object)("setObjectAccessInfo: SQL exception: " + sqle), (Throwable)sqle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjectChecksum(String id, String checksum) throws UpdateInProgressException {
        if (!this.statusLog("setObjectChecksum")) {
            return;
        }
        if (bootstrapMode) {
            logger.error((Object)"setObjectChecksum: NOT ALLOWED IN BOOTSTRAP MODE");
            System.exit(0);
        }
        this.checkWriteAccess();
        if (!NodeIdUtils.isNodeId(id)) {
            logger.warn((Object)("setObjectChecksum: invalid NodeId: " + id));
            this.throwUnknownObjectException("setObjectChecksum", "", id);
        }
        try {
            int n = 0;
            PreparedStatement preparedStatement = this.updateChecksumInArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.updateChecksumInArchiveObjectsSTM.clearParameters();
                this.updateChecksumInArchiveObjectsSTM.setString(1, checksum);
                this.updateChecksumInArchiveObjectsSTM.setInt(2, NodeIdUtils.TOINT(id));
                n = this.updateChecksumInArchiveObjectsSTM.executeUpdate();
            }
            if (n == 0) {
                this.throwUnknownObjectException("setObjectChecksum", "", id);
            }
            return;
        }
        catch (SQLException sqle) {
            logger.error((Object)("setObjectChecksum: SQL exception: " + sqle), (Throwable)sqle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private long getLastIssuedNodeIdInExistingTable() throws UpdateInProgressException {
        SQLException sqle2222;
        long l;
        ResultSet rs;
        Statement statement;
        block24: {
            block21: {
                SQLException sqle2222;
                long l2;
                block22: {
                    if (!this.statusLog("getLastIssuedNodeIdInExistingTable")) {
                        return -1L;
                    }
                    this.checkWriteAccess();
                    statement = null;
                    rs = null;
                    String cmd = "SELECT MAX(NODEID) FROM ARCHIVEOBJECTS";
                    statement = this.db.getConnection().createStatement();
                    rs = statement.executeQuery(cmd);
                    if (!rs.next()) break block21;
                    logger.debug((Object)("### getLastIssuedNodeIdInExistingTable: ->" + rs.getLong(1)));
                    l2 = rs.getLong(1);
                    Object var7_7 = null;
                    if (statement == null) break block22;
                    try {
                        statement.close();
                    }
                    catch (SQLException sqle2222) {
                        // empty catch block
                    }
                }
                statement = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sqle2222) {
                        // empty catch block
                    }
                }
                rs = null;
                return l2;
            }
            l = -1L;
            Object var7_8 = null;
            if (statement == null) break block24;
            try {
                statement.close();
            }
            catch (SQLException sqle2222) {
                // empty catch block
            }
        }
        statement = null;
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sqle2222) {
                // empty catch block
            }
        }
        rs = null;
        return l;
        catch (SQLException sqle3) {
            SQLException sqle2222;
            block26: {
                try {
                    logger.warn((Object)("getLastIssuedNodeIdInExistingTable: could not get last issued nodeid: " + sqle3));
                    Object var7_9 = null;
                    if (statement == null) break block26;
                }
                catch (Throwable throwable) {
                    SQLException sqle2222;
                    Object var7_10 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sqle2222) {
                            // empty catch block
                        }
                    }
                    statement = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sqle2222) {
                            // empty catch block
                        }
                    }
                    rs = null;
                    throw throwable;
                }
                try {
                    statement.close();
                }
                catch (SQLException sqle2222) {
                    // empty catch block
                }
            }
            statement = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle2222) {
                    // empty catch block
                }
            }
            rs = null;
            {
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String getOldObjectId(URI uri, int context) {
        block21: {
            block20: {
                if (!this.statusLog("getOldObjectId")) {
                    return null;
                }
                aac = (ArchiveAccessContext)ArchiveObjectsDBWriteImpl.rootsHash.get(ArchiveObjectsDBWriteImpl.dbname);
                if (uri == null || !uri.isAbsolute()) {
                    ArchiveObjectsDBWriteImpl.logger.error((Object)("getOldObjectId: must be absolute URI: " + uri));
                    return null;
                }
                if ((uri = aac.uriToTableContext(uri, context)) == null) {
                    ArchiveObjectsDBWriteImpl.logger.error((Object)("getOldObjectId: urlToTableContext error, context: " + context));
                    return null;
                }
                rs = null;
                var5_5 = this.getIdFromOldArchiveObjectsSTM;
                synchronized (var5_5) {
                    this.getIdFromOldArchiveObjectsSTM.clearParameters();
                    this.getIdFromOldArchiveObjectsSTM.setString(1, uri.toString());
                    rs = this.getIdFromOldArchiveObjectsSTM.executeQuery();
                    if (!rs.next()) ** break block19
                    id = NodeIdUtils.TONODEID(rs.getInt("NODEID"));
                    if (!rs.isLast()) {
                        ArchiveObjectsDBWriteImpl.logger.error((Object)("getOldObjectId: ERROR more than one id for URI: " + uri));
                    }
                    var7_8 = id;
                }
                var10_9 = null;
                if (rs == null) break block20;
                try {
                    rs.close();
                }
                catch (SQLException sqle) {
                    // empty catch block
                }
            }
            rs = null;
            return var7_8;
            {
                // MONITOREXIT @DISABLED, blocks:[2, 3, 6] lbl36 : MonitorExitStatement: MONITOREXIT : var5_5
                {
                    catch (Throwable var8_17) {
                        throw var8_17;
                    }
                }
                var5_5 = null;
                var10_10 = null;
                if (rs == null) break block21;
            }
            try {
                rs.close();
            }
            catch (SQLException sqle) {
                // empty catch block
            }
        }
        rs = null;
        return var5_5;
        {
            catch (SQLException sqle) {
                block22: {
                    try {
                        ArchiveObjectsDBWriteImpl.logger.error((Object)("getoldObjectId: SQL exception: " + sqle), (Throwable)sqle);
                        var10_11 = null;
                        if (rs == null) break block22;
                    }
                    catch (Throwable var9_18) {
                        var10_12 = null;
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException sqle) {
                                // empty catch block
                            }
                        }
                        rs = null;
                        throw var9_18;
                    }
                    try {
                        rs.close();
                    }
                    catch (SQLException sqle) {
                        // empty catch block
                    }
                }
                rs = null;
                {
                }
            }
            return null;
        }
    }

    protected void throwUnknownNodeException(String method, String message, String nodeId) throws UnknownNodeException {
        throw new UnknownNodeException("" + method + ": no node with nodeId " + nodeId + ", " + message);
    }

    protected void throwUnknownObjectException(String method, String message, String id) throws UnknownNodeException {
        throw new UnknownNodeException("" + method + ": no object with Id " + id + ", " + message);
    }

    protected boolean statusLog(String method) {
        return super.statusLog("[Write]." + method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String encodeRights(String rights) {
        String md5;
        block19: {
            PreparedStatement ps;
            block18: {
                if ("everybody".equals(rights)) {
                    return rights;
                }
                if ("nobody".equals(rights)) {
                    return rights;
                }
                if ("cleared".equals(rights)) {
                    return rights;
                }
                if ("anyAuthenticatedUser".equals(rights)) {
                    return rights;
                }
                if (rights == null || !rights.startsWith(" ")) {
                    throw new IllegalArgumentException("encodeRights: Only lists and everybody, nobody, cleared or all_auth supported, not: " + rights);
                }
                md5 = Checksum.checksumString((String)rights);
                if (this.knownGroups.contains(md5)) {
                    return md5;
                }
                ps = null;
                ps = this.db.getConnection().prepareStatement("INSERT INTO accessgroups ( MD5, ACLSTRING ) SELECT ? AS MD5, ? AS ACLSTRING WHERE ? NOT IN (SELECT MD5 FROM accessgroups)");
                ps.clearParameters();
                ps.setString(1, md5);
                ps.setString(2, rights);
                ps.setString(3, md5);
                int n = ps.executeUpdate();
                if (n > 0) {
                    logger.info((Object)("encodeRights: Stored " + md5 + " for " + rights));
                } else {
                    logger.debug((Object)("encodeRights: Confirmed " + md5 + " for " + rights));
                }
                this.knownGroups.add(md5);
                Object var6_6 = null;
                if (ps == null) break block18;
                try {
                    ps.close();
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
            }
            ps = null;
            {
                break block19;
                catch (SQLException sqle) {
                    logger.error((Object)("encodeRights: SQLException: " + sqle), (Throwable)sqle);
                    Object var6_7 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException sqle2) {
                            // empty catch block
                        }
                    }
                    ps = null;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                }
                ps = null;
                throw throwable;
            }
        }
        return md5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void insertAdminKey(String name, String value) {
        block11: {
            PreparedStatement ps;
            block10: {
                ps = null;
                ps = this.db.getConnection().prepareStatement("INSERT INTO IMDIADMIN ( Name, Value )  VALUES ( ?, ? )");
                ps.clearParameters();
                ps.setString(1, name);
                ps.setString(2, value);
                ps.executeUpdate();
                Object var6_4 = null;
                if (ps == null) break block10;
                try {
                    ps.close();
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
            }
            ps = null;
            {
                break block11;
                catch (SQLException sqle) {
                    logger.error((Object)("insertAdminKey: SQLException: " + sqle), (Throwable)sqle);
                    Object var6_5 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException sqle2) {
                            // empty catch block
                        }
                    }
                    ps = null;
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                }
                ps = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean checkUpdateInProgressLock(boolean claim) {
        block34: {
            block40: {
                block35: {
                    block39: {
                        block33: {
                            block38: {
                                block32: {
                                    block30: {
                                        block31: {
                                            stat = null;
                                            try {
                                                try {
                                                    block41: {
                                                        stat = this.db.getConnection().createStatement();
                                                        if (!claim) break block41;
                                                        try {
                                                            n = stat.executeUpdate("UPDATE IMDIADMIN SET VALUE = 'TRUE' WHERE NAME = 'UPDATEINPROGRESS' AND VALUE ='FALSE'");
                                                            if (n == 1) {
                                                                var4_7 = false;
                                                            }
                                                            ** GOTO lbl-1000
                                                        }
                                                        catch (SQLException sqle) {
                                                            ArchiveObjectsDBWriteImpl.logger.error((Object)("checkUpdateInProgressLock: SQLException, but probably caused by recreating DB " + sqle));
                                                            var4_9 = false;
                                                            var7_15 = null;
                                                            if (stat != null) {
                                                                try {
                                                                    stat.close();
                                                                }
                                                                catch (SQLException sqle) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                            stat = null;
                                                            return var4_9;
                                                        }
                                                        var7_12 = null;
                                                        if (stat == null) break block30;
                                                        break block31;
lbl-1000:
                                                        // 1 sources

                                                        {
                                                            uIP = super.getMultiAdminKey("UPDATEINPROGRESS", false);
                                                            if (uIP == null) ** GOTO lbl-1000
                                                            if (!uIP.equals("TRUE")) {
                                                                ArchiveObjectsDBWriteImpl.logger.error((Object)"checkUpdateInProgressLock: ERROR failed to set lock");
                                                            }
                                                            var5_28 = true;
                                                        }
                                                        break block32;
lbl-1000:
                                                        // 1 sources

                                                        {
                                                            stat.execute("INSERT INTO IMDIADMIN( NAME, VALUE ) VALUES('UPDATEINPROGRESS', 'TRUE')");
                                                            var5_29 = false;
                                                        }
                                                        break block33;
                                                    }
                                                    uIP = super.getMultiAdminKey("UPDATEINPROGRESS", false);
                                                    if (uIP == null) break block34;
                                                    var4_10 = uIP.equals("TRUE");
                                                    break block35;
                                                }
                                                catch (SQLException sqle) {
                                                    block36: {
                                                        ArchiveObjectsDBWriteImpl.logger.error((Object)("checkUpdateInProgressLock: SQLException but probably caused by recreating DB " + sqle));
                                                        var4_11 = false;
                                                        var7_18 = null;
                                                        if (stat != null) {
                                                            ** try [egrp 5[TRYBLOCK] [16 : 226->235)] { 
lbl54:
                                                            // 1 sources

                                                            stat.close();
                                                            break block36;
lbl56:
                                                            // 1 sources

                                                            catch (SQLException sqle) {
                                                                // empty catch block
                                                            }
                                                        }
                                                    }
                                                    stat = null;
                                                    return var4_11;
                                                }
                                            }
                                            catch (Throwable var6_30) {
                                                block37: {
                                                    var7_19 = null;
                                                    if (stat != null) {
                                                        ** try [egrp 5[TRYBLOCK] [16 : 226->235)] { 
lbl66:
                                                        // 1 sources

                                                        stat.close();
                                                        break block37;
lbl68:
                                                        // 1 sources

                                                        catch (SQLException sqle) {
                                                            // empty catch block
                                                        }
                                                    }
                                                }
                                                stat = null;
                                                throw var6_30;
                                            }
                                        }
                                        ** try [egrp 5[TRYBLOCK] [16 : 226->235)] { 
lbl75:
                                        // 1 sources

                                        stat.close();
                                        break block30;
lbl77:
                                        // 1 sources

                                        catch (SQLException sqle) {
                                            // empty catch block
                                        }
                                    }
                                    stat = null;
                                    return var4_7;
                                }
                                var7_13 = null;
                                if (stat != null) {
                                    ** try [egrp 5[TRYBLOCK] [16 : 226->235)] { 
lbl86:
                                    // 1 sources

                                    stat.close();
                                    break block38;
lbl88:
                                    // 1 sources

                                    catch (SQLException sqle) {
                                        // empty catch block
                                    }
                                }
                            }
                            stat = null;
                            return var5_28;
                        }
                        var7_14 = null;
                        if (stat != null) {
                            ** try [egrp 5[TRYBLOCK] [16 : 226->235)] { 
lbl97:
                            // 1 sources

                            stat.close();
                            break block39;
lbl99:
                            // 1 sources

                            catch (SQLException sqle) {
                                // empty catch block
                            }
                        }
                    }
                    stat = null;
                    return var5_29;
                }
                var7_16 = null;
                if (stat != null) {
                    ** try [egrp 5[TRYBLOCK] [16 : 226->235)] { 
lbl108:
                    // 1 sources

                    stat.close();
                    break block40;
lbl110:
                    // 1 sources

                    catch (SQLException sqle) {
                        // empty catch block
                    }
                }
            }
            stat = null;
            return var4_10;
        }
        var7_17 = null;
        if (stat == null) return false;
        ** try [egrp 5[TRYBLOCK] [16 : 226->235)] { 
lbl119:
        // 1 sources

        stat.close();
        return false;
lbl121:
        // 1 sources

        catch (SQLException sqle) {
            // empty catch block
        }
        return false;
    }

    public void close() {
        super.close();
    }

    protected void checkWriteAccess() throws UpdateInProgressException {
        if (this.updateInProgress && !this.iAmTheUpdater) {
            throw new UpdateInProgressException("Database updating, only read access allowed");
        }
    }
}

