/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.imdi.api;

import nl.mpi.imdi.api.IMDIXMLFormat;

public class IMDIElement {
    private String spec = null;
    private String attributeName = null;
    private String domId = null;
    private String value = "";

    public IMDIElement(String spec, String domId) {
        this(spec);
        this.setDomId(domId);
    }

    public IMDIElement(String spec) {
        this.setSpec(spec);
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public boolean isAttribute() {
        return this.attributeName != null;
    }

    public String getSpec() {
        return this.spec;
    }

    public void setSpec(String spec) {
        this.attributeName = IMDIXMLFormat.whichAttribute(spec);
        this.spec = spec;
    }

    public String getDomId() {
        return this.domId;
    }

    public void setDomId(String domId) {
        if (this.domId != null) {
            System.err.println("IMDIElement: setDomId: ERROR trying to change existing domid");
            Exception e = new Exception("TRYING TO CHANGE EXISTING DOMID");
            e.printStackTrace();
        } else {
            this.domId = domId;
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return "IMDIElement[" + this.domId + (this.isAttribute() ? "@" + this.getAttributeName() : "") + ", " + this.spec + "]";
    }
}

