/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nl.mpi.arbil.data.ArbilVocabularyItem;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocumentationLanguages {
    private final String selectedLanguagesKey;
    private final SessionStorage sessionStorage;

    public DocumentationLanguages(String selectedLanguagesKey, SessionStorage sessionStorage) {
        this.selectedLanguagesKey = selectedLanguagesKey;
        this.sessionStorage = sessionStorage;
    }

    protected List<String> addDefaultLanguages() {
        List<ArbilVocabularyItem> imdiLanguages = this.getAllLanguages();
        ArrayList<String> selectedLanguages = this.getSelectedLanguages();
        if (selectedLanguages == null) {
            selectedLanguages = new ArrayList(imdiLanguages.size());
        }
        for (ArbilVocabularyItem currentTemplate : imdiLanguages) {
            selectedLanguages.add(currentTemplate.itemDisplayName);
        }
        this.saveSelectedLanguages(selectedLanguages);
        return this.getSelectedLanguages();
    }

    public synchronized void addselectedLanguage(String templateString) {
        List<String> selectedLanguages = this.getSelectedLanguages();
        if (selectedLanguages == null) {
            selectedLanguages = Collections.singletonList(templateString);
        } else {
            selectedLanguages.add(templateString);
        }
        this.saveSelectedLanguages(selectedLanguages);
    }

    public abstract List<ArbilVocabularyItem> getAllLanguages();

    protected synchronized List<ArbilVocabularyItem> getLanguageListSubset(List<ArbilVocabularyItem> allLanguages) {
        ArrayList<ArbilVocabularyItem> languageListSubset = new ArrayList<ArbilVocabularyItem>();
        if (allLanguages != null) {
            List<String> selectedLanguages = this.getSelectedLanguagesArrayList();
            for (ArbilVocabularyItem currentVocabItem : allLanguages) {
                if (!selectedLanguages.contains(currentVocabItem.itemDisplayName)) continue;
                languageListSubset.add(currentVocabItem);
            }
        }
        return languageListSubset;
    }

    public abstract List<ArbilVocabularyItem> getSortedLanguageListSubset();

    protected ArrayList<String> getSelectedLanguages() {
        ArrayList<String> selectedLanguages = new ArrayList<String>();
        try {
            selectedLanguages.addAll(Arrays.asList(this.sessionStorage.loadStringArray(this.selectedLanguagesKey)));
        }
        catch (Exception e) {
            BugCatcherManager.getBugCatcher().logError("No selectedLanguages file, will create one now.", e);
            return null;
        }
        return selectedLanguages;
    }

    public synchronized List<String> getSelectedLanguagesArrayList() {
        ArrayList<String> selectedLanguages = new ArrayList<String>();
        try {
            selectedLanguages.addAll(Arrays.asList(this.sessionStorage.loadStringArray(this.selectedLanguagesKey)));
            return selectedLanguages;
        }
        catch (Exception e) {
            BugCatcherManager.getBugCatcher().logError("No selectedLanguages file, will create one now.", e);
            return this.addDefaultLanguages();
        }
    }

    public synchronized void removeselectedLanguages(String templateString) {
        ArrayList<String> selectedLanguages = new ArrayList<String>();
        try {
            selectedLanguages.addAll(Arrays.asList(this.sessionStorage.loadStringArray(this.selectedLanguagesKey)));
            while (selectedLanguages.contains(templateString)) {
                selectedLanguages.remove(templateString);
            }
        }
        catch (IOException ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
        this.saveSelectedLanguages(selectedLanguages);
    }

    protected void saveSelectedLanguages(List<String> selectedLanguages) {
        try {
            this.sessionStorage.saveStringArray(this.selectedLanguagesKey, selectedLanguages.toArray(new String[0]));
        }
        catch (IOException ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }
}

