/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.favourites;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.mpi.arbil.clarin.CmdiComponentLinkReader;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.metadatafile.MetadataReader;
import nl.mpi.arbil.favourites.FavouritesService;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.TreeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArbilFavourites
implements FavouritesService {
    private static final Logger logger = LoggerFactory.getLogger(ArbilFavourites.class);
    private static MessageDialogHandler messageDialogHandler;
    private static SessionStorage sessionStorage;
    private static TreeHelper treeHelper;
    private static ArbilFavourites singleInstance;

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static void setTreeHelper(TreeHelper treeHelperInstance) {
        treeHelper = treeHelperInstance;
    }

    public static synchronized ArbilFavourites getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new ArbilFavourites();
        }
        return singleInstance;
    }

    public void convertOldFormatLocationListsX() {
        try {
            File oldLocationsFile = new File(sessionStorage.getProjectDirectory(), "locationsList");
            File oldFavouritesFile = new File(sessionStorage.getProjectDirectory(), "selectedFavourites");
            if (oldLocationsFile.exists()) {
                Vector locationsList = (Vector)sessionStorage.loadObject("locationsList");
                if (oldFavouritesFile.exists()) {
                    Vector userFavouritesStrings = (Vector)sessionStorage.loadObject("selectedFavourites");
                    locationsList.addAll(userFavouritesStrings);
                    sessionStorage.saveStringArray("locationsList", locationsList.toArray(new String[0]));
                    oldFavouritesFile.deleteOnExit();
                }
                if (null == sessionStorage.loadStringArray("locationsList")) {
                    sessionStorage.saveStringArray("locationsList", locationsList.toArray(new String[0]));
                }
            }
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    public boolean toggleFavouritesList(ArbilDataNode[] dataNodeArray, boolean setAsTempate) {
        logger.debug("toggleFavouriteList: {}", (Object)setAsTempate);
        if (setAsTempate) {
            boolean selectionNeedsSave = false;
            for (ArbilDataNode currentNode : dataNodeArray) {
                if (!currentNode.getNeedsSaveToDisk(false)) continue;
                selectionNeedsSave = true;
            }
            if (selectionNeedsSave) {
                messageDialogHandler.addMessageDialogToQueue("Changes must be saved before adding to the favourites.", "Add Favourites");
                return false;
            }
        }
        for (ArbilDataNode currentNode : dataNodeArray) {
            if (setAsTempate && currentNode.isContainerNode()) {
                if (currentNode.getChildArray().length <= 0) continue;
                this.toggleFavouritesList(currentNode.getChildArray(), true);
                continue;
            }
            if (setAsTempate) {
                this.addAsFavourite(currentNode.getURI());
                continue;
            }
            this.removeFromFavourites(currentNode.getURI());
        }
        return true;
    }

    public void addAsFavourite(URI imdiUri) {
        try {
            URI baseUri = new URI(imdiUri.toString().split("#")[0]);
            String fileSuffix = imdiUri.getPath().substring(imdiUri.getPath().lastIndexOf("."));
            File destinationFile = File.createTempFile("fav-", fileSuffix, sessionStorage.getFavouritesDir());
            ArbilDataNode.getMetadataUtils(baseUri.toString()).copyMetadataFile(baseUri, destinationFile, this.makeLinksAbsolute(imdiUri), true);
            URI copiedFileURI = destinationFile.toURI();
            String uriString = copiedFileURI.toString().split("#")[0];
            if (imdiUri.getFragment() != null) {
                uriString = uriString + "#" + imdiUri.getFragment();
            }
            URI favouriteUri = new URI(uriString);
            treeHelper.addLocation(favouriteUri);
            treeHelper.applyRootLocations();
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    private URI[][] makeLinksAbsolute(URI imdiUri) {
        ArrayList<URI[]> relativeLinks = null;
        if (ArbilDataNode.isPathCmdi(imdiUri.toString())) {
            relativeLinks = new ArrayList<URI[]>();
            ArrayList<CmdiComponentLinkReader.CmdiResourceLink> resourceLinks = new CmdiComponentLinkReader().readLinks(imdiUri);
            for (CmdiComponentLinkReader.CmdiResourceLink link : resourceLinks) {
                try {
                    URI linkUri = link.getLinkUri();
                    if (linkUri.isAbsolute()) continue;
                    relativeLinks.add(new URI[]{linkUri, link.getResolvedLinkUri()});
                }
                catch (URISyntaxException ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        }
        if (relativeLinks != null) {
            return (URI[][])relativeLinks.toArray((T[])new URI[0][]);
        }
        return null;
    }

    private void removeFromFavourites(URI imdiUri) {
        treeHelper.removeLocation(imdiUri);
        treeHelper.applyRootLocations();
    }

    public ArbilDataNode[] listFavouritesFor(Object targetNodeUserObject) {
        logger.debug("listFavouritesFor: {}", targetNodeUserObject);
        ArrayList<ArbilDataNode> validFavourites = new ArrayList<ArbilDataNode>();
        if (targetNodeUserObject instanceof ArbilNode) {
            boolean targetIsLocalCorpusRoot;
            ArbilDataNode targetDataNode = null;
            boolean targetIsDataNode = targetNodeUserObject instanceof ArbilDataNode;
            if (targetIsDataNode) {
                targetDataNode = (ArbilDataNode)targetNodeUserObject;
                targetIsLocalCorpusRoot = false;
            } else {
                targetIsLocalCorpusRoot = targetNodeUserObject == ((DefaultMutableTreeNode)treeHelper.getLocalCorpusTreeModel().getRoot()).getUserObject();
            }
            boolean targetIsCorpus = targetIsDataNode && targetDataNode.isCorpus();
            boolean targetIsSession = targetIsDataNode && targetDataNode.isSession();
            boolean targetIsChildNode = targetIsDataNode && targetDataNode.isChildNode();
            for (ArbilDataNode currentFavouritesObject : treeHelper.getFavouriteNodes()) {
                boolean addThisFavourites = false;
                if (targetIsLocalCorpusRoot) {
                    addThisFavourites = !currentFavouritesObject.isChildNode();
                } else if (targetIsCorpus && !currentFavouritesObject.isChildNode()) {
                    addThisFavourites = true;
                } else if (targetIsSession && currentFavouritesObject.isChildNode()) {
                    addThisFavourites = MetadataReader.getSingleInstance().nodeCanExistInNode(targetDataNode, currentFavouritesObject);
                } else if (targetIsChildNode && currentFavouritesObject.isChildNode()) {
                    addThisFavourites = MetadataReader.getSingleInstance().nodeCanExistInNode(targetDataNode, currentFavouritesObject);
                }
                if (!addThisFavourites) continue;
                validFavourites.add(currentFavouritesObject);
            }
        }
        return validFavourites.toArray(new ArbilDataNode[0]);
    }

    public String getNodeType(ArbilDataNode favouriteNode, ArbilDataNode targetDataNode) {
        String returnValue;
        String favouriteXmlPath = favouriteNode.getURI().getFragment();
        String targetXmlPath = targetDataNode.getURI().getFragment();
        logger.debug("getNodeType: \nfavouriteXmlPath: {} targetXmlPath: {}", (Object)favouriteXmlPath, (Object)targetXmlPath);
        if (favouriteNode.isSession()) {
            returnValue = ".METATRANSCRIPT.Session";
        } else if (favouriteNode.isCorpus()) {
            returnValue = ".METATRANSCRIPT.Corpus";
        } else if (favouriteNode.isChildNode()) {
            if (targetXmlPath == null) {
                returnValue = favouriteXmlPath.replaceAll("\\(\\d*?\\)$", "");
            } else {
                logger.debug("targetXmlPath: {}", (Object)targetXmlPath);
                logger.debug("favouriteXmlPath: {}", (Object)favouriteXmlPath);
                favouriteXmlPath = favouriteXmlPath.replaceAll("\\(\\d*?\\)$", "");
                String[] splitFavouriteXmlPath = favouriteXmlPath.split("\\)");
                String[] splitTargetXmlPath = targetXmlPath.split("\\)");
                logger.debug("splitFavouriteXmlPath: {} splitTargetXmlPath: {}", (Object)splitFavouriteXmlPath.length, (Object)splitTargetXmlPath.length);
                returnValue = "";
                for (int partCounter = 0; partCounter < splitFavouriteXmlPath.length; ++partCounter) {
                    returnValue = splitTargetXmlPath.length > partCounter ? returnValue.concat(splitTargetXmlPath[partCounter] + ")") : returnValue.concat(splitFavouriteXmlPath[partCounter] + ")");
                }
                returnValue = returnValue.replaceAll("\\)$", "");
                returnValue = returnValue.replaceAll("\\(\\d*?$", "");
            }
        } else {
            returnValue = null;
        }
        logger.debug("getNodeTypeReturnValue: {}", (Object)returnValue);
        return returnValue;
    }

    static {
        singleInstance = null;
    }
}

