/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.favourites;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import nl.mpi.arbil.favourites.FavouritesImportExportException;
import nl.mpi.arbil.favourites.FavouritesImporter;
import nl.mpi.arbil.favourites.FavouritesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FavouritesImporterImpl
implements FavouritesImporter {
    private static final Logger logger = LoggerFactory.getLogger(FavouritesImporterImpl.class);
    private final FavouritesService favouritesService;

    public FavouritesImporterImpl(FavouritesService favouritesService) {
        this.favouritesService = favouritesService;
    }

    @Override
    public void importFavourites(File importDirectory) throws FavouritesImportExportException {
        URI importFile = new File(importDirectory, "favourites.config").toURI();
        List<URI> locations = this.readFavouritesLocations(importFile);
        for (URI favouriteURI : locations) {
            this.favouritesService.addAsFavourite(importFile.resolve(favouriteURI));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<URI> readFavouritesLocations(URI location) throws FavouritesImportExportException {
        ArrayList<URI> arrayList;
        InputStream openStream = location.toURL().openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(openStream));
        try {
            String favouriteLocation;
            ArrayList<URI> favouriteLocations = new ArrayList<URI>();
            while ((favouriteLocation = reader.readLine()) != null) {
                if (this.lineIsComment(favouriteLocation)) continue;
                try {
                    URI favouriteURI = new URI(favouriteLocation);
                    favouriteLocations.add(favouriteURI);
                }
                catch (URISyntaxException ex) {
                    logger.warn("Skipping broken favourite URI {} while importing. Reason: ", (Object)favouriteLocation, (Object)ex);
                }
            }
            arrayList = favouriteLocations;
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (MalformedURLException ex) {
                throw new FavouritesImportExportException("Invalid import location: " + location, ex);
            }
            catch (IOException ex) {
                throw new FavouritesImportExportException("Error while trying to read favourites list", ex);
            }
        }
        reader.close();
        return arrayList;
    }

    private boolean lineIsComment(String favouritesLine) {
        return favouritesLine.startsWith("#");
    }
}

