/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import nl.mpi.arbil.ui.ArbilFieldViewTableModel;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.util.BugCatcherManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArbilFieldViewTable
extends JTable {
    private static final Logger logger = LoggerFactory.getLogger(ArbilFieldViewTable.class);

    public ArbilFieldViewTable(ArbilTableModel imdiTableModel) {
        ArbilFieldViewTableModel tableModel = new ArbilFieldViewTableModel(imdiTableModel);
        this.setModel(tableModel);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                logger.debug("mousePressed");
                this.checkPopup(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                logger.debug("mouseReleased");
                this.checkPopup(evt);
            }

            private void checkPopup(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    Point p = evt.getPoint();
                    int clickedColumn = ArbilFieldViewTable.this.columnAtPoint(p);
                    logger.debug("clickedColumn: {}", (Object)clickedColumn);
                    if (clickedColumn == 2 || clickedColumn == 3) {
                        JPopupMenu viewPopupMenu = new JPopupMenu();
                        viewPopupMenu.setName("viewPopupMenu");
                        JMenuItem selectedAllMenuItem = new JMenuItem();
                        selectedAllMenuItem.setText("Selected All");
                        viewPopupMenu.setInvoker(evt.getComponent());
                        selectedAllMenuItem.setActionCommand("" + clickedColumn);
                        selectedAllMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent evt) {
                                try {
                                    int targetColumn = Integer.parseInt(evt.getActionCommand());
                                    ArbilFieldViewTableModel fieldViewTableModel = (ArbilFieldViewTableModel)((JTable)((JPopupMenu)((JMenuItem)evt.getSource()).getComponent().getParent()).getInvoker()).getModel();
                                    logger.debug("targetColumn: {}:{}", (Object)targetColumn, (Object)evt.getActionCommand());
                                    for (int rowCounter = 0; rowCounter < fieldViewTableModel.getRowCount(); ++rowCounter) {
                                        fieldViewTableModel.setValueAt(true, rowCounter, targetColumn);
                                    }
                                }
                                catch (Exception ex) {
                                    BugCatcherManager.getBugCatcher().logError(ex);
                                }
                            }
                        });
                        viewPopupMenu.add(selectedAllMenuItem);
                        JMenuItem selectetNodeMenuItem = new JMenuItem();
                        selectetNodeMenuItem.setText("Selected None");
                        selectetNodeMenuItem.setActionCommand("" + clickedColumn);
                        selectetNodeMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent evt) {
                                try {
                                    int targetColumn = Integer.parseInt(evt.getActionCommand());
                                    ArbilFieldViewTableModel fieldViewTableModel = (ArbilFieldViewTableModel)((JTable)((JPopupMenu)((JMenuItem)evt.getSource()).getComponent().getParent()).getInvoker()).getModel();
                                    logger.debug("targetColumn: {}:{}", (Object)targetColumn, (Object)evt.getActionCommand());
                                    for (int rowCounter = 0; rowCounter < fieldViewTableModel.getRowCount(); ++rowCounter) {
                                        fieldViewTableModel.setValueAt(false, rowCounter, targetColumn);
                                    }
                                }
                                catch (Exception ex) {
                                    BugCatcherManager.getBugCatcher().logError(ex);
                                }
                            }
                        });
                        viewPopupMenu.add(selectetNodeMenuItem);
                        viewPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                    }
                }
            }
        });
    }

    public String getToolTipText(MouseEvent e) {
        Point p = e.getPoint();
        switch (this.columnAtPoint(p)) {
            case 2: {
                return "Show only checked fields (hides all others and overrides hide fields)";
            }
            case 3: {
                return "Hide checked fields (only active when no 'show only' selection is made)";
            }
        }
        return null;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer tableCellRenderer = super.getCellRenderer(row, column);
        if (tableCellRenderer instanceof JCheckBox) {
            ((JCheckBox)((Object)tableCellRenderer)).setEnabled(this.getModel().isCellEditable(row, column));
        }
        return tableCellRenderer;
    }
}

