/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellEditor;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilTableCell;
import nl.mpi.arbil.ui.ArbilFieldPlaceHolder;
import nl.mpi.arbil.ui.ArbilIconCellPanel;
import nl.mpi.arbil.ui.ArbilIconCellRenderer;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilTableCellRenderer;
import nl.mpi.arbil.ui.ArbilTableController;
import nl.mpi.arbil.ui.fieldeditors.ArbilFieldEditor;
import nl.mpi.arbil.ui.fieldeditors.ArbilLongFieldEditor;
import nl.mpi.arbil.ui.fieldeditors.ControlledVocabularyComboBox;
import nl.mpi.arbil.ui.fieldeditors.ControlledVocabularyComboBoxEditor;
import nl.mpi.arbil.ui.fieldeditors.LanguageIdBox;
import nl.mpi.arbil.util.BugCatcherManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArbilTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final Logger logger = LoggerFactory.getLogger(ArbilTableCellEditor.class);
    public static final int APPEND_TO_FIELD_ACTION_KEY = 113;
    private final ArbilTableController tableController;
    private final JPanel editorPanel;
    private final ArbilTableCellRenderer arbilTableCellRenderer;
    private final JLabel button;
    ArbilTable parentTable = null;
    Rectangle parentCellRect = null;
    ArbilDataNode registeredOwner = null;
    String fieldName;
    Component editorComponent = null;
    Object[] cellValue;
    int selectedField = -1;
    Vector<Component> componentsWithFocusListners = new Vector();
    private final MouseListener fieldMouseAdapter = new MouseAdapter(){

        public void mouseReleased(MouseEvent evt) {
            ArbilTableCellEditor.this.tableController.checkPopup(evt, false);
        }

        public void mousePressed(MouseEvent evt) {
            ArbilTableCellEditor.this.tableController.checkPopup(evt, false);
        }

        public void mouseClicked(MouseEvent evt) {
            if (evt.getButton() == 1) {
                ArbilTableCellEditor.this.startEditorMode(ArbilTableCellEditor.this.isStartLongFieldModifier(evt), 65535, '\uffff');
            } else {
                ArbilTableCellEditor.this.tableController.checkPopup(evt, false);
            }
        }
    };

    public ArbilTableCellEditor(ArbilTableController tableController) {
        this.tableController = tableController;
        this.arbilTableCellRenderer = new ArbilTableCellRenderer();
        this.button = new JLabel("...");
        this.editorPanel = new JPanel();
        this.button.getActionMap().put("appendToEditor", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ArbilTableCellEditor.this.startEditorMode(false, 65535, '\uffff');
            }
        });
        this.button.getInputMap(2).put(KeyStroke.getKeyStroke(85, 128), "appendToEditor");
        this.button.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent evt) {
            }

            public void keyPressed(KeyEvent evt) {
            }

            public void keyReleased(KeyEvent evt) {
                if (!ArbilTableCellEditor.this.cellHasControlledVocabulary() && ArbilTableCellEditor.this.isStartLongFieldKey(evt)) {
                    ArbilTableCellEditor.this.startEditorMode(true, 65535, '\uffff');
                } else if (!(evt.isActionKey() || evt.isMetaDown() || evt.isAltDown() || evt.isAltGraphDown() || evt.isControlDown() || evt.getKeyCode() == 16 || evt.getKeyCode() == 17 || evt.getKeyCode() == 18 || evt.getKeyCode() == 157 || evt.getKeyCode() == 27)) {
                    ArbilTableCellEditor.this.startEditorMode(false, evt.getKeyCode(), evt.getKeyChar());
                } else if (evt.isControlDown() && evt.getKeyCode() == 85 || evt.getKeyCode() == 113) {
                    ArbilTableCellEditor.this.startEditorMode(false, evt.getKeyCode(), evt.getKeyChar());
                }
            }
        });
        this.button.addMouseListener(this.fieldMouseAdapter);
    }

    private void initControlledVocabularyEditor(int lastKeyInt, char lastKeyChar) {
        this.editorPanel.remove(this.button);
        ControlledVocabularyComboBox cvComboBox = new ControlledVocabularyComboBox((ArbilField)this.cellValue[this.selectedField]);
        this.editorPanel.add(cvComboBox);
        this.editorPanel.doLayout();
        cvComboBox.setPopupVisible(true);
        this.editorComponent = cvComboBox;
        String currentCellString = this.cellValue[this.selectedField].toString();
        String initialValue = this.getEditorText(lastKeyInt, lastKeyChar, currentCellString);
        ControlledVocabularyComboBoxEditor cvcbEditor = new ControlledVocabularyComboBoxEditor(initialValue, currentCellString, (ArbilField)this.cellValue[this.selectedField], (JComboBox)cvComboBox);
        cvComboBox.setEditor(cvcbEditor);
        cvComboBox.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ArbilTableCellEditor.this.fireEditingStopped();
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                ArbilTableCellEditor.this.fireEditingStopped();
            }
        });
        this.addFocusListener(cvComboBox);
        this.addFocusListener(cvComboBox.getEditor().getEditorComponent());
        cvComboBox.getEditor().getEditorComponent().requestFocusInWindow();
    }

    private void initFieldEditor(int lastKeyInt, char lastKeyChar) {
        this.editorPanel.remove(this.button);
        this.editorPanel.setLayout(new BoxLayout(this.editorPanel, 0));
        String currentCellString = this.cellValue[this.selectedField].toString();
        ArbilFieldEditor editorTextField = new ArbilFieldEditor(this.getEditorText(lastKeyInt, lastKeyChar, currentCellString));
        editorTextField.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent evt) {
                if (ArbilTableCellEditor.this.isStartLongFieldKey(evt) && ArbilTableCellEditor.this.cellValue instanceof ArbilField[]) {
                    int currentFieldIndex = ArbilTableCellEditor.this.selectedField;
                    if (currentFieldIndex < 0) {
                        currentFieldIndex = 0;
                    }
                    new ArbilLongFieldEditor(ArbilTableCellEditor.this.parentTable).showEditor((ArbilField[])ArbilTableCellEditor.this.cellValue, ArbilTableCellEditor.this.getEditorText(65535, '\uffff', ((ArbilField)ArbilTableCellEditor.this.cellValue[currentFieldIndex]).getFieldValue()), currentFieldIndex);
                }
            }

            public void keyPressed(KeyEvent evt) {
            }

            public void keyReleased(KeyEvent evt) {
            }
        });
        this.editorPanel.setBorder(null);
        this.editorPanel.add(editorTextField);
        this.addFocusListener(editorTextField);
        if (this.cellValue[this.selectedField] instanceof ArbilField && ((ArbilField)this.cellValue[this.selectedField]).isAllowsLanguageId()) {
            LanguageIdBox fieldLanguageBox = new LanguageIdBox((ArbilField)this.cellValue[this.selectedField], this.parentCellRect);
            fieldLanguageBox.init();
            this.editorPanel.add(fieldLanguageBox);
            this.addFocusListener(fieldLanguageBox);
        }
        this.editorPanel.doLayout();
        editorTextField.requestFocusInWindow();
        this.editorComponent = editorTextField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requiresLongFieldEditor() {
        Graphics g;
        boolean requiresLongFieldEditor = false;
        if (this.cellValue instanceof ArbilField[] && (g = this.button.getGraphics()) != null) {
            try {
                FontMetrics fontMetrics = g.getFontMetrics();
                double availableWidth = this.parentCellRect.getWidth() + 20.0;
                ArbilField[] iterableFields = this.selectedField == -1 ? (ArbilField[])this.cellValue : new ArbilField[]{((ArbilField[])this.cellValue)[this.selectedField]};
                for (ArbilField currentField : iterableFields) {
                    String fieldValue = currentField.getFieldValue();
                    if (fieldValue.contains("\n")) {
                        requiresLongFieldEditor = true;
                    } else {
                        int requiredWidth = fontMetrics.stringWidth(fieldValue);
                        if (currentField.isAllowsLanguageId()) {
                            requiredWidth += 100;
                        }
                        if (!((double)requiredWidth > availableWidth)) continue;
                        requiresLongFieldEditor = true;
                    }
                    break;
                }
            }
            finally {
                g.dispose();
            }
        }
        return requiresLongFieldEditor;
    }

    private boolean isCellEditable() {
        if (this.cellValue instanceof ArbilField[]) {
            ArbilDataNode parentObject = ((ArbilField[])this.cellValue)[0].getParentDataNode();
            return !parentObject.isLoading() && parentObject.isEditable() && parentObject.isMetaDataNode();
        }
        return false;
    }

    private boolean isStartLongFieldKey(KeyEvent evt) {
        return this.isStartLongFieldModifier(evt) && (evt.getKeyCode() == 10 || evt.getKeyCode() == 32);
    }

    private boolean isStartLongFieldModifier(InputEvent evt) {
        return evt.isAltDown() || evt.isControlDown();
    }

    private void removeAllFocusListeners() {
        while (this.componentsWithFocusListners.size() > 0) {
            Component currentComponent = this.componentsWithFocusListners.remove(0);
            if (currentComponent == null) continue;
            for (FocusListener currentListner : currentComponent.getFocusListeners()) {
                currentComponent.removeFocusListener(currentListner);
            }
        }
    }

    private void addFocusListener(Component targetComponent) {
        this.componentsWithFocusListners.add(targetComponent);
        targetComponent.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                try {
                    boolean oppositeIsParent;
                    boolean bl = oppositeIsParent = e.getComponent().equals(e.getOppositeComponent().getParent()) || e.getComponent().getParent().equals(e.getOppositeComponent());
                    if (!oppositeIsParent && e.getComponent().getParent() != null && !e.getOppositeComponent().getParent().equals(ArbilTableCellEditor.this.editorPanel)) {
                        ArbilTableCellEditor.this.stopCellEditing();
                    }
                }
                catch (Exception ex) {
                    logger.debug("OppositeComponent or parent container not set");
                }
            }
        });
    }

    private String getEditorText(int lastKeyInt, char lastKeyChar, String currentCellString) {
        switch (lastKeyInt) {
            case 127: {
                currentCellString = "";
                break;
            }
            case 8: {
                currentCellString = "";
                break;
            }
            case 155: {
                break;
            }
            case 27: {
                break;
            }
            case 144: {
                break;
            }
            case 20: {
                break;
            }
            case 65535: {
                break;
            }
            case 113: {
                break;
            }
            default: {
                if (lastKeyChar == '\uffff') break;
                currentCellString = "" + lastKeyChar;
            }
        }
        return currentCellString;
    }

    private boolean cellHasControlledVocabulary() {
        return ((ArbilField)this.cellValue[0]).hasVocabulary();
    }

    public void startLongfieldEditor(JTable table, Object value, boolean isSelected, int row, int column) {
        this.getTableCellEditorComponent(table, value, isSelected, row, column);
        this.fireEditingStopped();
        if (this.cellValue instanceof ArbilField[]) {
            int currentFieldIndex = this.selectedField;
            if (currentFieldIndex < 0) {
                currentFieldIndex = 0;
            }
            new ArbilLongFieldEditor(this.parentTable).showEditor((ArbilField[])this.cellValue, this.getEditorText(65535, '\uffff', ((ArbilField)this.cellValue[currentFieldIndex]).getFieldValue()), currentFieldIndex);
        }
    }

    private void startEditorMode(boolean startLongFieldEditor, int lastKeyInt, char lastKeyChar) {
        this.removeAllFocusListeners();
        if (this.cellValue instanceof ArbilField[]) {
            if (this.cellHasControlledVocabulary() && this.isCellEditable()) {
                this.initControlledVocabularyEditor(lastKeyInt, lastKeyChar);
            } else if (!(startLongFieldEditor || this.selectedField == -1 || !this.isCellEditable() || this.requiresLongFieldEditor() && this.getEditorText(lastKeyInt, lastKeyChar, "anystring").length() != 0)) {
                this.initFieldEditor(lastKeyInt, lastKeyChar);
            } else {
                this.fireEditingStopped();
                if (this.cellValue instanceof ArbilField[]) {
                    int currentFieldIndex = this.selectedField;
                    if (currentFieldIndex < 0) {
                        currentFieldIndex = 0;
                    }
                    new ArbilLongFieldEditor(this.parentTable).showEditor((ArbilField[])this.cellValue, this.getEditorText(lastKeyInt, lastKeyChar, ((ArbilField)this.cellValue[currentFieldIndex]).getFieldValue()), currentFieldIndex);
                }
            }
        } else if (this.cellValue instanceof ArbilDataNode[]) {
            this.tableController.openNodesInNewTable((ArbilDataNode[])this.cellValue, this.fieldName, this.registeredOwner);
        } else if (this.cellValue.length != 1 || !(this.cellValue[0] instanceof ArbilFieldPlaceHolder)) {
            BugCatcherManager.getBugCatcher().logError("Edit cell type not supported", null);
        }
    }

    public Object getCellEditorValue() {
        if (this.selectedField != -1) {
            if (this.editorComponent != null) {
                if (this.editorComponent instanceof ControlledVocabularyComboBox) {
                    ((ArbilField[])this.cellValue)[this.selectedField].setFieldValue(((ControlledVocabularyComboBox)this.editorComponent).getCurrentValue(), true, false);
                } else if (this.editorComponent instanceof ArbilFieldEditor) {
                    ((ArbilField[])this.cellValue)[this.selectedField].setFieldValue(((ArbilFieldEditor)this.editorComponent).getText(), true, false);
                }
            }
            return this.cellValue[this.selectedField];
        }
        return this.cellValue;
    }

    private void convertCellValue(ArbilTableCell cell) throws ArbilMetadataException {
        Object value = cell.getContent();
        if (value != null) {
            if (value instanceof ArbilField) {
                this.fieldName = ((ArbilField)value).getTranslateFieldName();
                this.cellValue = ((ArbilField)value).getParentDataNode().getFields().get(this.fieldName);
                for (int cellFieldCounter = 0; cellFieldCounter < this.cellValue.length; ++cellFieldCounter) {
                    if (!this.cellValue[cellFieldCounter].equals(value)) continue;
                    this.selectedField = cellFieldCounter;
                }
            } else if (value instanceof Object[]) {
                this.cellValue = (Object[])value;
                if (this.cellValue[0] instanceof ArbilField) {
                    this.fieldName = ((ArbilField[])this.cellValue)[0].getTranslateFieldName();
                }
            } else if (value instanceof ArbilFieldPlaceHolder) {
                this.fieldName = ((ArbilFieldPlaceHolder)value).getFieldName();
                this.cellValue = new Object[]{value};
            } else {
                throw new ArbilMetadataException("Object type unsupported by cell editor");
            }
            if (this.cellValue != null && this.cellValue[0] instanceof ArbilField) {
                this.registeredOwner = ((ArbilField)this.cellValue[0]).getParentDataNode();
            }
        } else {
            BugCatcherManager.getBugCatcher().logError(new Exception("value is null in convertCellValue"));
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object valueObject, boolean isSelected, int row, int column) {
        ArbilTableCell value = (ArbilTableCell)valueObject;
        this.parentTable = (ArbilTable)table;
        this.parentCellRect = this.parentTable.getCellRect(row, column, false);
        ArbilIconCellRenderer cellRenderer = (ArbilIconCellRenderer)this.arbilTableCellRenderer.getTableCellRendererComponent(table, valueObject, isSelected, true, row, column);
        try {
            this.convertCellValue(value);
        }
        catch (ArbilMetadataException ex) {
            return cellRenderer;
        }
        this.button.setText(this.arbilTableCellRenderer.getText());
        this.button.setForeground(this.arbilTableCellRenderer.getForeground());
        this.button.setIcon(this.arbilTableCellRenderer.getIcon());
        this.editorPanel.setBackground(table.getSelectionBackground());
        this.editorPanel.setLayout(new BorderLayout());
        this.editorPanel.add(this.button);
        this.addFocusListener(this.button);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ArbilTableCellEditor.this.button.requestFocusInWindow();
            }
        });
        if (this.cellValue instanceof ArbilField[]) {
            Icon icon;
            Icon icon2 = icon = this.selectedField < 0 ? null : ArbilIcons.getSingleInstance().getIconForField((ArbilField)this.cellValue[this.selectedField]);
            if (icon != null) {
                ArbilIconCellPanel panel = new ArbilIconCellPanel(this.editorPanel, icon);
                panel.addIconMouseListener(this.fieldMouseAdapter);
                return panel;
            }
            return this.editorPanel;
        }
        return this.editorPanel;
    }
}

