/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilTableCell;
import nl.mpi.arbil.ui.ArbilFieldPlaceHolder;
import nl.mpi.arbil.ui.ArbilIconCellRenderer;

public class ArbilTableCellRenderer
extends DefaultTableCellRenderer {
    final ArbilIconCellRenderer arbilIconCellRenderer = new ArbilIconCellRenderer(this);

    public int getRequiredWidth(FontMetrics fontMetrics, ArbilTableCell cellObject) {
        Icon icon;
        Object cellContent = this.getCellContent(cellObject);
        String currentCellString = this.getText();
        int width = fontMetrics.stringWidth(currentCellString);
        if (cellContent instanceof ArbilField && (icon = ArbilIcons.getSingleInstance().getIconForField((ArbilField)cellContent)) != null) {
            width += icon.getIconWidth();
        }
        return width;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ArbilTableCell cellObject = (ArbilTableCell)value;
        String textValue = cellObject == null ? "" : cellObject.toString();
        super.getTableCellRendererComponent(table, textValue, isSelected, hasFocus, row, column);
        Object cellContent = this.getCellContent(cellObject);
        this.setColours(cellContent, isSelected);
        Icon leftIcon = this.getIcon(cellContent);
        Icon rightIcon = null;
        if (cellContent instanceof ArbilField) {
            rightIcon = ArbilIcons.getSingleInstance().getIconForField((ArbilField)cellContent);
        }
        this.arbilIconCellRenderer.setIcons(leftIcon, rightIcon);
        return this.arbilIconCellRenderer;
    }

    protected final void setColours(Object cellContent, boolean isSelected) {
        if (cellContent instanceof ArbilField[]) {
            int greyTone = 150;
            super.setForeground(new Color(greyTone, greyTone, greyTone));
        }
        if (!isSelected) {
            if (cellContent instanceof ArbilFieldPlaceHolder || cellContent instanceof String && "".equals(cellContent)) {
                super.setBackground(new Color(230, 230, 230));
            } else if (cellContent instanceof ArbilField && ((ArbilField)cellContent).fieldNeedsSaveToDisk()) {
                super.setForeground(Color.blue);
            }
            if (cellContent instanceof ArbilField && ((ArbilField)cellContent).isRequiredField() && ((ArbilField)cellContent).getFieldValue().length() == 0) {
                super.setForeground(Color.RED);
            } else if (cellContent instanceof ArbilField && !((ArbilField)cellContent).fieldValueValidates()) {
                super.setForeground(Color.RED);
            }
        }
    }

    public Icon getIcon(Object cellContent) {
        if (cellContent instanceof ArbilDataNode) {
            return ((ArbilDataNode)cellContent).getIcon();
        }
        if (cellContent instanceof ArbilDataNode[]) {
            return ArbilIcons.getSingleInstance().getIconForNode((ArbilDataNode[])cellContent);
        }
        if (cellContent instanceof ArbilField[]) {
            return null;
        }
        return null;
    }

    private Object getCellContent(ArbilTableCell cellObject) {
        if (cellObject == null) {
            return null;
        }
        return cellObject.getContent();
    }
}

