/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import nl.mpi.arbil.data.ArbilComponentBuilder;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.templates.ArbilTemplate;
import nl.mpi.arbil.ui.ArbilFieldViewTable;
import nl.mpi.arbil.ui.ArbilFieldViews;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilTableCellEditor;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.fieldeditors.ArbilLongFieldEditor;
import nl.mpi.arbil.ui.menu.TableContextMenu;
import nl.mpi.arbil.ui.menu.TableHeaderContextMenu;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.TreeHelper;
import nl.mpi.arbil.util.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilTableController {
    private static final Logger logger = LoggerFactory.getLogger(ArbilTableController.class);
    public static final String DELETE_ROW_ACTION_KEY = "deleteRow";
    private final TreeHelper treeHelper;
    private final MessageDialogHandler dialogHandler;
    private final WindowManager windowManager;
    private final MouseListener tableMouseListener = new TableMouseListener();
    private final MouseListener tableHeaderMouseListener = new TableHeaderMouseListener();
    private final Action deleteRowAction = new DeleteRowAction();

    public ArbilTableController(TreeHelper treeHelper, MessageDialogHandler dialogHandler, WindowManager windowManager) {
        this.treeHelper = treeHelper;
        this.dialogHandler = dialogHandler;
        this.windowManager = windowManager;
    }

    public void initKeyMapping(ArbilTable table) {
        table.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), DELETE_ROW_ACTION_KEY);
        table.getActionMap().put(DELETE_ROW_ACTION_KEY, this.deleteRowAction);
    }

    public MouseListener getTableMouseListener() {
        return this.tableMouseListener;
    }

    public MouseListener getTableHeaderMouseListener() {
        return this.tableHeaderMouseListener;
    }

    public void openNodesInNewTable(ArbilDataNode[] nodes, String fieldName, ArbilDataNode registeredOwner) {
        this.windowManager.openFloatingTableOnce(nodes, String.format("%s in %s", fieldName, registeredOwner));
    }

    public void showRowChildData(ArbilTableModel tableModel) {
        Object[] possibilities = tableModel.getChildNames();
        String selectionResult = (String)JOptionPane.showInputDialog(this.windowManager.getMainFrame(), "Select the child node type to display", "Show child nodes", -1, null, possibilities, null);
        if (selectionResult != null && selectionResult.length() > 0) {
            tableModel.addChildTypeToDisplay(selectionResult);
        }
    }

    public void viewSelectedTableRows(ArbilTable table) {
        int[] selectedRows = table.getSelectedRows();
        this.windowManager.openFloatingTableOnce(table.getArbilTableModel().getSelectedDataNodes(selectedRows), null);
    }

    public void showColumnViewsEditor(ArbilTable table) {
        table.updateStoredColumnWidths();
        try {
            ArbilFieldViewTable fieldViewTable = new ArbilFieldViewTable(table.getArbilTableModel());
            JDialog editViewsDialog = new JDialog(JOptionPane.getFrameForComponent(this.windowManager.getMainFrame()), true);
            editViewsDialog.setTitle("Editing Current Column View");
            JScrollPane js = new JScrollPane(fieldViewTable);
            editViewsDialog.getContentPane().add(js);
            editViewsDialog.setBounds(50, 50, 600, 400);
            editViewsDialog.setVisible(true);
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    public void saveCurrentColumnView(ArbilTable table) {
        try {
            String fieldViewName = JOptionPane.showInputDialog(null, "Enter a name to save this Column View as", "Save Column View", -1);
            if (fieldViewName != null) {
                table.updateStoredColumnWidths();
                if (!ArbilFieldViews.getSingleInstance().addArbilFieldView(fieldViewName, table.getArbilTableModel().getFieldView())) {
                    this.dialogHandler.addMessageDialogToQueue("A Column View with the same name already exists, nothing saved", "Save Column View");
                }
            }
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    public boolean deleteSelectedFields(ArbilTable table) {
        ArbilField[] selectedFields = table.getSelectedFields();
        if (selectedFields != null) {
            return this.deleteFields(Arrays.asList(selectedFields));
        }
        return false;
    }

    public boolean deleteColumnFieldFromAllNodes(ArbilTable table, String columnName) {
        ArrayList<ArbilDataNode> rowNodes = Collections.list(table.getArbilTableModel().getArbilDataNodes());
        ArrayList<ArbilField> fieldsToDelete = new ArrayList<ArbilField>(rowNodes.size());
        for (ArbilDataNode rowNode : rowNodes) {
            ArbilField[] fields = rowNode.getFields().get(columnName);
            if (fields == null) continue;
            for (ArbilField field : fields) {
                String fieldPath;
                ArbilTemplate fieldParentTemplate = field.getParentDataNode().getNodeTemplate();
                if (!fieldParentTemplate.pathIsDeleteableField(fieldPath = field.getGenericFullXmlPath())) {
                    this.dialogHandler.addMessageDialogToQueue("This field cannot be deleted from one or more of the shown nodes", "Cannot delete");
                    return false;
                }
                fieldsToDelete.add(fields[0]);
            }
        }
        if (this.dialogHandler.showConfirmDialogBox(String.format("Delete %d instance of the field '%s'?", fieldsToDelete.size(), columnName), "Delete field")) {
            return this.deleteFields(fieldsToDelete);
        }
        return false;
    }

    private boolean deleteFields(Collection<ArbilField> fields) {
        ArbilComponentBuilder componentBuilder = new ArbilComponentBuilder();
        try {
            Map<ArbilDataNode, List<String>> selectedFieldHashtable = this.getFieldDeletionMap(fields);
            for (ArbilDataNode currentDataNode : selectedFieldHashtable.keySet()) {
                String[] fieldsToDelete;
                if (componentBuilder.removeChildNodes(currentDataNode, fieldsToDelete = selectedFieldHashtable.get(currentDataNode).toArray(new String[0]))) {
                    currentDataNode.reloadNode();
                    continue;
                }
                this.dialogHandler.addMessageDialogToQueue(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("ERROR DELETING FIELDS, CHECK THE LOG FILE VIA THE HELP MENU FOR MORE INFORMATION."), ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("DELETE FIELD"));
            }
            return true;
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
            return false;
        }
    }

    private Map<ArbilDataNode, List<String>> getFieldDeletionMap(Collection<ArbilField> fields) {
        HashMap<ArbilDataNode, List<String>> selectedFieldHashtable = new HashMap<ArbilDataNode, List<String>>();
        for (ArbilField currentField : fields) {
            ArbilDataNode fieldParent = currentField.getParentDataNode();
            if (!selectedFieldHashtable.containsKey(fieldParent)) {
                selectedFieldHashtable.put(fieldParent, new ArrayList());
            }
            List fieldParentList = (List)selectedFieldHashtable.get(fieldParent);
            fieldParentList.add(currentField.getFullXmlPath());
        }
        return selectedFieldHashtable;
    }

    public void copySelectedCellToColumn(ArbilTable table) {
        try {
            String messageString = MessageFormat.format(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("ABOUT TO REPLACE ALL VALUES IN COLUMN {0} WITH THE VALUE {1}(<MULTIPLE VALUES> WILL NOT BE AFFECTED)"), table.getArbilTableModel().getColumnName(table.getSelectedColumn()), table.getArbilTableModel().getValueAt(table.getSelectedRow(), table.getSelectedColumn()));
            if (!(table.getArbilTableModel().getTableCellContentAt(table.getSelectedRow(), table.getSelectedColumn()) instanceof ArbilField)) {
                this.dialogHandler.addMessageDialogToQueue(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("CANNOT COPY THIS TYPE OF FIELD"), ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("COPY CELL TO WHOLE COLUMN"));
            } else if (0 == JOptionPane.showConfirmDialog(this.windowManager.getMainFrame(), messageString, ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("COPY CELL TO WHOLE COLUMN"), 0, -1)) {
                table.getArbilTableModel().copyCellToColumn(table.getSelectedRow(), table.getSelectedColumn());
            }
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    public void deleteNodes(ArbilTable table) {
        this.treeHelper.deleteNodes(table);
    }

    public void jumpToSelectionInTree(ArbilTable table) {
        try {
            this.treeHelper.jumpToSelectionInTree(false, table.getDataNodeForSelection());
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    public void showContextForSelectedNodes(ArbilTable table) {
        HashSet<ArbilDataNode> parentNodes = new HashSet<ArbilDataNode>();
        for (ArbilField selectedField : table.getSelectedFields()) {
            parentNodes.add(selectedField.getParentDataNode().getParentDomNode());
        }
        this.windowManager.openFloatingSubnodesWindows(parentNodes.toArray(new ArbilDataNode[0]));
    }

    public void highlightMatchingRows(ArbilTable table) {
        ArbilTableModel tableModel = table.getArbilTableModel();
        int selectedRow = table.getSelectedRow();
        if (selectedRow == -1) {
            this.dialogHandler.addMessageDialogToQueue("No rows have been selected", "Highlight Matching Rows");
            return;
        }
        List<Integer> foundRows = tableModel.getMatchingRows(selectedRow);
        table.getSelectionModel().setSelectionMode(2);
        table.getSelectionModel().clearSelection();
        this.dialogHandler.addMessageDialogToQueue("Found " + foundRows.size() + " matching rows", "Highlight Matching Rows");
        for (int foundCount = 0; foundCount < foundRows.size(); ++foundCount) {
            for (int coloumCount = 0; coloumCount < table.getColumnCount(); ++coloumCount) {
                table.getSelectionModel().addSelectionInterval(foundRows.get(foundCount), foundRows.get(foundCount));
            }
        }
    }

    public void startLongFieldEditorForSelectedFields(ArbilTable table) {
        ArbilTableModel tableModel = table.getArbilTableModel();
        int[] selectedRows = table.getSelectedRows();
        if (selectedRows.length > 0) {
            int[] selectedCols;
            if (table.getCellSelectionEnabled()) {
                selectedCols = table.getSelectedColumns();
            } else {
                selectedCols = new int[table.getColumnCount()];
                for (int colCounter = 0; colCounter < selectedCols.length; ++colCounter) {
                    selectedCols[colCounter] = colCounter;
                }
            }
            for (int currentRow : selectedRows) {
                if (tableModel.isHorizontalView() && table.getSelectionModel().getSelectionMode() == 2 && table.getSelectedColumnCount() > 0) {
                    ArbilDataNode node;
                    Object currentCellValue = table.getTableCellContentAt(currentRow, table.getSelectedColumns()[0]);
                    if (!(currentCellValue instanceof ArbilDataNode) || (node = (ArbilDataNode)currentCellValue).getFields().size() <= 0) continue;
                    List<ArbilField[]> fieldArrays = node.getFieldsSorted();
                    new ArbilLongFieldEditor(table).showEditor(fieldArrays.get(0), fieldArrays.get(0)[0].getFieldValue(), 0);
                    continue;
                }
                for (int currentCol : selectedCols) {
                    Object currentCellValue = table.getTableCellContentAt(currentRow, currentCol);
                    if (!(currentCellValue instanceof ArbilField) && !(currentCellValue instanceof ArbilField[])) continue;
                    new ArbilTableCellEditor(this).startLongfieldEditor(table, table.getTableCellAt(currentRow, currentCol), false, currentRow, currentCol);
                }
            }
        }
    }

    public void checkPopup(MouseEvent evt, boolean checkSelection) {
        ArbilTable table = this.getEventSourceAsArbilTable(evt);
        ArbilTableModel tableModel = table.getArbilTableModel();
        if (!tableModel.hideContextMenuAndStatusBar && evt.isPopupTrigger()) {
            Point p = evt.getPoint();
            int clickedRow = table.rowAtPoint(p);
            int clickedColumn = table.columnAtPoint(p);
            boolean clickedRowAlreadySelected = table.isRowSelected(clickedRow);
            if (!(!checkSelection || evt.isShiftDown() || evt.isControlDown() || evt.isPopupTrigger() && clickedRowAlreadySelected || !(clickedRow > -1 & clickedRow > -1))) {
                table.getSelectionModel().clearSelection();
                table.changeSelection(clickedRow, clickedColumn, false, evt.isShiftDown());
            }
        }
        if (evt.isPopupTrigger()) {
            TableCellEditor tableCellEditor = table.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            new TableContextMenu(table, this).show(evt.getX(), evt.getY());
        }
    }

    private ArbilTable getEventSourceAsArbilTable(InputEvent event) {
        Container tableAncestor;
        Object source = event.getSource();
        if (source instanceof ArbilTable) {
            return (ArbilTable)source;
        }
        if (source instanceof JTableHeader) {
            JTable table = ((JTableHeader)source).getTable();
            if (table instanceof ArbilTable) {
                return (ArbilTable)table;
            }
            logger.warn("InputEvent coming from header of a JTable that is not an ArbilTable");
        }
        if (source instanceof Component && (tableAncestor = SwingUtilities.getAncestorOfClass(ArbilTable.class, (Component)source)) != null) {
            return (ArbilTable)tableAncestor;
        }
        logger.warn("Could not find ArbilTable associated with InputEvent source {}", source);
        throw new RuntimeException("Cannot find ArbilTable in component hierarchy from event");
    }

    private class DeleteRowAction
    extends AbstractAction {
        private DeleteRowAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ArbilTableController.this.treeHelper.deleteNodes(e.getSource());
        }
    }

    private class TableHeaderMouseListener
    extends MouseAdapter {
        private TableHeaderMouseListener() {
        }

        public void mousePressed(MouseEvent evt) {
            this.checkTableHeaderPopup(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.checkTableHeaderPopup(evt);
        }

        public void mouseClicked(MouseEvent evt) {
            ArbilTable table = ArbilTableController.this.getEventSourceAsArbilTable(evt);
            ArbilTableModel tableModel = table.getArbilTableModel();
            if (evt.getButton() == 1) {
                tableModel.sortByColumn(table.convertColumnIndexToModel(((JTableHeader)evt.getComponent()).columnAtPoint(new Point(evt.getX(), evt.getY()))));
                table.getTableHeader().revalidate();
            }
            this.checkTableHeaderPopup(evt);
        }

        private void checkTableHeaderPopup(MouseEvent evt) {
            ArbilTable table = ArbilTableController.this.getEventSourceAsArbilTable(evt);
            ArbilTableModel tableModel = table.getArbilTableModel();
            if (!tableModel.hideContextMenuAndStatusBar && evt.isPopupTrigger()) {
                int targetColumn = table.convertColumnIndexToModel(((JTableHeader)evt.getComponent()).columnAtPoint(new Point(evt.getX(), evt.getY())));
                logger.debug("showing header menu for column {}", (Object)targetColumn);
                TableHeaderContextMenu popupMenu = new TableHeaderContextMenu(ArbilTableController.this, table, targetColumn);
                popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        public void mousePressed(MouseEvent evt) {
            ArbilTableController.this.checkPopup(evt, true);
        }

        public void mouseReleased(MouseEvent evt) {
            ArbilTableController.this.checkPopup(evt, true);
        }
    }
}

