/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.menu;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.table.TableColumn;
import nl.mpi.arbil.ui.ArbilFieldViews;
import nl.mpi.arbil.ui.ArbilSplitPanel;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilTableController;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.util.BugCatcherManager;

public class TableHeaderContextMenu
extends JPopupMenu {
    private final ArbilTable table;
    private final ArbilTableModel tableModel;
    private final ArbilTableController tableController;

    public TableHeaderContextMenu(ArbilTableController tableController, ArbilTable table, int targetColumn) {
        this.table = table;
        this.tableModel = table.getArbilTableModel();
        this.tableController = tableController;
        this.initMenuItems(targetColumn);
    }

    private void initMenuItems(final int targetColumn) {
        final String targetColumnName = this.tableModel.getColumnName(targetColumn);
        JMenuItem saveViewMenuItem = new JMenuItem("Save Current Column View");
        saveViewMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableHeaderContextMenu.this.tableController.saveCurrentColumnView(TableHeaderContextMenu.this.table);
            }
        });
        JMenuItem editViewMenuItem = new JMenuItem("Edit this Column View");
        editViewMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableHeaderContextMenu.this.tableController.showColumnViewsEditor(TableHeaderContextMenu.this.table);
            }
        });
        JMenuItem showOnlyCurrentViewMenuItem = new JMenuItem("Limit View to Current Columns");
        showOnlyCurrentViewMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    TableHeaderContextMenu.this.tableModel.showOnlyCurrentColumns();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        JMenu fieldViewsMenuItem = new JMenu("Column View for this Table");
        ButtonGroup viewMenuButtonGroup = new ButtonGroup();
        Enumeration savedViewsEnum = ArbilFieldViews.getSingleInstance().getSavedFieldViewLables();
        while (savedViewsEnum.hasMoreElements()) {
            String currentViewLabel = savedViewsEnum.nextElement().toString();
            JMenuItem viewLabelMenuItem = new JMenuItem();
            viewMenuButtonGroup.add(viewLabelMenuItem);
            viewLabelMenuItem.setText(currentViewLabel);
            viewLabelMenuItem.setName(currentViewLabel);
            viewLabelMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        TableHeaderContextMenu.this.tableModel.setCurrentView(ArbilFieldViews.getSingleInstance().getView(((Component)evt.getSource()).getName()));
                        TableHeaderContextMenu.this.table.doResizeColumns();
                    }
                    catch (Exception ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                    }
                }
            });
            fieldViewsMenuItem.add(viewLabelMenuItem);
        }
        JMenuItem copyEmbedTagMenuItem = new JMenuItem("Copy Table For Website");
        copyEmbedTagMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ArbilTable sizedComponent = TableHeaderContextMenu.this.table;
                Container currentComponent = TableHeaderContextMenu.this.table;
                while (currentComponent.getParent() != null) {
                    if (!((currentComponent = currentComponent.getParent()) instanceof ArbilSplitPanel)) continue;
                    sizedComponent = currentComponent;
                }
                TableHeaderContextMenu.this.tableModel.copyHtmlEmbedTagToClipboard(((Component)sizedComponent).getHeight(), ((Component)sizedComponent).getWidth());
            }
        });
        JMenuItem setAllColumnsSizeFromColumn = new JMenuItem("Make all columns the size of \"" + targetColumnName + "\"");
        setAllColumnsSizeFromColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int targetWidth = TableHeaderContextMenu.this.table.getColumnModel().getColumn(targetColumn).getWidth();
                for (int i = 0; i < TableHeaderContextMenu.this.table.getColumnCount(); ++i) {
                    TableColumn column = TableHeaderContextMenu.this.table.getColumnModel().getColumn(i);
                    TableHeaderContextMenu.this.tableModel.getFieldView().setColumnWidth(column.getHeaderValue().toString(), targetWidth);
                }
                TableHeaderContextMenu.this.table.doResizeColumns();
            }
        });
        JMenuItem setAllColumnsSizeAuto = new JMenuItem("Make all columns fit contents");
        setAllColumnsSizeAuto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableHeaderContextMenu.this.tableModel.getFieldView().resetColumnWidths();
                TableHeaderContextMenu.this.table.doResizeColumns();
            }
        });
        JMenuItem setColumnSizeAuto = new JMenuItem("Make column fit contents");
        setColumnSizeAuto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableHeaderContextMenu.this.tableModel.getFieldView().setColumnWidth(targetColumnName, null);
                TableHeaderContextMenu.this.table.doResizeColumns(Arrays.asList(targetColumn));
            }
        });
        final JCheckBoxMenuItem setFixedColumnSize = new JCheckBoxMenuItem("Fixed column size");
        setFixedColumnSize.setSelected(this.tableModel.getPreferredColumnWidth(targetColumnName) != null);
        setFixedColumnSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableHeaderContextMenu.this.tableModel.getFieldView().setColumnWidth(targetColumnName, setFixedColumnSize.isSelected() ? Integer.valueOf(TableHeaderContextMenu.this.table.getColumnModel().getColumn(targetColumn).getWidth()) : null);
                TableHeaderContextMenu.this.table.doResizeColumns(Collections.singleton(targetColumn));
            }
        });
        JMenuItem deleteFieldFromNodes = new JMenuItem("Delete field from all nodes");
        deleteFieldFromNodes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableHeaderContextMenu.this.tableController.deleteColumnFieldFromAllNodes(TableHeaderContextMenu.this.table, targetColumnName);
            }
        });
        if (this.tableModel.isHorizontalView()) {
            JMenu thisColumnMenu = new JMenu("This column (" + (targetColumnName.trim().length() == 0 ? "nameless" : targetColumnName) + ")");
            thisColumnMenu.add(setFixedColumnSize);
            thisColumnMenu.add(setColumnSizeAuto);
            if (targetColumn != 0) {
                thisColumnMenu.add(new JSeparator());
                thisColumnMenu.add(this.createHideColumnMenuItem(targetColumn));
            }
            JMenu allColumnsMenu = new JMenu("All columns");
            allColumnsMenu.add(setAllColumnsSizeFromColumn);
            allColumnsMenu.add(setAllColumnsSizeAuto);
            this.add(thisColumnMenu);
            this.add(allColumnsMenu);
            this.add(this.createShowChildNodesMenuItem(targetColumn));
            this.add(new JSeparator());
        }
        this.add(fieldViewsMenuItem);
        this.add(saveViewMenuItem);
        this.add(editViewMenuItem);
        this.add(showOnlyCurrentViewMenuItem);
        this.add(new JSeparator());
        this.add(deleteFieldFromNodes);
        this.add(new JSeparator());
        this.add(copyEmbedTagMenuItem);
    }

    private JMenuItem createHideColumnMenuItem(final int targetColumn) {
        JMenuItem hideColumnMenuItem = new JMenuItem("Hide Column");
        hideColumnMenuItem.setActionCommand("" + targetColumn);
        hideColumnMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    TableHeaderContextMenu.this.tableModel.hideColumn(targetColumn);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        return hideColumnMenuItem;
    }

    private JMenuItem createShowChildNodesMenuItem(int targetColumn) {
        JMenuItem showChildNodesMenuItem = new JMenuItem();
        showChildNodesMenuItem.setText("Show Child Nodes");
        showChildNodesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TableHeaderContextMenu.this.tableController.showRowChildData(TableHeaderContextMenu.this.tableModel);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        return showChildNodesMenuItem;
    }
}

