/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersion;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationVersionManager {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationVersionManager.class);
    private static MessageDialogHandler messageDialogHandler;
    private static SessionStorage sessionStorage;
    private ApplicationVersion applicationVersion;

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public ApplicationVersionManager(ApplicationVersion appVersion) {
        this.applicationVersion = appVersion;
    }

    public ApplicationVersion getApplicationVersion() {
        return this.applicationVersion;
    }

    public boolean forceUpdateCheck() {
        File cachePath = sessionStorage.getSaveLocation(this.applicationVersion.currentVersionFile);
        if (cachePath.delete()) {
            logger.debug("Dropped old version file");
        } else {
            messageDialogHandler.addMessageDialogToQueue("Could not write to storage directory. Update check failed!", "Error");
        }
        return this.checkForUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLatestVersion() {
        BufferedReader bufferedReader = null;
        try {
            int daysTillExpire = 1;
            File cachePath = sessionStorage.updateCache(this.applicationVersion.currentVersionFile, daysTillExpire, false);
            bufferedReader = new BufferedReader(new FileReader(cachePath));
            String serverVersionString = bufferedReader.readLine();
            logger.debug("currentRevision: {}", (Object)this.applicationVersion.currentRevision);
            logger.debug("serverVersionString: {}", (Object)serverVersionString);
            if (serverVersionString == null || !serverVersionString.matches("[0-9]*")) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.applicationVersion.currentRevision.compareTo(serverVersionString) >= 0;
            return bl;
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ioe) {
                    BugCatcherManager.getBugCatcher().logError(ioe);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doUpdate(String webstartUrlString) {
        BufferedReader errorStreamReader = null;
        try {
            String line;
            Process launchedProcess = Runtime.getRuntime().exec(new String[]{"javaws", "-import", webstartUrlString});
            errorStreamReader = new BufferedReader(new InputStreamReader(launchedProcess.getErrorStream()));
            while ((line = errorStreamReader.readLine()) != null) {
                logger.debug("Launched process error stream: \"" + line + "\"");
            }
            boolean bl = 0 == launchedProcess.waitFor();
            return bl;
        }
        catch (Exception e) {
            BugCatcherManager.getBugCatcher().logError(e);
        }
        finally {
            if (errorStreamReader != null) {
                try {
                    errorStreamReader.close();
                }
                catch (IOException ioe) {
                    BugCatcherManager.getBugCatcher().logError(ioe);
                }
            }
        }
        return false;
    }

    private void restartApplication(String webstartUrlString) {
        try {
            Process restartProcess = Runtime.getRuntime().exec(new String[]{"javaws", webstartUrlString});
            if (0 == restartProcess.waitFor()) {
                System.exit(0);
            } else {
                messageDialogHandler.addMessageDialogToQueue("There was an error restarting the application.\nThe update will take effect next time the application is restarted.", null);
            }
        }
        catch (Exception e) {
            BugCatcherManager.getBugCatcher().logError(e);
        }
    }

    public boolean checkForUpdate() {
        if (!this.isLatestVersion()) {
            if (this.hasWebStartUrl()) {
                this.checkForAndUpdateViaJavaws();
            } else {
                new Thread("checkForUpdate"){

                    public void run() {
                        messageDialogHandler.addMessageDialogToQueue("There is a new version available.\nPlease go to the website and update via the download link.", null);
                    }
                }.start();
            }
            return true;
        }
        return false;
    }

    public boolean hasWebStartUrl() {
        logger.debug("hasWebStartUrl");
        String webstartUpdateUrl = System.getProperty("nl.mpi.webstartUpdateUrl");
        logger.debug("webstartUpdateUrl: {}", (Object)webstartUpdateUrl);
        return null != webstartUpdateUrl;
    }

    public void checkForAndUpdateViaJavaws() {
        new Thread("checkForAndUpdateViaJavaws"){

            public void run() {
                String webstartUrlString = System.getProperty("nl.mpi.webstartUpdateUrl");
                if (webstartUrlString != null && !ApplicationVersionManager.this.isLatestVersion()) {
                    switch (messageDialogHandler.showDialogBox("There is a new version available\nDo you want to update now?", ((ApplicationVersionManager)ApplicationVersionManager.this).applicationVersion.applicationTitle, 1, -1)) {
                        case 1: {
                            break;
                        }
                        case 0: {
                            if (ApplicationVersionManager.this.doUpdate(webstartUrlString)) {
                                ApplicationVersionManager.this.restartApplication(webstartUrlString);
                                break;
                            }
                            messageDialogHandler.addMessageDialogToQueue("There was an error updating the application.\nPlease go to the website and update via the download link.", null);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
            }
        }.start();
    }
}

