/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.Util;

public class SignedInputStream
extends InputStream {
    public static final int STREAM_TYPE_PK = 0;
    private InputStream in;
    private Signature sig;
    private int streamType;

    public SignedInputStream(PublicKey sourceKey, InputStream in) throws Exception {
        this.in = in;
        byte[] streamTypeBuf = new byte[4];
        if (in.read(streamTypeBuf) < streamTypeBuf.length) {
            throw new SignatureException("End of stream while reading stream type");
        }
        this.streamType = Encoder.readInt(streamTypeBuf, 0);
        switch (this.streamType) {
            case 0: {
                byte[] lenbuf = new byte[4];
                if (in.read(lenbuf) < lenbuf.length) {
                    throw new SignatureException("Unable to read signature hash type");
                }
                int hashIDLen = Encoder.readInt(lenbuf, 0);
                if (hashIDLen < 0 || hashIDLen > 0x100000) {
                    throw new SignatureException("Invalid hash ID - too long");
                }
                byte[] hashID = new byte[hashIDLen];
                if (in.read(hashID) < hashIDLen) {
                    throw new SignatureException("End of stream while reading hash ID");
                }
                this.sig = Signature.getInstance(Util.getSigIdFromHashAlgId(hashID, sourceKey.getAlgorithm()));
                this.sig.initVerify(sourceKey);
                break;
            }
            default: {
                throw new SignatureException("Unrecognized stream type: " + this.streamType);
            }
        }
    }

    public int read() throws IOException {
        int b = this.in.read();
        if (b < 0) {
            return b;
        }
        try {
            this.sig.update((byte)b);
        }
        catch (SignatureException e) {
            throw new IOException("Error updating signature: " + e);
        }
        return b;
    }

    public boolean verifyBlock() throws IOException, SignatureException {
        int n;
        int r;
        byte[] lenbuf = new byte[4];
        for (n = 0; n < lenbuf.length && (r = this.in.read(lenbuf, n, lenbuf.length - n)) >= 0; n += r) {
        }
        if (n < 4) {
            throw new SignatureException("End of stream while reading signature length");
        }
        int sigLen = Encoder.readInt(lenbuf, 0);
        if (sigLen < 0 || sigLen > 0x100000) {
            throw new SignatureException("Invalid signature - too long");
        }
        byte[] buf = new byte[sigLen];
        for (n = 0; n < sigLen && (r = this.in.read(buf, n, sigLen - n)) >= 0; n += r) {
        }
        if (n < sigLen) {
            throw new SignatureException("End of stream while reading signature.  Expected " + sigLen + ",  got " + n);
        }
        return this.sig.verify(buf);
    }
}

