/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib4;

import java.io.IOException;
import net.handle.hdllib4.Codes;
import net.handle.hdllib4.HandleElement;
import net.handle.hdllib4.HandleElementSet;
import net.handle.hdllib4.HandleException;
import net.handle.hdllib4.HandleResolver;
import net.handle.hdllib4.HandleResponse;
import net.handle.hdllib4.HashBucket;
import net.handle.hdllib4.ServerHashtable;
import net.handle.hdllib4.Util;

public class HashtableRetriever {
    public static ServerHashtable getHashtableFromServer(HashBucket bucket, int protocol) throws IOException, HandleException {
        HandleResolver resolver = new HandleResolver();
        resolver.protocol = protocol;
        HandleResponse response = resolver.sendResolveRequest("/service-pointer", bucket, null, null, 2);
        HandleElementSet elementSet = response.getPackagedData();
        if (elementSet == null) {
            return null;
        }
        HandleElement tableElement = elementSet.getElementOfType(11L);
        if (tableElement == null) {
            return null;
        }
        if (Util.compareArrays(tableElement.handleValue, Codes.HASH_ENCODING, Codes.MAX_SERVICE_ID_LENGTH)) {
            return new ServerHashtable(tableElement.handleValue, Codes.MAX_SERVICE_ID_LENGTH, tableElement.handleValue.length - Codes.MAX_SERVICE_ID_LENGTH);
        }
        throw new HandleException(1, "unknown schema for hashtable: " + new String(tableElement.handleValue, 0, Codes.MAX_SERVICE_ID_LENGTH));
    }
}

