/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbilcommons.journal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import nl.mpi.arbilcommons.model.HistoryField;
import nl.mpi.flap.plugin.JournalWatcherPlugin;
import nl.mpi.flap.plugin.PluginBugCatcher;
import nl.mpi.flap.plugin.PluginDialogHandler;
import nl.mpi.flap.plugin.PluginException;
import nl.mpi.flap.plugin.PluginJournal;
import nl.mpi.flap.plugin.PluginSessionStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilJournal
implements PluginJournal {
    private static final Logger logger = LoggerFactory.getLogger(ArbilJournal.class);
    private static PluginDialogHandler messageDialogHandler;
    private final HashSet<JournalWatcherPlugin> jounalWatchers = new HashSet();
    private static PluginSessionStorage sessionStorage;
    private static PluginBugCatcher bugCatcher;
    private static ArbilJournal singleInstance;
    ArrayList<HistoryItem> fieldChangeHistory;
    int currentFieldChangeHistoryItem = 0;

    public static void setMessageDialogHandler(PluginDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public static void setSessionStorage(PluginSessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static void setBugCatcher(PluginBugCatcher bugCatcher) {
        ArbilJournal.bugCatcher = bugCatcher;
    }

    private File getJournalFile() {
        return new File(sessionStorage.getProjectDirectory(), "ChangeJournal.log");
    }

    private ArbilJournal() {
    }

    public static synchronized ArbilJournal getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new ArbilJournal();
        }
        return singleInstance;
    }

    public synchronized void recordFieldChange(HistoryField targetField, String oldValue, String newValue, UndoType undoType) {
        if (this.fieldChangeHistory == null) {
            this.fieldChangeHistory = new ArrayList();
            this.currentFieldChangeHistoryItem = 0;
        }
        if (this.currentFieldChangeHistoryItem < this.fieldChangeHistory.size()) {
            this.fieldChangeHistory = new ArrayList<HistoryItem>(this.fieldChangeHistory.subList(0, this.currentFieldChangeHistoryItem));
        }
        HistoryItem historyItem = new HistoryItem();
        historyItem.targetField = targetField;
        historyItem.oldValue = oldValue;
        historyItem.newValue = newValue;
        historyItem.undoType = undoType;
        this.fieldChangeHistory.add(historyItem);
        ++this.currentFieldChangeHistoryItem;
    }

    public boolean canUndo() {
        return this.currentFieldChangeHistoryItem > 0;
    }

    public boolean canRedo() {
        return this.fieldChangeHistory != null && this.currentFieldChangeHistoryItem < this.fieldChangeHistory.size();
    }

    public void undoFromFieldChangeHistory() {
        if (this.canUndo()) {
            HistoryItem changeHistoryItem = this.fieldChangeHistory.get(--this.currentFieldChangeHistoryItem);
            HistoryItem reversedHistoryItem = new HistoryItem();
            reversedHistoryItem.newValue = changeHistoryItem.oldValue;
            reversedHistoryItem.oldValue = changeHistoryItem.newValue;
            reversedHistoryItem.targetField = changeHistoryItem.targetField;
            reversedHistoryItem.undoType = changeHistoryItem.undoType;
            this.makeChangeFromHistoryItem(reversedHistoryItem);
        }
    }

    public void redoFromFieldChangeHistory() {
        if (this.canRedo()) {
            HistoryItem changeHistoryItem = this.fieldChangeHistory.get(this.currentFieldChangeHistoryItem++);
            this.makeChangeFromHistoryItem(changeHistoryItem);
        }
    }

    public void clearFieldChangeHistory() {
        this.fieldChangeHistory = null;
        this.currentFieldChangeHistoryItem = 0;
    }

    private void makeChangeFromHistoryItem(HistoryItem historyItem) {
        String currentValue = null;
        switch (historyItem.undoType) {
            case KeyName: {
                currentValue = historyItem.targetField.getKeyName();
                break;
            }
            case LanguageId: {
                currentValue = historyItem.targetField.getLanguageId();
                break;
            }
            case Value: {
                currentValue = historyItem.targetField.getFieldValue();
            }
        }
        if (currentValue != null && !currentValue.equals(historyItem.oldValue)) {
            messageDialogHandler.addMessageDialogToQueue("The field value is out of sync with the history item", "Undo/Redo");
            bugCatcher.logException(new PluginException("ChangeFromHistory old value does not match current value"));
        } else {
            switch (historyItem.undoType) {
                case KeyName: {
                    historyItem.targetField.setKeyName(historyItem.newValue, true, true);
                    break;
                }
                case LanguageId: {
                    historyItem.targetField.setLanguageId(historyItem.newValue, true, true);
                    break;
                }
                case Value: {
                    historyItem.targetField.setFieldValue(historyItem.newValue, true, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveJournalEntry(String imdiUrl, String imdiNodePath, String oldValue, String newValue, String eventType) {
        boolean returnValue = false;
        FileWriter journalFile = null;
        try {
            journalFile = new FileWriter(this.getJournalFile(), true);
            logger.debug("Journal: " + imdiUrl + "," + imdiNodePath + "," + oldValue + "," + newValue);
            journalFile.append("\"" + imdiUrl + "#" + imdiNodePath + "\",\"" + oldValue + "\",\"" + newValue + "\",\"" + eventType + "\"\n");
            journalFile.close();
            journalFile = null;
            returnValue = true;
            if ("save".equals(eventType)) {
                this.wakeJounalWatchers(this.getJournalFile().length());
            }
        }
        catch (IOException ex) {
            returnValue = false;
            bugCatcher.logException(new PluginException("failed to write to the journal: " + ex.getMessage()));
            System.err.println("failed to write to the journal: " + ex.getMessage());
        }
        finally {
            if (journalFile != null) {
                try {
                    journalFile.close();
                }
                catch (IOException ioe) {
                    bugCatcher.logException(new PluginException("Failed to close the journal: " + ioe.getMessage()));
                }
            }
        }
        return returnValue;
    }

    public synchronized long getChangedFiles(long lastChangeIndex, Set<String> changedURIs) throws PluginException {
        try {
            File journalFile = this.getJournalFile();
            long journalLength = journalFile.length();
            if (journalLength > lastChangeIndex) {
                String readLine;
                FileReader fileReader = new FileReader(journalFile);
                LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
                lineNumberReader.skip(lastChangeIndex);
                while (null != (readLine = lineNumberReader.readLine())) {
                    if (!readLine.endsWith(",\"save\"")) continue;
                    String urlString = readLine.substring(1);
                    urlString = urlString.split("#", 2)[0];
                    changedURIs.add(urlString);
                }
            }
            return journalLength;
        }
        catch (FileNotFoundException exception) {
            throw new PluginException("Failed to read the journal file: " + exception.getMessage());
        }
        catch (IOException exception) {
            throw new PluginException("Failed to read the journal file: " + exception.getMessage());
        }
    }

    private void wakeJounalWatchers(final long journalLength) {
        new Thread(new Runnable(){

            public void run() {
                for (JournalWatcherPlugin jounalWatcher : ArbilJournal.this.jounalWatchers) {
                    try {
                        jounalWatcher.journalEvent(journalLength);
                    }
                    catch (PluginException exception) {
                        messageDialogHandler.addMessageDialogToQueue("Journal watcher plugin failed and has been removed:\n" + exception.getMessage(), "Wake Jounal Watchers");
                        ArbilJournal.this.jounalWatchers.remove(jounalWatcher);
                    }
                }
            }
        }, "JounalWatcherPlugins").start();
    }

    public void addJounalWatcher(JournalWatcherPlugin jounalWatcher) {
        this.jounalWatchers.add(jounalWatcher);
    }

    static {
        singleInstance = null;
    }

    private static class HistoryItem {
        HistoryField targetField;
        String oldValue;
        String newValue;
        UndoType undoType;

        private HistoryItem() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UndoType {
        Value,
        LanguageId,
        KeyName;

    }
}

