/*
 * Decompiled with CFR 0.152.
 */
package nl.nikhef.slcshttps.trust;

import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import nl.nikhef.slcshttps.trust.CertChainChecker;
import nl.nikhef.slcshttps.trust.HostnameChecker;

public class TrustCert {
    static HostnameChecker hostnameChecker = HostnameChecker.getInstance((byte)1);
    private X509Certificate x509Cert = null;
    private X509Certificate[] x509Chain;
    protected Hashtable<String, Status> knownAliases = new Hashtable();
    protected Status status = new Status();
    protected int chainFirstIdx = -1;
    protected Date chainFirstDate;
    protected long chainFirstMSec;
    protected int chainLastIdx = -1;
    protected Date chainLastDate;
    protected long chainLastMSec;
    protected int chainErrorIdx = -2;
    protected String chainError = null;

    private TrustCert() {
    }

    public TrustCert(X509Certificate[] x509CertificateArray) {
        this();
        this.setCertChain(x509CertificateArray);
    }

    private void setCertChain(X509Certificate[] x509CertificateArray) {
        this.x509Chain = x509CertificateArray;
        this.x509Cert = x509CertificateArray[0];
    }

    public boolean equals(TrustCert trustCert) {
        return this.x509Cert.equals(trustCert.x509Cert);
    }

    public boolean equals(X509Certificate x509Certificate) {
        return this.x509Cert.equals(x509Certificate);
    }

    public boolean checkValidity() throws CertificateException {
        if (this.chainFirstIdx == -1 || this.chainLastIdx == -1) {
            this.setExtremes();
        }
        long l = new Date().getTime();
        this.status.expired = false;
        this.status.notYet = false;
        if (l < this.chainFirstMSec) {
            this.status.notYet = true;
        }
        if (l > this.chainLastMSec) {
            this.status.expired = true;
        }
        return !this.status.expired && !this.status.notYet;
    }

    public boolean checkHostname(String string) throws CertificateException {
        try {
            hostnameChecker.match(string, this.x509Cert);
            this.status.nameValid = true;
        }
        catch (CertificateException certificateException) {
            this.status.nameValid = false;
        }
        catch (Exception exception) {
            this.status.nameValid = false;
            throw new CertificateException("Error processing hostname check: " + exception.getMessage());
        }
        return this.status.nameValid;
    }

    public boolean checkChain() throws CertificateException {
        try {
            CertChainChecker.validate(this.x509Chain, this.chainLastDate);
            this.chainErrorIdx = 0;
            this.chainError = null;
        }
        catch (CertPathValidatorException certPathValidatorException) {
            this.chainErrorIdx = certPathValidatorException.getIndex();
            this.chainError = certPathValidatorException.getMessage();
            if (this.chainError == null) {
                this.chainError = "";
            }
        }
        catch (Exception exception) {
            this.chainErrorIdx = -2;
            this.chainError = "Error processing certificate chain: " + exception.getMessage();
            throw new CertificateException("Error processing certificate chain: " + exception.getMessage());
        }
        return this.chainError == null;
    }

    public Status getStatus(String string) {
        return this.knownAliases.get(string);
    }

    public void addAlias(String string) {
        this.knownAliases.put(string, this.status.copy());
    }

    public void removeAlias(String string) {
        this.knownAliases.remove(string);
    }

    protected void setExtremes() throws CertificateException {
        if (this.x509Cert == null || this.x509Chain == null) {
            throw new CertificateException("Certificate or chain is not yet set");
        }
        this.chainFirstIdx = 0;
        this.chainFirstDate = this.x509Chain[0].getNotBefore();
        this.chainFirstMSec = this.chainFirstDate.getTime();
        this.chainLastIdx = 0;
        this.chainLastDate = this.x509Chain[0].getNotAfter();
        this.chainLastMSec = this.chainLastDate.getTime();
        for (int i = 1; i < this.x509Chain.length; ++i) {
            Date date = this.x509Chain[i].getNotBefore();
            long l = date.getTime();
            if (l > this.chainFirstMSec) {
                this.chainFirstIdx = i;
                this.chainFirstMSec = l;
                this.chainFirstDate = date;
            }
            if ((l = (date = this.x509Chain[i].getNotAfter()).getTime()) >= this.chainLastMSec) continue;
            this.chainLastIdx = i;
            this.chainLastMSec = l;
            this.chainLastDate = date;
        }
    }

    protected String getAliasErrors(String string) {
        Status status = this.getStatus(string);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (!status.nameValid) {
            stringBuffer.append("hostname doesn't match");
            bl = true;
        }
        if (status.expired) {
            stringBuffer.append(bl ? ", expired chain" : "expired chain");
            bl = true;
        }
        if (status.notYet) {
            stringBuffer.append(bl ? ", not-yet-valid chain" : "not-yet-valid chain");
            bl = true;
        }
        if (this.chainError != null) {
            stringBuffer.append(bl ? ", cert chain failed" : "cert chain failed");
            bl = true;
        }
        if (bl) {
            return string + ": " + stringBuffer.toString();
        }
        return null;
    }

    protected String[] getOldErrors() {
        Vector<String> vector = new Vector<String>();
        Enumeration<String> enumeration = this.knownAliases.keys();
        while (enumeration.hasMoreElements()) {
            String string = this.getAliasErrors(enumeration.nextElement());
            if (string == null) continue;
            vector.add(string);
        }
        int n = vector.size();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        vector.toArray(stringArray);
        return stringArray;
    }

    protected String[] getErrors(String string) {
        Vector<String> vector = new Vector<String>();
        if (!this.status.nameValid) {
            vector.add("Host \"" + string + "\" is not valid for certificate");
        }
        if (this.status.expired) {
            vector.add("Certificate chain expired " + this.chainLastDate.toString() + " (cert no. " + this.chainLastIdx + ")");
        }
        if (this.status.notYet) {
            vector.add("Certificate chain is not yet valid " + this.chainFirstDate.toString() + " (cert no. " + this.chainFirstIdx + ")");
        }
        if (this.chainErrorIdx != -2 && this.chainError != null) {
            vector.add("Certificate chain failed validation" + (this.chainErrorIdx == -1 ? ": " : " (cert no. " + this.chainErrorIdx + "): ") + this.chainError);
        }
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    protected class Status {
        public boolean nameValid;
        public boolean expired;
        public boolean notYet;

        protected Status() {
        }

        public Status copy() {
            return this.copy(null);
        }

        public Status copy(Status status) {
            Status status2 = status == null ? new Status() : status;
            status2.nameValid = this.nameValid;
            status2.expired = this.expired;
            status2.notYet = this.notYet;
            return status2;
        }
    }
}

